/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.params.EcDomainParameters;
import org.bouncycastle.crypto.internal.params.EcKeyParameters;
import org.bouncycastle.crypto.internal.params.EcPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.EcPublicKeyParameters;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECMultiplier;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class DSTU4145Signer
implements DSA {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private EcKeyParameters key;
    private SecureRandom random;

    DSTU4145Signer() {
    }

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (!(param instanceof ParametersWithRandom)) {
                throw new IllegalArgumentException("No SecureRandom provided when one required");
            }
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.random = rParam.getRandom();
            param = rParam.getParameters();
            this.key = (EcPrivateKeyParameters)param;
        } else {
            this.key = (EcPublicKeyParameters)param;
        }
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        BigInteger s;
        ECFieldElement y;
        BigInteger r;
        BigInteger e;
        ECFieldElement Fe;
        EcDomainParameters ec = this.key.getParameters();
        ECCurve curve = ec.getCurve();
        ECFieldElement h = DSTU4145Signer.hash2FieldElement(curve, message);
        if (h.isZero()) {
            h = curve.fromBigInteger(ONE);
        }
        BigInteger n = ec.getN();
        BigInteger d = ((EcPrivateKeyParameters)this.key).getD();
        ECMultiplier basePointMultiplier = this.createBasePointMultiplier();
        do {
            e = DSTU4145Signer.generateRandomInteger(n, this.random);
        } while ((Fe = basePointMultiplier.multiply(ec.getG(), e).normalize().getAffineXCoord()).isZero() || (r = DSTU4145Signer.fieldElement2Integer(n, y = h.multiply(Fe))).signum() == 0 || (s = r.multiply(d).add(e).mod(n)).signum() == 0);
        return new BigInteger[]{r, s};
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s) {
        ECPoint R;
        if (r.signum() <= 0 || s.signum() <= 0) {
            return false;
        }
        EcDomainParameters parameters = this.key.getParameters();
        BigInteger n = parameters.getN();
        if (r.compareTo(n) >= 0 || s.compareTo(n) >= 0) {
            return false;
        }
        ECCurve curve = parameters.getCurve();
        ECFieldElement h = DSTU4145Signer.hash2FieldElement(curve, message);
        if (h.isZero()) {
            h = curve.fromBigInteger(ONE);
        }
        if ((R = ECAlgorithms.sumOfTwoMultiplies(parameters.getG(), s, ((EcPublicKeyParameters)this.key).getQ(), r).normalize()).isInfinity()) {
            return false;
        }
        ECFieldElement y = h.multiply(R.getAffineXCoord());
        return DSTU4145Signer.fieldElement2Integer(n, y).compareTo(r) == 0;
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    private static BigInteger generateRandomInteger(BigInteger n, SecureRandom random) {
        return new BigInteger(n.bitLength() - 1, random);
    }

    private static ECFieldElement hash2FieldElement(ECCurve curve, byte[] hash) {
        byte[] data = Arrays.reverse(hash);
        return curve.fromBigInteger(DSTU4145Signer.truncate(new BigInteger(1, data), curve.getFieldSize()));
    }

    private static BigInteger fieldElement2Integer(BigInteger n, ECFieldElement fe) {
        return DSTU4145Signer.truncate(fe.toBigInteger(), n.bitLength() - 1);
    }

    private static BigInteger truncate(BigInteger x, int bitLength) {
        if (x.bitLength() > bitLength) {
            x = x.mod(ONE.shiftLeft(bitLength));
        }
        return x;
    }
}

