/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.InvalidSignatureException;
import org.bouncycastle.crypto.OutputSignerUsingSecureRandom;
import org.bouncycastle.crypto.OutputValidator;
import org.bouncycastle.crypto.OutputVerifier;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSAPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSAPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.DSADomainParameters;
import org.bouncycastle.crypto.asymmetric.DSAValidationParameters;
import org.bouncycastle.crypto.fips.FipsDSA;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.general.DSAOutputSigner;
import org.bouncycastle.crypto.general.DSAOutputValidator;
import org.bouncycastle.crypto.general.DSAOutputVerifier;
import org.bouncycastle.crypto.general.DsaKeyPairGenerator;
import org.bouncycastle.crypto.general.DsaParametersGenerator;
import org.bouncycastle.crypto.general.DsaSigner;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GuardedAsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.general.GuardedSignatureOperatorUsingSecureRandomFactory;
import org.bouncycastle.crypto.general.HMacDsaKCalculator;
import org.bouncycastle.crypto.general.NullDigest;
import org.bouncycastle.crypto.general.RandomDsaKCalculator;
import org.bouncycastle.crypto.general.Register;
import org.bouncycastle.crypto.general.SelfTestExecutor;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.PrimeCertaintyCalculator;
import org.bouncycastle.crypto.internal.params.DsaKeyGenerationParameters;
import org.bouncycastle.crypto.internal.params.DsaParameterGenerationParameters;
import org.bouncycastle.crypto.internal.params.DsaParameters;
import org.bouncycastle.crypto.internal.params.DsaPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.DsaPublicKeyParameters;
import org.bouncycastle.crypto.internal.params.DsaValidationParameters;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.crypto.internal.test.ConsistencyTest;
import org.bouncycastle.util.Properties;
import org.bouncycastle.util.encoders.Hex;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class DSA {
    public static final Algorithm ALGORITHM = FipsDSA.ALGORITHM;
    public static final Parameters DSA = new Parameters(new GeneralAlgorithm(ALGORITHM.getName(), (Enum)Variations.DSA), FipsSHS.Algorithm.SHA1);
    public static final Parameters DDSA = new Parameters(new GeneralAlgorithm(ALGORITHM.getName(), (Enum)Variations.DDSA), FipsSHS.Algorithm.SHA1);

    private DSA() {
    }

    private static void validateKeyPair(AsymmetricCipherKeyPair kp) {
        SelfTestExecutor.validate(ALGORITHM, kp, new ConsistencyTest<AsymmetricCipherKeyPair>(){

            @Override
            public boolean hasTestPassed(AsymmetricCipherKeyPair kp) {
                byte[] data = Hex.decode("576a1f885e3420128c8a656097ba7d8bb4c6f1b1853348cf2ba976971dbdbefc");
                DsaSigner signer = new DsaSigner(new RandomDsaKCalculator());
                signer.init(true, new ParametersWithRandom(kp.getPrivate(), Utils.testRandom));
                BigInteger[] rv = signer.generateSignature(data);
                signer.init(false, kp.getPublic());
                return signer.verifySignature(data, rv[0], rv[1]);
            }
        });
    }

    private static DsaParameters getDomainParams(DSADomainParameters dsaParams) {
        return new DsaParameters(dsaParams.getP(), dsaParams.getQ(), dsaParams.getG());
    }

    private static DsaPrivateKeyParameters getLwKey(final AsymmetricDSAPrivateKey privKey) {
        return AccessController.doPrivileged(new PrivilegedAction<DsaPrivateKeyParameters>(){

            @Override
            public DsaPrivateKeyParameters run() {
                return new DsaPrivateKeyParameters(privKey.getX(), org.bouncycastle.crypto.general.DSA.getDomainParams(privKey.getDomainParameters()));
            }
        });
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class OperatorFactory
    extends GuardedSignatureOperatorUsingSecureRandomFactory<Parameters> {
        @Override
        protected OutputSignerUsingSecureRandom<Parameters> doCreateSigner(AsymmetricPrivateKey key, Parameters parameters) {
            Digest digest = parameters.digestAlgorithm != null ? Register.createDigest(parameters.digestAlgorithm) : new NullDigest();
            DsaSigner dsaSigner = parameters.getAlgorithm() == DSA.getAlgorithm() ? new DsaSigner(new RandomDsaKCalculator()) : new DsaSigner(new HMacDsaKCalculator(Register.createDigest(parameters.digestAlgorithm)));
            AsymmetricDSAPrivateKey k = (AsymmetricDSAPrivateKey)key;
            final DsaPrivateKeyParameters privateKeyParameters = org.bouncycastle.crypto.general.DSA.getLwKey(k);
            return new DSAOutputSigner<Parameters>(dsaSigner, digest, parameters, new DSAOutputSigner.Initializer(){

                @Override
                public void initialize(org.bouncycastle.crypto.internal.DSA signer, SecureRandom random) {
                    signer.init(true, new ParametersWithRandom(privateKeyParameters, random));
                }
            });
        }

        @Override
        protected OutputVerifier<Parameters> doCreateVerifier(AsymmetricPublicKey key, Parameters parameters) {
            Digest digest = parameters.digestAlgorithm != null ? Register.createDigest(parameters.digestAlgorithm) : new NullDigest();
            DsaSigner dsaSigner = parameters.getAlgorithm() == DSA.getAlgorithm() ? new DsaSigner(new RandomDsaKCalculator()) : new DsaSigner(new HMacDsaKCalculator(Register.createDigest(parameters.digestAlgorithm)));
            AsymmetricDSAPublicKey k = (AsymmetricDSAPublicKey)key;
            DsaPublicKeyParameters publicKeyParameters = new DsaPublicKeyParameters(k.getY(), org.bouncycastle.crypto.general.DSA.getDomainParams(k.getDomainParameters()));
            dsaSigner.init(false, publicKeyParameters);
            return new DSAOutputVerifier<Parameters>(dsaSigner, digest, parameters);
        }

        @Override
        protected OutputValidator<Parameters> doCreateValidator(AsymmetricPublicKey key, Parameters parameters, byte[] signature) throws InvalidSignatureException {
            Digest digest = parameters.digestAlgorithm != null ? Register.createDigest(parameters.digestAlgorithm) : new NullDigest();
            DsaSigner dsaSigner = parameters.getAlgorithm() == DSA.getAlgorithm() ? new DsaSigner(new RandomDsaKCalculator()) : new DsaSigner(new HMacDsaKCalculator(Register.createDigest(parameters.digestAlgorithm)));
            AsymmetricDSAPublicKey k = (AsymmetricDSAPublicKey)key;
            DsaPublicKeyParameters publicKeyParameters = new DsaPublicKeyParameters(k.getY(), org.bouncycastle.crypto.general.DSA.getDomainParams(k.getDomainParameters()));
            dsaSigner.init(false, publicKeyParameters);
            return new DSAOutputValidator<Parameters>(dsaSigner, digest, parameters, signature);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class KeyPairGenerator
    extends GuardedAsymmetricKeyPairGenerator<KeyGenParameters, AsymmetricDSAPublicKey, AsymmetricDSAPrivateKey> {
        private final DsaKeyPairGenerator engine = new DsaKeyPairGenerator();
        private final DSADomainParameters domainParameters;
        private final DsaKeyGenerationParameters param;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom random) {
            super(keyGenParameters);
            this.domainParameters = keyGenParameters.getDomainParameters();
            this.param = new DsaKeyGenerationParameters(random, org.bouncycastle.crypto.general.DSA.getDomainParams(this.domainParameters));
            this.engine.init(this.param);
        }

        @Override
        protected AsymmetricKeyPair<AsymmetricDSAPublicKey, AsymmetricDSAPrivateKey> doGenerateKeyPair() {
            AsymmetricCipherKeyPair kp = this.engine.generateKeyPair();
            org.bouncycastle.crypto.general.DSA.validateKeyPair(kp);
            DsaPublicKeyParameters pubKey = (DsaPublicKeyParameters)kp.getPublic();
            DsaPrivateKeyParameters prvKey = (DsaPrivateKeyParameters)kp.getPrivate();
            Object algorithm = ((KeyGenParameters)this.getParameters()).getAlgorithm();
            return new AsymmetricKeyPair<AsymmetricDSAPublicKey, AsymmetricDSAPrivateKey>(new AsymmetricDSAPublicKey((Algorithm)algorithm, this.domainParameters, pubKey.getY()), new AsymmetricDSAPrivateKey((Algorithm)algorithm, this.domainParameters, prvKey.getX()));
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class DomainParametersGenerator {
        private final SecureRandom random;
        private final DomainGenParameters parameters;

        public DomainParametersGenerator(DomainGenParameters parameters, SecureRandom random) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                throw new FipsUnapprovedOperationError("Attempt to create unapproved generator in approved only mode.");
            }
            this.parameters = parameters;
            this.random = random;
        }

        public DSADomainParameters generateDomainParameters() {
            DsaParametersGenerator pGen = this.parameters.strength <= 1024 ? new DsaParametersGenerator() : new DsaParametersGenerator(Register.createDigest(FipsSHS.Algorithm.SHA256));
            if (this.parameters.strength == 1024) {
                if (Properties.isOverrideSet("org.bouncycastle.dsa.FIPS186-2for1024bits")) {
                    pGen.init(this.parameters.strength, this.parameters.certainty, this.random);
                } else {
                    DsaParameterGenerationParameters params = new DsaParameterGenerationParameters(1024, 160, this.parameters.certainty, this.random);
                    pGen.init(params);
                }
            } else if (this.parameters.strength > 1024) {
                DsaParameterGenerationParameters params = new DsaParameterGenerationParameters(this.parameters.strength, 256, this.parameters.certainty, this.random);
                pGen.init(params);
            } else {
                pGen.init(this.parameters.strength, this.parameters.certainty, this.random);
            }
            DsaParameters p = pGen.generateParameters();
            DsaValidationParameters validationParameters = p.getValidationParameters();
            return new DSADomainParameters(p.getP(), p.getQ(), p.getG(), new DSAValidationParameters(validationParameters.getSeed(), validationParameters.getCounter(), validationParameters.getUsageIndex()));
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class DomainGenParameters
    extends GeneralParameters {
        private final int strength;
        private final int certainty;

        public DomainGenParameters(int strength) {
            this(strength, PrimeCertaintyCalculator.getDefaultCertainty(strength));
        }

        public DomainGenParameters(int strength, int certainty) {
            super(ALGORITHM);
            this.strength = strength;
            this.certainty = certainty;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class KeyGenParameters
    extends GeneralParameters {
        private final DSADomainParameters domainParameters;

        public KeyGenParameters(Parameters parameters, DSADomainParameters domainParameters) {
            super(parameters.getAlgorithm());
            this.domainParameters = domainParameters;
        }

        public KeyGenParameters(DSADomainParameters domainParameters) {
            super(ALGORITHM);
            this.domainParameters = domainParameters;
        }

        public DSADomainParameters getDomainParameters() {
            return this.domainParameters;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class Parameters
    extends GeneralParameters {
        private final DigestAlgorithm digestAlgorithm;

        Parameters(GeneralAlgorithm type, DigestAlgorithm digestAlgorithm) {
            super(type);
            if (type.basicVariation() == Variations.DDSA && digestAlgorithm == null) {
                throw new IllegalArgumentException("DDSA cannot be used with a NULL digest");
            }
            this.digestAlgorithm = digestAlgorithm;
        }

        public DigestAlgorithm getDigestAlgorithm() {
            return this.digestAlgorithm;
        }

        public Parameters withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), digestAlgorithm);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static enum Variations {
        DSA,
        DDSA;

    }
}

