/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.macs.CMac;
import org.bouncycastle.crypto.internal.macs.HMac;
import org.bouncycastle.crypto.internal.params.HKDFKeyParameters;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class TwoStepKeyGenerator {
    private Mac mac;
    private int macLen;

    public TwoStepKeyGenerator(Mac mac) {
        this.mac = mac;
        this.macLen = mac instanceof HMac ? ((HMac)mac).getUnderlyingDigest().getDigestSize() : ((CMac)mac).getMacSize();
    }

    public KeyParameter generate(HKDFKeyParameters params) {
        return this.extract(params.getSalt(), params.getIKM());
    }

    private KeyParameter extract(byte[] salt, byte[] ikm) {
        if (salt == null) {
            this.mac.init(new KeyParameterImpl(new byte[this.macLen]));
        } else {
            this.mac.init(new KeyParameterImpl(salt));
        }
        this.mac.update(ikm, 0, ikm.length);
        byte[] prk = new byte[this.macLen];
        this.mac.doFinal(prk, 0);
        return new KeyParameterImpl(prk);
    }
}

