/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.lang.ref.Reference;
import org.bouncycastle.crypto.internal.ExtendedDigest;
import org.bouncycastle.crypto.util.dispose.NativeDisposer;
import org.bouncycastle.crypto.util.dispose.NativeReference;
import org.bouncycastle.util.Memoable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class SHA256NativeDigest
implements ExtendedDigest,
Memoable {
    protected DigestRefWrapper nativeRef = new DigestRefWrapper(SHA256NativeDigest.makeNative());

    SHA256NativeDigest() {
        this.reset();
    }

    SHA256NativeDigest(SHA256NativeDigest src) {
        this();
        byte[] state = src.getEncodedState();
        SHA256NativeDigest.restoreFullState(this.nativeRef.getReference(), state, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SHA256NativeDigest restoreState(byte[] state, int offset) {
        try {
            SHA256NativeDigest.restoreFullState(this.nativeRef.getReference(), state, offset);
            SHA256NativeDigest sHA256NativeDigest = this;
            return sHA256NativeDigest;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-256";
    }

    @Override
    public int getDigestSize() {
        try {
            int n = SHA256NativeDigest.getDigestSize(this.nativeRef.getReference());
            return n;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public void update(byte in) {
        try {
            SHA256NativeDigest.update(this.nativeRef.getReference(), in);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(byte[] input, int inOff, int len) {
        try {
            SHA256NativeDigest.update(this.nativeRef.getReference(), input, inOff, len);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doFinal(byte[] output, int outOff) {
        try {
            int n = SHA256NativeDigest.doFinal(this.nativeRef.getReference(), output, outOff);
            return n;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public void reset() {
        try {
            SHA256NativeDigest.reset(this.nativeRef.getReference());
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public int getByteLength() {
        try {
            int n = SHA256NativeDigest.getByteLength(this.nativeRef.getReference());
            return n;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public Memoable copy() {
        try {
            SHA256NativeDigest sHA256NativeDigest = new SHA256NativeDigest(this);
            return sHA256NativeDigest;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public void reset(Memoable other) {
        try {
            SHA256NativeDigest dig = (SHA256NativeDigest)other;
            SHA256NativeDigest.restoreFullState(this.nativeRef.getReference(), dig.getEncodedState(), 0);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getEncodedState() {
        try {
            int l = SHA256NativeDigest.encodeFullState(this.nativeRef.getReference(), null, 0);
            byte[] state = new byte[l];
            SHA256NativeDigest.encodeFullState(this.nativeRef.getReference(), state, 0);
            byte[] byArray = state;
            return byArray;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    void restoreFullState(byte[] encoded, int offset) {
        try {
            SHA256NativeDigest.restoreFullState(this.nativeRef.getReference(), encoded, offset);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    public String toString() {
        return "SHA256[Native]()";
    }

    static native long makeNative();

    static native void destroy(long var0);

    static native int getDigestSize(long var0);

    static native void update(long var0, byte var2);

    static native void update(long var0, byte[] var2, int var3, int var4);

    static native int doFinal(long var0, byte[] var2, int var3);

    static native void reset(long var0);

    static native int getByteLength(long var0);

    static native int encodeFullState(long var0, byte[] var2, int var3);

    static native void restoreFullState(long var0, byte[] var2, int var3);

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class DigestRefWrapper
    extends NativeReference {
        public DigestRefWrapper(long reference) {
            super(reference);
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Disposer
    extends NativeDisposer {
        Disposer(long ref) {
            super(ref);
        }

        @Override
        protected void dispose(long reference) {
            SHA256NativeDigest.destroy(reference);
        }
    }
}

