/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class LoaderUtils {
    private static final Logger LOG = Logger.getLogger(LoaderUtils.class.getName());

    LoaderUtils() {
    }

    static File createTempDir(final String moduleName) throws IOException {
        if (moduleName == null) {
            throw new NullPointerException("moduleName cannot be null");
        }
        final String prefixPath = LoaderUtils.getPropertyValue("java.io.tmpdir");
        try {
            return AccessController.doPrivileged(new PrivilegedAction<File>(){

                @Override
                public File run() {
                    File prefix = new File(prefixPath);
                    if (prefix.isFile()) {
                        throw new IllegalStateException(String.format("'%s' exists and is a file", prefixPath));
                    }
                    if (!prefix.exists() && !prefix.mkdirs()) {
                        throw new IllegalStateException(String.format("failed to create temporary directory '%s'", prefixPath));
                    }
                    long now = System.nanoTime();
                    for (int t = 0; t < 10000; ++t) {
                        File dir = new File(prefix, String.format("%s_%d", moduleName, now + (long)t));
                        if (dir.exists() || !dir.mkdirs()) continue;
                        final File tmpDir = dir;
                        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                            @Override
                            public void run() {
                                if (LOG.isLoggable(Level.FINE)) {
                                    LOG.fine("cleanup shutdown hook started");
                                }
                                if (!tmpDir.exists()) {
                                    return;
                                }
                                boolean isDeleted = true;
                                if (tmpDir.isDirectory()) {
                                    for (File f : tmpDir.listFiles()) {
                                        isDeleted &= f.delete();
                                    }
                                }
                                if (!(isDeleted &= tmpDir.delete())) {
                                    LOG.fine("failed to delete: " + tmpDir.getAbsolutePath());
                                } else {
                                    LOG.fine("successfully cleaned up: " + tmpDir.getAbsolutePath());
                                }
                            }
                        }));
                        return dir;
                    }
                    throw new IllegalStateException(String.format("failed to create temporary directory in '%s'", prefixPath));
                }
            });
        }
        catch (IllegalStateException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    static File createVersionedTempDir(final String prefixPath, final String version) throws IOException {
        if (version == null) {
            throw new NullPointerException("version cannot be null");
        }
        try {
            return AccessController.doPrivileged(new PrivilegedAction<File>(){

                @Override
                public File run() {
                    File prefix = new File(new File(prefixPath), version);
                    if (prefix.isFile()) {
                        throw new IllegalStateException(String.format("'%s' exists and is a file", prefixPath));
                    }
                    if (!prefix.exists() && !prefix.mkdirs()) {
                        throw new IllegalStateException(String.format("failed to create temporary directory '%s'", prefixPath));
                    }
                    return prefix;
                }
            });
        }
        catch (IllegalStateException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    static File extractFromClasspath(final File tmpDir, final String pathInJar, final String name) throws Exception {
        return AccessController.doPrivileged(new PrivilegedAction<File>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public File run() {
                InputStream in = LoaderUtils.class.getResourceAsStream(pathInJar);
                if (in == null) {
                    return null;
                }
                File savedFile = new File(tmpDir, name);
                if (savedFile.exists()) {
                    if (savedFile.isDirectory()) {
                        throw new IllegalStateException("extracted file name '" + savedFile.getAbsolutePath() + "' is actually a directory and already exists");
                    }
                    try (FileInputStream fin = new FileInputStream(savedFile);){
                        if (!LoaderUtils.isContentSame(fin, in)) throw new IllegalStateException("existing file name '" + savedFile.getAbsolutePath() + "' does not match expected file content");
                        File file = savedFile;
                        return file;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException("unable to read exising extracted library" + savedFile.getAbsolutePath(), ex);
                    }
                }
                try (FileOutputStream fos = new FileOutputStream(savedFile);){
                    int len;
                    byte[] buf = new byte[8192];
                    while ((len = in.read(buf)) > -1) {
                        fos.write(buf, 0, len);
                    }
                    fos.flush();
                    return savedFile;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    static List<String> readStreamToLines(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
                lines.add(line);
            }
        }
        return lines;
    }

    private static boolean isContentSame(InputStream left, InputStream right) {
        BufferedInputStream binLeft = null;
        BufferedInputStream binRight = null;
        try {
            binLeft = new BufferedInputStream(left);
            binRight = new BufferedInputStream(right);
            int vLeft = 0;
            int vRight = 0;
            while (vLeft >= 0) {
                vLeft = binLeft.read();
                if (vLeft == (vRight = binRight.read())) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        finally {
            try {
                binLeft.close();
            }
            catch (Exception exception) {}
            try {
                binRight.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    private static String getPropertyValue(final String propertyName) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String v = Security.getProperty(propertyName);
                if (v != null) {
                    return v;
                }
                return System.getProperty(propertyName);
            }
        });
    }
}

