/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPublicKey;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.crypto.fips.EcDhcuBasicAgreement;
import org.bouncycastle.crypto.fips.FipsAgreement;
import org.bouncycastle.crypto.fips.FipsAgreementParameters;
import org.bouncycastle.crypto.fips.FipsEC;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.internal.params.EcDhuPublicParameters;
import org.bouncycastle.crypto.internal.params.EcDomainParameters;
import org.bouncycastle.crypto.internal.params.EcNamedDomainParameters;
import org.bouncycastle.crypto.internal.params.EcPublicKeyParameters;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class EcDHUAgreement<T extends FipsAgreementParameters>
extends FipsAgreement<T> {
    private final EcDhcuBasicAgreement dh;
    private final T parameter;

    EcDHUAgreement(EcDhcuBasicAgreement dh, T parameter) {
        this.dh = dh;
        this.parameter = parameter;
    }

    @Override
    public T getParameters() {
        return this.parameter;
    }

    @Override
    public byte[] calculate(AsymmetricPublicKey key) {
        AsymmetricECPublicKey ecKey = (AsymmetricECPublicKey)key;
        EcPublicKeyParameters lwECKey = new EcPublicKeyParameters(ecKey.getW(), EcDHUAgreement.getDomainParams(ecKey.getDomainParameters()));
        AsymmetricECPublicKey ephPublicKey = ((FipsEC.DHUAgreementParameters)this.parameter).getOtherPartyEphemeralKey();
        byte[] zBytes = this.dh.calculateAgreement(new EcDhuPublicParameters(lwECKey, new EcPublicKeyParameters(ephPublicKey.getW(), EcDHUAgreement.getDomainParams(ephPublicKey.getDomainParameters()))));
        return FipsKDF.processZBytes(zBytes, this.parameter);
    }

    private static EcDomainParameters getDomainParams(ECDomainParameters curveParams) {
        if (curveParams instanceof NamedECDomainParameters) {
            return new EcNamedDomainParameters((NamedECDomainParameters)curveParams);
        }
        return new EcDomainParameters(curveParams);
    }
}

