/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ua.DSTU4145NamedCurves;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.asymmetric.CustomNamedCurves;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.ECDomainParametersID;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ECDomainParametersIndex {
    public static NamedECDomainParameters lookupDomainParameters(ASN1ObjectIdentifier paramOid) {
        X9ECParameters rv = CustomNamedCurves.getByOID(paramOid);
        if (rv == null) {
            rv = ECNamedCurveTable.getByOID(paramOid);
        }
        if (rv != null) {
            return new NamedECDomainParameters(paramOid, rv.getCurve(), rv.getG(), rv.getN(), rv.getH(), rv.getSeed());
        }
        ECDomainParameters ecRV = DSTU4145NamedCurves.getByOID(paramOid);
        if (ecRV != null) {
            return new NamedECDomainParameters(paramOid, ecRV.getCurve(), ecRV.getG(), ecRV.getN(), ecRV.getH(), ecRV.getSeed());
        }
        return null;
    }

    public static NamedECDomainParameters lookupDomainParameters(ECDomainParametersID paramID) {
        ASN1ObjectIdentifier oid;
        String curveName = paramID.getCurveName();
        X9ECParameters rv = CustomNamedCurves.getByName(curveName);
        if (rv == null) {
            rv = ECNamedCurveTable.getByName(curveName);
        }
        if (rv != null && (oid = ECNamedCurveTable.getOID(curveName)) != null) {
            return new NamedECDomainParameters(oid, rv.getCurve(), rv.getG(), rv.getN(), rv.getH(), rv.getSeed());
        }
        return null;
    }

    public static ASN1ObjectIdentifier lookupOID(ECDomainParameters domainParameters) {
        Enumeration en = ECNamedCurveTable.getNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            X9ECParameters rv = ECNamedCurveTable.getByName(name);
            if (rv == null || rv.getN() == null || !rv.getN().equals(domainParameters.getN())) continue;
            return ECNamedCurveTable.getOID(name);
        }
        return null;
    }
}

