/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.math.BigInteger;
import org.bouncycastle.crypto.asymmetric.DSAValidationParameters;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DSADomainParameters {
    private BigInteger g;
    private BigInteger q;
    private BigInteger p;
    private DSAValidationParameters validation;

    public DSADomainParameters(BigInteger p, BigInteger q, BigInteger g) {
        this.g = g;
        this.p = p;
        this.q = q;
    }

    public DSADomainParameters(BigInteger p, BigInteger q, BigInteger g, DSAValidationParameters params) {
        this.g = g;
        this.p = p;
        this.q = q;
        this.validation = params;
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getG() {
        return this.g;
    }

    public DSAValidationParameters getValidationParameters() {
        return this.validation;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DSADomainParameters)) {
            return false;
        }
        DSADomainParameters pm = (DSADomainParameters)obj;
        return pm.getP().equals(this.p) && pm.getQ().equals(this.q) && pm.getG().equals(this.g);
    }

    public int hashCode() {
        int result = this.g.hashCode();
        result = 31 * result + this.p.hashCode();
        result = 31 * result + this.q.hashCode();
        return result;
    }
}

