/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricXDHKey;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.general.EdEC;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AsymmetricXDHPublicKey
extends AsymmetricXDHKey
implements AsymmetricPublicKey {
    static final byte[] x448Prefix = Hex.decode("3042300506032b656f033900");
    static final byte[] x25519Prefix = Hex.decode("302a300506032b656e032100");
    private static final byte x448_type = 111;
    private static final byte x25519_type = 110;
    private final byte[] keyData;
    private final int hashCode;

    public AsymmetricXDHPublicKey(Algorithm algorithm, byte[] keyData) {
        super(algorithm);
        this.keyData = Arrays.clone(keyData);
        this.hashCode = this.calculateHashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AsymmetricXDHPublicKey(byte[] encoding) {
        super(encoding[8] == 111 ? EdEC.Algorithm.X448 : EdEC.Algorithm.X25519);
        if (encoding[8] == 111) {
            if (!KeyUtils.isValidPrefix(x448Prefix, encoding) || encoding.length - x448Prefix.length != 56) throw new IllegalArgumentException("raw key data not recognised");
            this.keyData = Arrays.copyOfRange(encoding, x448Prefix.length, encoding.length);
        } else {
            if (!KeyUtils.isValidPrefix(x25519Prefix, encoding) || encoding.length - x25519Prefix.length != 32) throw new IllegalArgumentException("raw key data not recognised");
            this.keyData = Arrays.copyOfRange(encoding, x25519Prefix.length, encoding.length);
        }
        this.hashCode = this.calculateHashCode();
    }

    public byte[] getPublicData() {
        return Arrays.clone(this.keyData);
    }

    @Override
    public byte[] getEncoded() {
        if (this.getAlgorithm().equals(EdEC.Algorithm.X448)) {
            byte[] encoding = new byte[x448Prefix.length + this.keyData.length];
            System.arraycopy(x448Prefix, 0, encoding, 0, x448Prefix.length);
            System.arraycopy(this.keyData, 0, encoding, x448Prefix.length, this.keyData.length);
            return encoding;
        }
        byte[] encoding = new byte[x25519Prefix.length + this.keyData.length];
        System.arraycopy(x25519Prefix, 0, encoding, 0, x25519Prefix.length);
        System.arraycopy(this.keyData, 0, encoding, x25519Prefix.length, this.keyData.length);
        return encoding;
    }

    @Override
    public boolean equals(Object o) {
        this.checkApprovedOnlyModeStatus();
        if (this == o) {
            return true;
        }
        if (!(o instanceof AsymmetricXDHPublicKey)) {
            return false;
        }
        AsymmetricXDHPublicKey other = (AsymmetricXDHPublicKey)o;
        if (!Arrays.areEqual(this.keyData, other.keyData)) {
            return false;
        }
        return this.getAlgorithm().equals(other.getAlgorithm());
    }

    @Override
    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int result = this.getAlgorithm().hashCode();
        result = 31 * result + Arrays.hashCode(this.keyData);
        return result;
    }
}

