/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import javax.security.auth.Destroyable;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPrivateKey;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.jcajce.provider.ECUtil;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.ProvKey;

class ProvECPrivateKey
implements Destroyable,
ECPrivateKey,
ProvKey<AsymmetricECPrivateKey> {
    static final long serialVersionUID = 994553197664784084L;
    private transient AsymmetricECPrivateKey baseKey;

    ProvECPrivateKey(Algorithm algorithm, ECPrivateKey key) {
        ECDomainParameters domainParameters = ECUtil.convertFromSpec(key.getParams());
        this.baseKey = new AsymmetricECPrivateKey(algorithm, domainParameters, key.getS());
    }

    ProvECPrivateKey(Algorithm algorithm, ECPrivateKeySpec keySpec) {
        this.baseKey = new AsymmetricECPrivateKey(algorithm, ECUtil.convertFromSpec(keySpec.getParams()), keySpec.getS());
    }

    ProvECPrivateKey(AsymmetricECPrivateKey key) {
        this.baseKey = key;
    }

    @Override
    public AsymmetricECPrivateKey getBaseKey() {
        KeyUtil.checkDestroyed(this);
        return this.baseKey;
    }

    @Override
    public String getAlgorithm() {
        KeyUtil.checkDestroyed(this);
        return "EC";
    }

    @Override
    public String getFormat() {
        KeyUtil.checkDestroyed(this);
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public ECParameterSpec getParams() {
        return ECUtil.convertToSpec(this.baseKey.getDomainParameters());
    }

    @Override
    public BigInteger getS() {
        return this.baseKey.getS();
    }

    @Override
    public void destroy() {
        this.baseKey.destroy();
    }

    @Override
    public boolean isDestroyed() {
        return this.baseKey.isDestroyed();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProvECPrivateKey) {
            ProvECPrivateKey other = (ProvECPrivateKey)o;
            return this.baseKey.equals(other.baseKey);
        }
        return false;
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    public String toString() {
        if (this.isDestroyed()) {
            return KeyUtil.destroyedPrivateKeyToString("EC");
        }
        try {
            return KeyUtil.privateKeyToString("EC", this.baseKey.getS(), this.baseKey.getDomainParameters());
        }
        catch (Exception e) {
            return KeyUtil.restrictedToString("EC");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Algorithm alg = (Algorithm)in.readObject();
        byte[] enc = (byte[])in.readObject();
        this.baseKey = new AsymmetricECPrivateKey(alg, enc);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.isDestroyed()) {
            throw new IOException("key has been destroyed");
        }
        out.defaultWriteObject();
        out.writeObject(this.baseKey.getAlgorithm());
        out.writeObject(this.getEncoded());
    }
}

