/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.bouncycastle.util.Properties;

class EntropyGatherer
implements Runnable {
    private final int numBytes;
    private final SecureRandom baseRandom;
    private final AtomicBoolean seedAvailable;
    private final AtomicReference<byte[]> entropy;

    EntropyGatherer(int numBytes, SecureRandom baseRandom, AtomicBoolean seedAvailable, AtomicReference<byte[]> entropy) {
        this.numBytes = numBytes;
        this.baseRandom = baseRandom;
        this.seedAvailable = seedAvailable;
        this.entropy = entropy;
    }

    private void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void run() {
        byte[] rn;
        long ms;
        String pause = Properties.getPropertyValue("org.bouncycastle.drbg.gather_pause_secs");
        if (pause != null) {
            try {
                ms = Long.parseLong(pause) * 1000L;
            }
            catch (Exception e) {
                ms = 5000L;
            }
        } else {
            ms = 5000L;
        }
        byte[] seed = new byte[this.numBytes];
        for (int i = 0; i < this.numBytes / 8; ++i) {
            this.sleep(ms);
            rn = this.baseRandom.generateSeed(8);
            System.arraycopy(rn, 0, seed, i * 8, rn.length);
        }
        int extra = this.numBytes - this.numBytes / 8 * 8;
        if (extra != 0) {
            this.sleep(ms);
            rn = this.baseRandom.generateSeed(extra);
            System.arraycopy(rn, 0, seed, seed.length - rn.length, rn.length);
        }
        this.entropy.set(seed);
        this.seedAvailable.set(true);
    }
}

