/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHGenParameterSpec;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.asymmetric.DHDomainParameters;
import org.bouncycastle.crypto.fips.FipsDH;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.spec.DHDomainParameterSpec;

class DHAlgorithmParameterGeneratorSpi
extends AlgorithmParameterGeneratorSpi {
    private final String algorithm;
    protected SecureRandom random;
    protected int strength = 2048;
    private int l = 0;
    private final BouncyCastleFipsProvider fipsProvider;

    public DHAlgorithmParameterGeneratorSpi(BouncyCastleFipsProvider fipsProvider, String algorithm) {
        this.fipsProvider = fipsProvider;
        this.algorithm = algorithm;
    }

    @Override
    protected void engineInit(int strength, SecureRandom random) {
        this.strength = strength;
        this.random = random;
        if (CryptoServicesRegistrar.isInApprovedOnlyMode() && strength < 2048) {
            throw new InvalidParameterException("Attempt to initialize parameter generation of less than 2048 bits in approved mode");
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(genParamSpec instanceof DHGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException(this.algorithm + " parameter generator requires a DHGenParameterSpec for initialization");
        }
        DHGenParameterSpec spec = (DHGenParameterSpec)genParamSpec;
        this.strength = spec.getPrimeSize();
        if (CryptoServicesRegistrar.isInApprovedOnlyMode() && this.strength < 2048) {
            throw new InvalidAlgorithmParameterException("Attempt to initialize parameter generation of less than 2048 bits in approved mode");
        }
        this.l = spec.getExponentSize();
        this.random = random;
    }

    @Override
    protected AlgorithmParameters engineGenerateParameters() {
        AlgorithmParameters params;
        FipsDH.DomainParametersGenerator pGen = this.random != null ? new FipsDH.DomainParametersGenerator(new FipsDH.DomainGenParameters(this.strength), this.random) : new FipsDH.DomainParametersGenerator(new FipsDH.DomainGenParameters(this.strength), this.fipsProvider.getDefaultSecureRandom());
        DHDomainParameters p = pGen.generateDomainParameters();
        try {
            params = AlgorithmParameters.getInstance(this.algorithm, this.fipsProvider);
            params.init(new DHDomainParameterSpec(p.getP(), p.getQ(), p.getG(), p.getJ(), this.l, p.getValidationParameters()));
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return params;
    }
}

