/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.EntropySourceProvider;
import org.bouncycastle.crypto.SecureRandomProvider;
import org.bouncycastle.crypto.fips.FipsDRBG;
import org.bouncycastle.crypto.fips.FipsNative;
import org.bouncycastle.crypto.fips.FipsSecureRandom;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.util.BasicEntropySourceProvider;
import org.bouncycastle.jcajce.provider.AsymmetricKeyInfoConverter;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.EntropyDaemon;
import org.bouncycastle.jcajce.provider.EntropyGatherer;
import org.bouncycastle.jcajce.provider.ProvAES;
import org.bouncycastle.jcajce.provider.ProvARC4;
import org.bouncycastle.jcajce.provider.ProvARIA;
import org.bouncycastle.jcajce.provider.ProvBCFKS;
import org.bouncycastle.jcajce.provider.ProvBlowfish;
import org.bouncycastle.jcajce.provider.ProvCAST5;
import org.bouncycastle.jcajce.provider.ProvCamellia;
import org.bouncycastle.jcajce.provider.ProvChaCha20;
import org.bouncycastle.jcajce.provider.ProvDES;
import org.bouncycastle.jcajce.provider.ProvDESede;
import org.bouncycastle.jcajce.provider.ProvDH;
import org.bouncycastle.jcajce.provider.ProvDSA;
import org.bouncycastle.jcajce.provider.ProvDSTU4145;
import org.bouncycastle.jcajce.provider.ProvEC;
import org.bouncycastle.jcajce.provider.ProvECGOST3410;
import org.bouncycastle.jcajce.provider.ProvEdEC;
import org.bouncycastle.jcajce.provider.ProvElgamal;
import org.bouncycastle.jcajce.provider.ProvFipsKS;
import org.bouncycastle.jcajce.provider.ProvGOST28147;
import org.bouncycastle.jcajce.provider.ProvGOST3410;
import org.bouncycastle.jcajce.provider.ProvIDEA;
import org.bouncycastle.jcajce.provider.ProvJKS;
import org.bouncycastle.jcajce.provider.ProvKMAC;
import org.bouncycastle.jcajce.provider.ProvLMS;
import org.bouncycastle.jcajce.provider.ProvOpenSSLPBKDF;
import org.bouncycastle.jcajce.provider.ProvPBEPBKDF1;
import org.bouncycastle.jcajce.provider.ProvPBEPBKDF2;
import org.bouncycastle.jcajce.provider.ProvPBESCRYPT;
import org.bouncycastle.jcajce.provider.ProvPKCS12;
import org.bouncycastle.jcajce.provider.ProvPKIX;
import org.bouncycastle.jcajce.provider.ProvPoly1305;
import org.bouncycastle.jcajce.provider.ProvRC2;
import org.bouncycastle.jcajce.provider.ProvRSA;
import org.bouncycastle.jcajce.provider.ProvRandom;
import org.bouncycastle.jcajce.provider.ProvSEED;
import org.bouncycastle.jcajce.provider.ProvSHACAL2;
import org.bouncycastle.jcajce.provider.ProvSHS;
import org.bouncycastle.jcajce.provider.ProvSecureHash;
import org.bouncycastle.jcajce.provider.ProvSerpent;
import org.bouncycastle.jcajce.provider.ProvSipHash;
import org.bouncycastle.jcajce.provider.ProvTwofish;
import org.bouncycastle.jcajce.provider.ProvX509;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Properties;
import org.bouncycastle.util.Strings;

public final class BouncyCastleFipsProvider
extends Provider {
    public static final String INFO = "BouncyCastle Security Provider (FIPS edition) v2.1.1";
    public static final String PROVIDER_NAME = "BCFIPS";
    private static final Map<String, FipsDRBG.Base> drbgTable = new HashMap<String, FipsDRBG.Base>();
    private static final Map<String, Integer> drbgStrengthTable = new HashMap<String, Integer>();
    private FipsDRBG.Base providerDefaultRandomBuilder = FipsDRBG.SHA512;
    private int providerDefaultSecurityStrength = 256;
    private boolean providerDefaultPredictionResistance = true;
    private boolean useThreadLocal = false;
    private boolean hybridSource = false;
    private final AtomicInteger providerDefaultRandomSecurityStrength = new AtomicInteger(this.providerDefaultSecurityStrength);
    private final SecureRandomProvider providerDefaultSecureRandomProvider;
    private Map<String, BcService> serviceMap = new ConcurrentHashMap<String, BcService>();
    private Map<String, EngineCreator> creatorMap = new HashMap<String, EngineCreator>();
    private final Map<ASN1ObjectIdentifier, AsymmetricKeyInfoConverter> keyInfoConverters = new HashMap<ASN1ObjectIdentifier, AsymmetricKeyInfoConverter>();
    private WeakReference<Set<Provider.Service>> serviceSetCache = new WeakReference<Object>(null);
    private SecureRandom entopySource = null;
    private Thread entropyThread = null;
    private EntropyDaemon entropyDaemon = null;
    private final Map<Map<String, String>, Map<String, String>> attributeMaps = new HashMap<Map<String, String>, Map<String, String>>();
    static final int POOL_SIZE;

    public static String getInfoString() {
        return INFO;
    }

    public BouncyCastleFipsProvider() {
        this((String)null);
    }

    public BouncyCastleFipsProvider(String config) {
        this(config, null);
    }

    public BouncyCastleFipsProvider(String config, SecureRandom entropySource) {
        super(PROVIDER_NAME, 2.101, BouncyCastleFipsProvider.getInfoString());
        this.entopySource = entropySource;
        if (config != null) {
            if (config.startsWith("C:") || config.startsWith("c:")) {
                this.processConfigString(Strings.toUpperCase(config));
            } else {
                throw new IllegalArgumentException("Unrecognized config string passed to BCFIPS provider.");
            }
        }
        this.providerDefaultSecureRandomProvider = this.useThreadLocal ? new ThreadLocalSecureRandomProvider() : new PooledSecureRandomProvider();
        new ProvRandom().configure(this);
        new ProvSHS.SHA1().configure(this);
        new ProvSHS.SHA224().configure(this);
        new ProvSHS.SHA256().configure(this);
        new ProvSHS.SHA384().configure(this);
        new ProvSHS.SHA512().configure(this);
        new ProvSHS.SHA3_224().configure(this);
        new ProvSHS.SHA3_256().configure(this);
        new ProvSHS.SHA3_384().configure(this);
        new ProvSHS.SHA3_512().configure(this);
        new ProvSHS.SHAKE128().configure(this);
        new ProvSHS.SHAKE256().configure(this);
        new ProvKMAC().configure(this);
        if (!this.isDisabled("MD5")) {
            new ProvSecureHash.MD5().configure(this);
        }
        new ProvPBESCRYPT().configure(this);
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            new ProvSecureHash.GOST3411().configure(this);
            new ProvSecureHash.GOST3411_2012_256().configure(this);
            new ProvSecureHash.GOST3411_2012_512().configure(this);
            new ProvSecureHash.RIPEMD128().configure(this);
            new ProvSecureHash.RIPEMD160().configure(this);
            new ProvSecureHash.RIPEMD256().configure(this);
            new ProvSecureHash.RIPEMD320().configure(this);
            new ProvSecureHash.Tiger().configure(this);
            new ProvSecureHash.Whirlpool().configure(this);
        }
        new ProvDH().configure(this);
        new ProvDSA().configure(this);
        if (!Properties.isOverrideSet("org.bouncycastle.ec.disable")) {
            new ProvEC().configure(this);
        }
        new ProvRSA().configure(this);
        new ProvPBEPBKDF2().configure(this);
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            new ProvPBEPBKDF1().configure(this);
            new ProvOpenSSLPBKDF().configure(this);
            new ProvPKCS12().configure(this);
        }
        new ProvAES().configure(this);
        new ProvDESede().configure(this);
        new ProvX509().configure(this);
        new ProvBCFKS().configure(this);
        new ProvFipsKS().configure(this);
        new ProvEdEC().configure(this);
        new ProvLMS().configure(this);
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            new ProvDSTU4145().configure(this);
            new ProvElgamal().configure(this);
            new ProvGOST3410().configure(this);
            new ProvECGOST3410().configure(this);
            new ProvARIA().configure(this);
            new ProvBlowfish().configure(this);
            new ProvCAST5().configure(this);
            new ProvRC2().configure(this);
            new ProvGOST28147().configure(this);
            new ProvSEED().configure(this);
            new ProvCamellia().configure(this);
            new ProvChaCha20().configure(this);
            new ProvDES().configure(this);
            new ProvIDEA().configure(this);
            new ProvSerpent().configure(this);
            new ProvSHACAL2().configure(this);
            new ProvTwofish().configure(this);
            new ProvARC4().configure(this);
            new ProvSipHash().configure(this);
            new ProvPoly1305().configure(this);
        }
        if (!Properties.isOverrideSet("org.bouncycastle.pkix.disable_certpath")) {
            new ProvPKIX().configure(this);
        }
        if (Properties.isOverrideSet("org.bouncycastle.jca.enable_jks")) {
            new ProvJKS().configure(this);
        }
    }

    private EntropySourceProvider getDefaultEntropySourceProvider() {
        EntropySourceProvider entropySourceProvider = FipsNative.isEnabled() ? CryptoServicesRegistrar.getDefaultEntropySourceProvider() : this.getEntropySourceProvider();
        return entropySourceProvider;
    }

    @Override
    public Provider configure(String configArg) {
        return new BouncyCastleFipsProvider(configArg);
    }

    private void processConfigString(String config) {
        String[] commands = config.substring(2).split(";");
        boolean enableAllFound = false;
        for (String command : commands) {
            if (command.startsWith("DEFRND")) {
                String rndConfig = this.extractString('[', ']', command);
                String rnd = null;
                String prOn = null;
                int commaPos = rndConfig.indexOf(",");
                if (commaPos > 0) {
                    rnd = rndConfig.substring(0, commaPos).trim();
                    prOn = rndConfig.substring(commaPos + 1).trim();
                } else if (rndConfig.equals("TRUE") || rndConfig.equals("FALSE")) {
                    prOn = rndConfig;
                } else if (rndConfig.equals("LOCAL")) {
                    this.useThreadLocal = true;
                } else {
                    rnd = rndConfig;
                }
                if (prOn != null) {
                    this.providerDefaultPredictionResistance = Boolean.valueOf(prOn);
                }
                if (rnd == null) continue;
                this.providerDefaultRandomBuilder = drbgTable.get(rnd);
                if (drbgStrengthTable.containsKey(rnd)) {
                    this.providerDefaultSecurityStrength = drbgStrengthTable.get(rnd);
                }
                if (this.providerDefaultRandomBuilder != null) continue;
                throw new IllegalArgumentException("Unknown DEFRND - " + rnd + " - found in config string.");
            }
            if (command.startsWith("HYBRID")) {
                this.hybridSource = true;
                this.entropyDaemon = new EntropyDaemon();
                this.entropyThread = new Thread((Runnable)this.entropyDaemon, "BC FIPS Entropy Daemon");
                this.entropyThread.setDaemon(true);
                this.entropyThread.start();
                continue;
            }
            if (!command.startsWith("ENABLE") || !"ENABLE{ALL}".equals(command)) continue;
            enableAllFound = true;
        }
        if (!enableAllFound) {
            throw new IllegalArgumentException("No ENABLE command found in config string.");
        }
    }

    private String extractString(char startC, char endC, String command) {
        int start = command.indexOf(startC);
        int end = command.indexOf(endC);
        if (start < 0 || end < 0) {
            throw new IllegalArgumentException("Unable to parse config: ('" + startC + "', '" + endC + "') missing.");
        }
        return command.substring(start + 1, end);
    }

    int getProviderDefaultSecurityStrength() {
        return this.providerDefaultSecurityStrength;
    }

    FipsDRBG.Base getProviderDefaultRandomBuilder() {
        return this.providerDefaultRandomBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecureRandom getDefaultSecureRandom() {
        SecureRandom defRandom = CryptoServicesRegistrar.getSecureRandomIfSet(this.providerDefaultSecureRandomProvider);
        if (defRandom instanceof FipsSecureRandom) {
            int currentSecurityStrength;
            int securityStrength = ((FipsSecureRandom)defRandom).getSecurityStrength();
            if (securityStrength < (currentSecurityStrength = this.providerDefaultRandomSecurityStrength.get())) {
                AtomicInteger atomicInteger = this.providerDefaultRandomSecurityStrength;
                synchronized (atomicInteger) {
                    if (securityStrength < this.providerDefaultRandomSecurityStrength.get()) {
                        this.providerDefaultRandomSecurityStrength.set(securityStrength);
                    }
                }
            }
        } else {
            this.providerDefaultRandomSecurityStrength.set(-1);
        }
        return defRandom;
    }

    EntropySourceProvider getEntropySourceProvider() {
        return AccessController.doPrivileged(new PrivilegedAction<EntropySourceProvider>(){

            @Override
            public EntropySourceProvider run() {
                if (BouncyCastleFipsProvider.this.hybridSource) {
                    return new EntropySourceProvider(){

                        @Override
                        public EntropySource get(int bitsRequired) {
                            return new HybridEntropySource(BouncyCastleFipsProvider.this.entropyDaemon, bitsRequired, BouncyCastleFipsProvider.this.getCoreSecureRandom());
                        }
                    };
                }
                return new BasicEntropySourceProvider(BouncyCastleFipsProvider.this.getCoreSecureRandom(), true);
            }
        });
    }

    private SecureRandom getCoreSecureRandom() {
        return AccessController.doPrivileged(new PrivilegedAction<SecureRandom>(){

            @Override
            public SecureRandom run() {
                try {
                    return SecureRandom.getInstanceStrong();
                }
                catch (Exception e) {
                    return new SecureRandom();
                }
            }
        });
    }

    public int getDefaultRandomSecurityStrength() {
        return this.providerDefaultRandomSecurityStrength.get();
    }

    void addAttribute(String key, String attributeName, String attributeValue) {
        String attributeKey = key + " " + attributeName;
        if (this.containsKey(attributeKey)) {
            throw new IllegalStateException("duplicate provider attribute key (" + attributeKey + ") found");
        }
        this.put(attributeKey, attributeValue);
    }

    void addAttribute(String type, ASN1ObjectIdentifier oid, String attributeName, String attributeValue) {
        String attributeKey = type + "." + oid + " " + attributeName;
        if (this.containsKey(attributeKey)) {
            throw new IllegalStateException("duplicate provider attribute key (" + attributeKey + ") found");
        }
        this.put(attributeKey, attributeValue);
    }

    void addAttributes(String key, Map<String, String> attributes) {
        for (Map.Entry<String, String> attrEntry : attributes.entrySet()) {
            this.addAttribute(key, attrEntry.getKey(), attrEntry.getValue());
        }
    }

    void addAttributes(String type, ASN1ObjectIdentifier oid, Map<String, String> attributes) {
        for (Map.Entry<String, String> attrEntry : attributes.entrySet()) {
            this.addAttribute(type, oid, attrEntry.getKey(), attrEntry.getValue());
        }
    }

    void addAlgorithmImplementation(String key, String className, Map<String, String> attributes, EngineCreator creator) {
        if (this.containsKey(key)) {
            throw new IllegalStateException("duplicate provider key (" + key + ") found");
        }
        this.addAttribute(key, "ImplementedIn", "Software");
        this.addAttributes(key, attributes);
        this.put(key, className);
        this.creatorMap.put(className, creator);
    }

    void addAlgorithmImplementation(String key, String className, EngineCreator creator) {
        if (this.containsKey(key)) {
            throw new IllegalStateException("duplicate provider key (" + key + ") found");
        }
        this.addAttribute(key, "ImplementedIn", "Software");
        this.put(key, className);
        this.creatorMap.put(className, creator);
    }

    void addAlgorithmImplementation(String type, ASN1ObjectIdentifier oid, String className, EngineCreator creator) {
        String key1 = type + "." + oid;
        if (this.containsKey(key1)) {
            throw new IllegalStateException("duplicate provider key (" + key1 + ") found");
        }
        this.addAttribute(type, oid, "ImplementedIn", "Software");
        this.put(key1, className);
        this.creatorMap.put(className, creator);
        this.addAlias(type, oid.getId(), "OID." + oid.getId());
    }

    void addAlgorithmImplementation(String type, ASN1ObjectIdentifier oid, String className, Map<String, String> attributes, EngineCreator creator) {
        String key1 = type + "." + oid;
        if (this.containsKey(key1)) {
            throw new IllegalStateException("duplicate provider key (" + key1 + ") found");
        }
        this.addAttributes(type, oid, attributes);
        this.addAttribute(type, oid, "ImplementedIn", "Software");
        this.put(key1, className);
        this.creatorMap.put(className, creator);
        this.addAlias(type, oid.getId(), "OID." + oid.getId());
    }

    void addAlias(String key, String value) {
        if (this.containsKey(key)) {
            throw new IllegalStateException("duplicate provider key (" + key + ") found");
        }
        this.put(key, value);
    }

    void addAlias(String type, String name, String ... aliases) {
        if (!this.containsKey(type + "." + name)) {
            throw new IllegalStateException("primary key (" + type + "." + name + ") not found");
        }
        for (String alias : aliases) {
            this.doPut("Alg.Alias." + type + "." + alias, name);
        }
    }

    void addAlias(String type, String name, ASN1ObjectIdentifier ... oids) {
        if (!this.containsKey(type + "." + name)) {
            throw new IllegalStateException("primary key (" + type + "." + name + ") not found");
        }
        for (ASN1ObjectIdentifier oid : oids) {
            this.doPut("Alg.Alias." + type + "." + oid, name);
            this.doPut("Alg.Alias." + type + ".OID." + oid, name);
        }
    }

    private void doPut(String key, String name) {
        if (this.containsKey(key)) {
            throw new IllegalStateException("duplicate provider key (" + key + ") found");
        }
        this.put(key, name);
    }

    @Override
    public final Provider.Service getService(String type, String algorithm) {
        String upperCaseAlgName = Strings.toUpperCase(algorithm);
        BcService service = this.serviceMap.get(type + "." + upperCaseAlgName);
        if (service == null) {
            String className;
            String aliasString = "Alg.Alias." + type + ".";
            String realName = (String)this.get(aliasString + upperCaseAlgName);
            if (realName == null) {
                realName = upperCaseAlgName;
            }
            if ((className = (String)this.get(type + "." + realName)) == null) {
                return null;
            }
            String attributeKeyStart = type + "." + realName + " ";
            ArrayList<String> aliases = new ArrayList<String>();
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : this.entrySet()) {
                String sKey = (String)entry.getKey();
                if (sKey.startsWith(aliasString) && entry.getValue().equals(algorithm)) {
                    aliases.add(sKey.substring(aliasString.length()));
                }
                if (!sKey.startsWith(attributeKeyStart)) continue;
                attributes.put(sKey.substring(attributeKeyStart.length()), (String)entry.getValue());
            }
            service = new BcService(this, type, upperCaseAlgName, className, aliases, this.getAttributeMap(attributes), this.creatorMap.get(className));
            BcService altService = this.serviceMap.putIfAbsent(type + "." + upperCaseAlgName, service);
            service = altService != null ? altService : service;
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<Provider.Service> getServices() {
        Set<Provider.Service> bcServiceSet = (LinkedHashSet<Provider.Service>)this.serviceSetCache.get();
        if (bcServiceSet == null) {
            BouncyCastleFipsProvider bouncyCastleFipsProvider = this;
            synchronized (bouncyCastleFipsProvider) {
                Set<Provider.Service> serviceSet = super.getServices();
                bcServiceSet = new LinkedHashSet<Provider.Service>();
                bcServiceSet.add(this.getService("SecureRandom", "DEFAULT"));
                bcServiceSet.add(this.getService("SecureRandom", "NONCEANDIV"));
                for (Provider.Service service : serviceSet) {
                    Provider.Service serv = this.getService(service.getType(), service.getAlgorithm());
                    if (serv == null) continue;
                    bcServiceSet.add(serv);
                }
                bcServiceSet = Collections.unmodifiableSet(bcServiceSet);
                this.serviceSetCache = new WeakReference(bcServiceSet);
            }
        }
        return bcServiceSet;
    }

    void addKeyInfoConverter(ASN1ObjectIdentifier oid, AsymmetricKeyInfoConverter keyInfoConverter) {
        this.keyInfoConverters.put(oid, keyInfoConverter);
    }

    private boolean isDisabled(String algName) {
        String disabled = Properties.getPropertyValue("org.bouncycastle.disabledAlgorithms");
        return disabled != null && disabled.indexOf(algName) >= 0;
    }

    private byte[] generatePersonalizationString(int rngIndex) {
        return Arrays.concatenate(Pack.intToBigEndian(rngIndex), Pack.longToBigEndian(Thread.currentThread().getId()), Pack.longToBigEndian(System.currentTimeMillis()));
    }

    private synchronized Map<String, String> getAttributeMap(Map<String, String> attributeMap) {
        Map<String, String> attrMap = this.attributeMaps.get(attributeMap);
        if (attrMap != null) {
            return attrMap;
        }
        this.attributeMaps.put(attributeMap, attributeMap);
        return attributeMap;
    }

    PublicKey getPublicKey(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter converter = this.keyInfoConverters.get(publicKeyInfo.getAlgorithm().getAlgorithm());
        if (converter == null) {
            return null;
        }
        return converter.generatePublic(publicKeyInfo);
    }

    PrivateKey getPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter converter = this.keyInfoConverters.get(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm());
        if (converter == null) {
            return null;
        }
        return converter.generatePrivate(privateKeyInfo);
    }

    private static int getPoolSize() {
        int size;
        String poolSize = Properties.getPropertyValue("org.bouncycastle.drbg.pool_size");
        if (poolSize != null) {
            size = Integer.parseInt(poolSize);
            if (size < 2) {
                return 2;
            }
        } else {
            size = Runtime.getRuntime().availableProcessors() * 2;
        }
        return Integer.highestOneBit(size);
    }

    static {
        drbgTable.put("SHA1", FipsDRBG.SHA1);
        drbgTable.put("SHA224", FipsDRBG.SHA224);
        drbgTable.put("SHA256", FipsDRBG.SHA256);
        drbgTable.put("SHA384", FipsDRBG.SHA384);
        drbgTable.put("SHA512", FipsDRBG.SHA512);
        drbgTable.put("SHA512(224)", FipsDRBG.SHA512_224);
        drbgTable.put("SHA512(256)", FipsDRBG.SHA512_256);
        drbgTable.put("HMACSHA1", FipsDRBG.SHA1_HMAC);
        drbgTable.put("HMACSHA224", FipsDRBG.SHA224_HMAC);
        drbgTable.put("HMACSHA256", FipsDRBG.SHA256_HMAC);
        drbgTable.put("HMACSHA384", FipsDRBG.SHA384_HMAC);
        drbgTable.put("HMACSHA512", FipsDRBG.SHA512_HMAC);
        drbgTable.put("HMACSHA512(224)", FipsDRBG.SHA512_224_HMAC);
        drbgTable.put("HMACSHA512(256)", FipsDRBG.SHA512_256_HMAC);
        drbgTable.put("CTRAES128", FipsDRBG.CTR_AES_128);
        drbgTable.put("CTRAES192", FipsDRBG.CTR_AES_192);
        drbgTable.put("CTRAES256", FipsDRBG.CTR_AES_256);
        drbgTable.put("CTRDESEDE", FipsDRBG.CTR_Triple_DES_168);
        drbgStrengthTable.put("SHA1", 128);
        drbgStrengthTable.put("SHA224", 192);
        drbgStrengthTable.put("SHA256", 256);
        drbgStrengthTable.put("SHA384", 256);
        drbgStrengthTable.put("SHA512", 256);
        drbgStrengthTable.put("SHA512(224)", 192);
        drbgStrengthTable.put("SHA512(256)", 256);
        drbgStrengthTable.put("HMACSHA1", 128);
        drbgStrengthTable.put("HMACSHA224", 192);
        drbgStrengthTable.put("HMACSHA256", 256);
        drbgStrengthTable.put("HMACSHA384", 256);
        drbgStrengthTable.put("HMACSHA512", 256);
        drbgStrengthTable.put("HMACSHA512(224)", 192);
        drbgStrengthTable.put("HMACSHA512(256)", 256);
        drbgStrengthTable.put("CTRAES128", 128);
        drbgStrengthTable.put("CTRAES192", 192);
        drbgStrengthTable.put("CTRAES256", 256);
        drbgStrengthTable.put("CTRDESEDE", 112);
        POOL_SIZE = BouncyCastleFipsProvider.getPoolSize();
    }

    private static class BcService
    extends Provider.Service {
        private final EngineCreator creator;

        public BcService(Provider provider, String type, String algorithm, String className, List<String> aliases, Map<String, String> attributes, EngineCreator creator) {
            super(provider, type, algorithm, className, aliases, attributes);
            this.creator = creator;
        }

        @Override
        public Object newInstance(Object constructorParameter) throws NoSuchAlgorithmException {
            try {
                FipsStatus.isReady();
                Object instance = this.creator.createInstance(constructorParameter);
                if (instance == null) {
                    throw new NoSuchAlgorithmException("No such algorithm in FIPS approved mode: " + this.getAlgorithm());
                }
                return instance;
            }
            catch (NoSuchAlgorithmException e) {
                throw e;
            }
            catch (Exception e) {
                throw new NoSuchAlgorithmException("Unable to invoke creator for " + this.getAlgorithm() + ": " + e.getMessage(), e);
            }
        }
    }

    private static class HybridEntropySource
    implements EntropySource {
        private final AtomicBoolean seedAvailable = new AtomicBoolean(false);
        private final AtomicInteger samples = new AtomicInteger(0);
        private final FipsSecureRandom drbg;
        private final SignallingEntropySource entropySource;
        private final int bytesRequired;

        HybridEntropySource(EntropyDaemon entropyDaemon, int bitsRequired, SecureRandom baseRandom) {
            this.bytesRequired = (bitsRequired + 7) / 8;
            this.entropySource = new SignallingEntropySource(entropyDaemon, this.seedAvailable, baseRandom, 256);
            this.drbg = FipsDRBG.SHA512.fromEntropySource(new EntropySourceProvider(){

                @Override
                public EntropySource get(int bitsRequired) {
                    return entropySource;
                }
            }).setPersonalizationString(Strings.toByteArray("Bouncy Castle Hybrid Entropy Source")).build(baseRandom.generateSeed(32), false, null);
        }

        @Override
        public boolean isPredictionResistant() {
            return true;
        }

        @Override
        public byte[] getEntropy() {
            byte[] entropy = new byte[this.bytesRequired];
            if (this.samples.getAndIncrement() > 20) {
                if (this.seedAvailable.getAndSet(false)) {
                    this.samples.set(0);
                    this.drbg.reseed();
                } else {
                    this.entropySource.schedule();
                }
            }
            this.drbg.nextBytes(entropy);
            return entropy;
        }

        @Override
        public int entropySize() {
            return this.bytesRequired * 8;
        }

        private class SignallingEntropySource
        implements EntropySource {
            private final EntropyDaemon entropyDaemon;
            private final AtomicBoolean seedAvailable;
            private final SecureRandom baseRandom;
            private final int byteLength;
            private final AtomicReference entropy = new AtomicReference();
            private final AtomicBoolean scheduled = new AtomicBoolean(false);

            SignallingEntropySource(EntropyDaemon entropyDaemon, AtomicBoolean seedAvailable, SecureRandom baseRandom, int bitsRequired) {
                this.entropyDaemon = entropyDaemon;
                this.seedAvailable = seedAvailable;
                this.baseRandom = baseRandom;
                this.byteLength = (bitsRequired + 7) / 8;
            }

            @Override
            public boolean isPredictionResistant() {
                return true;
            }

            @Override
            public byte[] getEntropy() {
                byte[] seed = this.entropy.getAndSet(null);
                if (seed == null || seed.length != this.byteLength) {
                    seed = this.baseRandom.generateSeed(this.byteLength);
                } else {
                    this.scheduled.set(false);
                }
                this.schedule();
                return seed;
            }

            void schedule() {
                if (!this.scheduled.getAndSet(true)) {
                    this.entropyDaemon.addTask(new EntropyGatherer(this.byteLength, this.baseRandom, this.seedAvailable, this.entropy));
                }
            }

            @Override
            public int entropySize() {
                return this.byteLength * 8;
            }
        }
    }

    private class PooledSecureRandomProvider
    implements SecureRandomProvider {
        private final AtomicReference<SecureRandom>[] providerDefaultRandom = new AtomicReference[POOL_SIZE];

        PooledSecureRandomProvider() {
            for (int i = 0; i != this.providerDefaultRandom.length; ++i) {
                this.providerDefaultRandom[i] = new AtomicReference();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public SecureRandom get() {
            int rngIndex = (Thread.currentThread().hashCode() & POOL_SIZE - 1) % this.providerDefaultRandom.length;
            if (this.providerDefaultRandom[rngIndex].get() != null) return this.providerDefaultRandom[rngIndex].get();
            AtomicReference<SecureRandom>[] atomicReferenceArray = this.providerDefaultRandom;
            synchronized (this.providerDefaultRandom) {
                if (this.providerDefaultRandom[rngIndex].get() != null) return this.providerDefaultRandom[rngIndex].get();
                EntropySourceProvider entropySourceProvider = BouncyCastleFipsProvider.this.getDefaultEntropySourceProvider();
                EntropySource seedSource = entropySourceProvider.get(BouncyCastleFipsProvider.this.providerDefaultSecurityStrength / 2 + 1);
                this.providerDefaultRandom[rngIndex].compareAndSet(null, BouncyCastleFipsProvider.this.providerDefaultRandomBuilder.fromEntropySource(entropySourceProvider).setPersonalizationString(BouncyCastleFipsProvider.this.generatePersonalizationString(rngIndex)).build(seedSource.getEntropy(), BouncyCastleFipsProvider.this.providerDefaultPredictionResistance, Strings.toByteArray("Bouncy Castle FIPS Provider")));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.providerDefaultRandom[rngIndex].get();
            }
        }
    }

    private class ThreadLocalSecureRandomProvider
    implements SecureRandomProvider {
        final ThreadLocal<FipsSecureRandom> defaultRandoms = new ThreadLocal();

        private ThreadLocalSecureRandomProvider() {
        }

        @Override
        public SecureRandom get() {
            if (this.defaultRandoms.get() == null) {
                EntropySourceProvider entropySourceProvider = BouncyCastleFipsProvider.this.getDefaultEntropySourceProvider();
                EntropySource seedSource = entropySourceProvider.get(BouncyCastleFipsProvider.this.providerDefaultSecurityStrength / 2 + 1);
                this.defaultRandoms.set(BouncyCastleFipsProvider.this.providerDefaultRandomBuilder.fromEntropySource(entropySourceProvider).setPersonalizationString(BouncyCastleFipsProvider.this.generatePersonalizationString((int)Thread.currentThread().getId())).build(seedSource.getEntropy(), BouncyCastleFipsProvider.this.providerDefaultPredictionResistance, Strings.toByteArray("Bouncy Castle FIPS Provider")));
            }
            return this.defaultRandoms.get();
        }
    }
}

