/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.MACOperatorFactory;
import org.bouncycastle.crypto.OutputMACCalculator;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsMACOperatorFactory;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.SecureHash;
import org.bouncycastle.jcajce.PKCS12Key;
import org.bouncycastle.jcajce.provider.MacParametersCreator;
import org.bouncycastle.jcajce.provider.ProvPKCS12;
import org.bouncycastle.jcajce.provider.Utils;

class BaseHMac
extends MacSpi {
    private static FipsMACOperatorFactory<FipsSHS.AuthParameters> fipsFactory = new FipsSHS.MACOperatorFactory();
    private static MACOperatorFactory<SecureHash.AuthParameters> generalFactory;
    private final Algorithm algorithm;
    private final MACOperatorFactory factory;
    private final MacParametersCreator parametersCreator;
    private OutputMACCalculator macCalculator;
    private UpdateOutputStream macStream;

    protected BaseHMac(FipsAlgorithm algorithm, MacParametersCreator parametersCreator) {
        this.algorithm = algorithm;
        this.factory = fipsFactory;
        this.parametersCreator = parametersCreator;
    }

    protected BaseHMac(GeneralAlgorithm algorithm, MacParametersCreator parametersCreator) {
        this.algorithm = algorithm;
        this.factory = this.getGeneralMACFactory();
        this.parametersCreator = parametersCreator;
    }

    private MACOperatorFactory<SecureHash.AuthParameters> getGeneralMACFactory() {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            return null;
        }
        if (generalFactory == null) {
            generalFactory = new SecureHash.MACOperatorFactory();
        }
        return generalFactory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object parameters;
        if (params instanceof PBEParameterSpec) {
            try {
                parameters = this.parametersCreator.createParameters(true, null, null);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidAlgorithmParameterException("Invalid algorithm parameter: " + e.getMessage(), e);
            }
        } else {
            parameters = this.parametersCreator.createParameters(true, params, null);
        }
        if (key instanceof PKCS12Key) {
            SecretKey pbeKey;
            PBEParameterSpec spec;
            int keySizeInBits = parameters.getMACSizeInBits();
            if (params != null) {
                if (!(params instanceof PBEParameterSpec)) throw new InvalidAlgorithmParameterException("PBE algorithms can only take PBEParameterSpec");
                spec = (PBEParameterSpec)params;
            } else {
                if (!(key instanceof PBEKey)) throw new InvalidKeyException("No algorithm parameters provided when required.");
                pbeKey = (PBEKey)key;
                spec = new PBEParameterSpec(pbeKey.getSalt(), pbeKey.getIterationCount());
            }
            try {
                pbeKey = (SecretKey)key;
            }
            catch (Exception e) {
                throw new InvalidKeyException("PBE schemes requires a SecretKey/PBEKey");
            }
            if (!(key instanceof PKCS12Key)) throw new InvalidKeyException("Unable to use passed in key for PBE");
            key = new SecretKeySpec(ProvPKCS12.getSecretKey(pbeKey, Utils.getUnderlyingDigestAlgorithm(this.algorithm), spec, PasswordBasedDeriver.KeyType.MAC, keySizeInBits), this.algorithm.getName());
        }
        this.macCalculator = this.factory.createOutputMACCalculator(Utils.convertKey(this.algorithm, key), parameters);
        this.macStream = this.macCalculator.getMACStream();
    }

    @Override
    protected int engineGetMacLength() {
        return (this.parametersCreator.getBaseParameters().getMACSizeInBits() + 7) / 8;
    }

    @Override
    protected void engineReset() {
        if (this.macCalculator != null) {
            this.macCalculator.reset();
        }
    }

    @Override
    protected void engineUpdate(byte input) {
        this.macStream.update(input);
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        this.macStream.update(input, offset, len);
    }

    @Override
    protected byte[] engineDoFinal() {
        return this.macCalculator.getMAC();
    }
}

