/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.wrappers;

import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.wrappers.SP80038FWrapper;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public final class SP80038FWrapWithPaddingEngine
extends SP80038FWrapper {
    public SP80038FWrapWithPaddingEngine(BlockCipher engine, boolean useReverseDirection) {
        super(engine, ivKWP, useReverseDirection);
    }

    @Override
    public String getAlgorithmName() {
        return this.engine.getAlgorithmName() + "/KWP";
    }

    @Override
    public byte[] wrap(byte[] in, int inOff, int inLen) {
        if (!this.forWrapping) {
            throw new IllegalStateException("not set for wrapping");
        }
        int n = (inLen + 7) / 8;
        int padLen = n * 8 - inLen;
        byte[] block = new byte[inLen + this.iv.length + 4 + padLen];
        byte[] pLen = Pack.intToBigEndian(inLen);
        System.arraycopy(this.iv, 0, block, 0, this.iv.length);
        System.arraycopy(pLen, 0, block, this.iv.length, pLen.length);
        System.arraycopy(in, inOff, block, this.iv.length + 4, inLen);
        if (n == 1) {
            this.engine.init(this.wrapCipherMode, this.param);
            this.engine.processBlock(block, 0, block, 0);
            return block;
        }
        return this.W(n, block);
    }

    @Override
    public byte[] unwrap(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.forWrapping) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int n = inLen / 8;
        if (n * 8 != inLen) {
            throw new InvalidCipherTextException("unwrap data must be a multiple of 8 bytes");
        }
        byte[] a = new byte[this.iv.length + 4];
        byte[] b = new byte[inLen - a.length];
        if (n == 2) {
            byte[] buf = new byte[this.engine.getBlockSize()];
            this.engine.init(!this.wrapCipherMode, this.param);
            this.engine.processBlock(in, inOff, buf, 0);
            System.arraycopy(buf, 0, a, 0, a.length);
            System.arraycopy(buf, a.length, b, 0, b.length);
        } else {
            System.arraycopy(in, inOff, a, 0, a.length);
            System.arraycopy(in, inOff + a.length, b, 0, inLen - a.length);
            this.invW(n, b, a);
        }
        byte[] recIv = new byte[this.iv.length];
        System.arraycopy(a, 0, recIv, 0, recIv.length);
        int pLen = Pack.bigEndianToInt(a, 4);
        int padLen = 8 * (n - 1) - pLen;
        if (!Arrays.constantTimeAreEqual(recIv, this.iv)) {
            throw new InvalidCipherTextException("checksum failed");
        }
        if (padLen < 0 || padLen > 7) {
            throw new InvalidCipherTextException("unwrap data has incorrect padding length");
        }
        byte[] block = new byte[pLen];
        System.arraycopy(b, 0, block, 0, pLen);
        boolean failed = false;
        for (int i = 1; i <= padLen; ++i) {
            if (b[b.length - i] == 0) continue;
            failed = true;
        }
        if (failed) {
            throw new InvalidCipherTextException("unwrap data has incorrect padding");
        }
        return block;
    }
}

