/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.pqc.lms;

import java.security.SecureRandom;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LMS;
import org.bouncycastle.crypto.internal.pqc.lms.LMSKeyGenerationParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LMSPrivateKeyParameters;

public class LMSKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    LMSKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (LMSKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        SecureRandom source = this.param.getRandom();
        byte[] I = new byte[16];
        source.nextBytes(I);
        byte[] rootSecret = new byte[this.param.getParameters().getLMSigParam().getM()];
        source.nextBytes(rootSecret);
        LMSPrivateKeyParameters privKey = LMS.generateKeys(this.param.getParameters().getLMSigParam(), this.param.getParameters().getLMOTSParam(), 0, I, rootSecret);
        return new AsymmetricCipherKeyPair(privKey.getPublicKey(), privKey);
    }
}

