/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.pqc.lms;

import java.security.SecureRandom;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LMSParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LmsUtils;

public class HSSKeyGenerationParameters
extends KeyGenerationParameters {
    private final LMSParameters[] lmsParameters;

    public HSSKeyGenerationParameters(LMSParameters[] lmsParameters, SecureRandom random) {
        super(random, LmsUtils.calculateStrength(lmsParameters[0]));
        if (lmsParameters.length == 0 || lmsParameters.length > 8) {
            throw new IllegalArgumentException("lmsParameters length should be between 1 and 8 inclusive");
        }
        this.lmsParameters = lmsParameters;
    }

    public int getDepth() {
        return this.lmsParameters.length;
    }

    public LMSParameters[] getLmsParameters() {
        return this.lmsParameters;
    }
}

