/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.general.CipherKeyGenerator;
import org.bouncycastle.crypto.general.CipherUtils;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralAuthParameters;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GeneralParametersWithIV;
import org.bouncycastle.crypto.general.GuardedAEADOperatorFactory;
import org.bouncycastle.crypto.general.GuardedKeyWrapOperatorFactory;
import org.bouncycastle.crypto.general.GuardedMACOperatorFactory;
import org.bouncycastle.crypto.general.GuardedSymmetricKeyGenerator;
import org.bouncycastle.crypto.general.GuardedSymmetricOperatorFactory;
import org.bouncycastle.crypto.general.Mode;
import org.bouncycastle.crypto.general.Padding;
import org.bouncycastle.crypto.general.PrivilegedUtils;
import org.bouncycastle.crypto.general.SelfTestExecutor;
import org.bouncycastle.crypto.general.SerpentEngine;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.general.VariantKatTest;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.Wrapper;
import org.bouncycastle.crypto.internal.modes.AEADBlockCipher;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public final class Serpent {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("Serpent");
    private static final EngineProvider ENGINE_PROVIDER;
    public static final Parameters ECB;
    public static final Parameters ECBwithPKCS7;
    public static final Parameters ECBwithISO10126_2;
    public static final Parameters ECBwithX923;
    public static final Parameters ECBwithISO7816_4;
    public static final Parameters ECBwithTBC;
    public static final Parameters CBC;
    public static final Parameters CBCwithPKCS7;
    public static final Parameters CBCwithISO10126_2;
    public static final Parameters CBCwithX923;
    public static final Parameters CBCwithISO7816_4;
    public static final Parameters CBCwithTBC;
    public static final Parameters CBCwithCS1;
    public static final Parameters CBCwithCS2;
    public static final Parameters CBCwithCS3;
    public static final Parameters CFB8;
    public static final Parameters CFB128;
    public static final Parameters OFB;
    public static final Parameters CTR;
    public static final AuthParameters GCM;
    public static final AuthParameters CCM;
    public static final AuthParameters OCB;
    public static final AuthParameters EAX;
    public static final AuthParameters CMAC;
    public static final AuthParameters GMAC;
    public static final WrapParameters KW;
    public static final WrapParameters KWP;

    private Serpent() {
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey key, Algorithm paramAlgorithm) {
        ValidatedSymmetricKey vKey = PrivilegedUtils.getValidatedKey(key);
        int keyLength = vKey.getKeySizeInBits();
        if (Serpent.invalidKeySize(keyLength)) {
            throw new IllegalKeyException("Serpent key must be a multiple of 32 bits and no more than 256 bits");
        }
        Utils.checkKeyAlgorithm(vKey, ALGORITHM, paramAlgorithm);
        return vKey;
    }

    private static boolean invalidKeySize(int keyLength) {
        return keyLength < 32 || keyLength % 32 != 0 || keyLength > 256;
    }

    static {
        EngineProvider provider = new EngineProvider();
        provider.createEngine();
        ENGINE_PROVIDER = provider;
        ECB = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB));
        ECBwithPKCS7 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.PKCS7));
        ECBwithISO10126_2 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO10126_2));
        ECBwithX923 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.X923));
        ECBwithISO7816_4 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO7816_4));
        ECBwithTBC = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.TBC));
        CBC = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC));
        CBCwithPKCS7 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.PKCS7));
        CBCwithISO10126_2 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO10126_2));
        CBCwithX923 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.X923));
        CBCwithISO7816_4 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO7816_4));
        CBCwithTBC = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.TBC));
        CBCwithCS1 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS1));
        CBCwithCS2 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS2));
        CBCwithCS3 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS3));
        CFB8 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CFB8));
        CFB128 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CFB128));
        OFB = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.OFB128));
        CTR = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CTR));
        GCM = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.GCM));
        CCM = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CCM));
        OCB = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.OCB));
        EAX = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.EAX));
        CMAC = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CMAC));
        GMAC = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.GMAC));
        KW = new WrapParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.WRAP));
        KWP = new WrapParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.WRAPPAD));
    }

    public static final class AEADOperatorFactory
    extends GuardedAEADOperatorFactory<AuthParameters> {
        protected AEADBlockCipher createAEADCipher(boolean forEncryption, SymmetricKey key, AuthParameters parameters) {
            return CipherUtils.createStandardAEADCipher(forEncryption, Serpent.validateKey(key, parameters.getAlgorithm()), (org.bouncycastle.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (AuthenticationParametersWithIV)parameters);
        }
    }

    public static final class AuthParameters
    extends GeneralAuthParameters<AuthParameters> {
        private AuthParameters(GeneralAlgorithm algorithm, byte[] iv, int macLenInBits) {
            super(algorithm, 16, iv, macLenInBits);
        }

        AuthParameters(GeneralAlgorithm algorithm) {
            this(algorithm, null, Utils.getDefaultMacSize(algorithm, 128));
        }

        @Override
        protected AuthParameters create(GeneralAlgorithm algorithm, byte[] iv, int macSizeInBits) {
            return new AuthParameters(algorithm, iv, macSizeInBits);
        }
    }

    private static final class EngineProvider
    implements org.bouncycastle.crypto.internal.EngineProvider<BlockCipher> {
        private EngineProvider() {
        }

        @Override
        public BlockCipher createEngine() {
            return SelfTestExecutor.validate((Algorithm)ALGORITHM, new SerpentEngine(), new VariantKatTest<SerpentEngine>(){

                @Override
                public void evaluate(SerpentEngine engine) {
                    byte[] input = Hex.decode("3DA46FFA6F4D6F30CD258333E5A61369");
                    byte[] output = Hex.decode("00112233445566778899AABBCCDDEEFF");
                    byte[] tmp = new byte[input.length];
                    KeyParameterImpl key = new KeyParameterImpl(Hex.decode("000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F"));
                    engine.init(true, key);
                    engine.processBlock(input, 0, tmp, 0);
                    if (!Arrays.areEqual(output, tmp)) {
                        this.fail("Failed self test on encryption");
                    }
                    engine.init(false, key);
                    engine.processBlock(tmp, 0, tmp, 0);
                    if (!Arrays.areEqual(input, tmp)) {
                        this.fail("Failed self test on decryption");
                    }
                }
            });
        }
    }

    public static final class KeyGenerator
    extends GuardedSymmetricKeyGenerator {
        private final GeneralAlgorithm algorithm;
        private final int keySizeInBits;
        private final SecureRandom random;

        public KeyGenerator(int keySizeInBits, SecureRandom random) {
            this(ALGORITHM, keySizeInBits, random);
        }

        public KeyGenerator(GeneralParameters parameterSet, int keySizeInBits, SecureRandom random) {
            this((GeneralAlgorithm)parameterSet.getAlgorithm(), keySizeInBits, random);
        }

        private KeyGenerator(GeneralAlgorithm algorithm, int keySizeInBits, SecureRandom random) {
            this.algorithm = algorithm;
            if (Serpent.invalidKeySize(keySizeInBits)) {
                throw new IllegalArgumentException("Attempt to create key with invalid key size [" + keySizeInBits + "]: " + algorithm.getName());
            }
            this.keySizeInBits = keySizeInBits;
            this.random = random;
        }

        @Override
        public SymmetricKey doGenerateKey() {
            CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
            cipherKeyGenerator.init(new KeyGenerationParameters(this.random, this.keySizeInBits));
            return new SymmetricSecretKey(this.algorithm, cipherKeyGenerator.generateKey());
        }
    }

    public static final class KeyWrapOperatorFactory
    extends GuardedKeyWrapOperatorFactory<WrapParameters, SymmetricKey> {
        @Override
        protected Wrapper createWrapper(boolean forWrapping, SymmetricKey key, WrapParameters parameters, SecureRandom random) {
            return CipherUtils.createStandardWrapper(forWrapping, Serpent.validateKey(key, parameters.getAlgorithm()), (org.bouncycastle.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (ParametersWithIV)parameters, parameters.useInverse, random);
        }
    }

    public static final class MACOperatorFactory
    extends GuardedMACOperatorFactory<AuthParameters> {
        @Override
        protected Mac createMAC(SymmetricKey key, AuthParameters parameters) {
            return CipherUtils.createStandardMac(Serpent.validateKey(key, parameters.getAlgorithm()), (org.bouncycastle.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (GeneralAuthParameters)parameters);
        }

        @Override
        protected int calculateMACSize(AuthParameters parameters) {
            return Utils.bitsToBytes(parameters.macLenInBits);
        }
    }

    public static final class OperatorFactory
    extends GuardedSymmetricOperatorFactory<Parameters> {
        @Override
        protected BufferedBlockCipher createCipher(boolean forEncryption, SymmetricKey key, Parameters parameters, SecureRandom random) {
            return CipherUtils.createStandardCipher(forEncryption, Serpent.validateKey(key, parameters.getAlgorithm()), (org.bouncycastle.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (ParametersWithIV)parameters, random);
        }
    }

    public static final class Parameters
    extends GeneralParametersWithIV<Parameters> {
        private Parameters(GeneralAlgorithm algorithm, byte[] iv) {
            super(algorithm, 16, algorithm.checkIv(iv, 16));
        }

        Parameters(GeneralAlgorithm algorithm) {
            this(algorithm, null);
        }

        @Override
        protected Parameters create(GeneralAlgorithm algorithm, byte[] iv) {
            return new Parameters(algorithm, iv);
        }
    }

    public static final class WrapParameters
    extends GeneralParameters<GeneralAlgorithm>
    implements ParametersWithIV {
        private final byte[] iv;
        private final boolean useInverse;

        WrapParameters(GeneralAlgorithm algorithm) {
            this(algorithm, null, false);
        }

        private WrapParameters(GeneralAlgorithm algorithm, byte[] iv, boolean useInverse) {
            super(algorithm);
            if (iv != null) {
                ((Mode)algorithm.basicVariation()).checkIv(iv, this.getIvLength());
            }
            this.iv = iv;
            this.useInverse = useInverse;
        }

        public WrapParameters withUsingInverseFunction(boolean useInverse) {
            return new WrapParameters((GeneralAlgorithm)this.getAlgorithm(), Arrays.clone(this.iv), useInverse);
        }

        public WrapParameters withIV(byte[] iv) {
            return new WrapParameters((GeneralAlgorithm)this.getAlgorithm(), Arrays.clone(iv), this.useInverse);
        }

        public WrapParameters withIV(SecureRandom random) {
            return new WrapParameters((GeneralAlgorithm)this.getAlgorithm(), ((GeneralAlgorithm)this.getAlgorithm()).createDefaultIvIfNecessary(this.getIvLength(), random), this.useInverse);
        }

        @Override
        public byte[] getIV() {
            return Arrays.clone(this.iv);
        }

        public boolean isUsingInverseFunction() {
            return this.useInverse;
        }

        private int getIvLength() {
            return ((GeneralAlgorithm)this.getAlgorithm()).equals(KW.getAlgorithm()) ? 8 : 4;
        }
    }
}

