/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.InvalidSignatureException;
import org.bouncycastle.crypto.OutputSigner;
import org.bouncycastle.crypto.OutputValidator;
import org.bouncycastle.crypto.OutputVerifier;
import org.bouncycastle.crypto.PlainInputProcessingException;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.AsymmetricLMSPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricLMSPublicKey;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.general.FipsRegister;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GuardedAsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.general.GuardedSignatureOperatorFactory;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.io.DigestOutputStream;
import org.bouncycastle.crypto.internal.pqc.lms.DigestProvider;
import org.bouncycastle.crypto.internal.pqc.lms.HSSKeyGenerationParameters;
import org.bouncycastle.crypto.internal.pqc.lms.HSSKeyPairGenerator;
import org.bouncycastle.crypto.internal.pqc.lms.HSSPrivateKeyParameters;
import org.bouncycastle.crypto.internal.pqc.lms.HSSPublicKeyParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LMOtsParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LMSContext;
import org.bouncycastle.crypto.internal.pqc.lms.LMSContextBasedSigner;
import org.bouncycastle.crypto.internal.pqc.lms.LMSContextBasedVerifier;
import org.bouncycastle.crypto.internal.pqc.lms.LMSKeyGenerationParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LMSKeyPairGenerator;
import org.bouncycastle.crypto.internal.pqc.lms.LMSParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LMSPrivateKeyParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LMSPublicKeyParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LMSigParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LmsDigestUtil;

public class LMS {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("LMS");
    public static final Parameters SIG = new Parameters(ALGORITHM);
    public static final OTSParameters sha256_n32_w1 = new OTSParameters(LMOtsParameters.sha256_n32_w1);
    public static final OTSParameters sha256_n32_w2 = new OTSParameters(LMOtsParameters.sha256_n32_w2);
    public static final OTSParameters sha256_n32_w4 = new OTSParameters(LMOtsParameters.sha256_n32_w4);
    public static final OTSParameters sha256_n32_w8 = new OTSParameters(LMOtsParameters.sha256_n32_w8);
    public static final KeyParameters lms_sha256_n32_h5 = new KeyParameters(LMSigParameters.lms_sha256_n32_h5);
    public static final KeyParameters lms_sha256_n32_h10 = new KeyParameters(LMSigParameters.lms_sha256_n32_h10);
    public static final KeyParameters lms_sha256_n32_h15 = new KeyParameters(LMSigParameters.lms_sha256_n32_h15);
    public static final KeyParameters lms_sha256_n32_h20 = new KeyParameters(LMSigParameters.lms_sha256_n32_h20);
    public static final KeyParameters lms_sha256_n32_h25 = new KeyParameters(LMSigParameters.lms_sha256_n32_h25);

    static {
        LmsDigestUtil.setProvider(new LmsDigestProvider());
    }

    private static class ByteArrayUpdateOutputStream
    extends UpdateOutputStream {
        ExposedByteArrayOutputStream exOut = new ExposedByteArrayOutputStream();

        private ByteArrayUpdateOutputStream() {
        }

        @Override
        public void write(byte[] in, int inOff, int inLen) {
            this.exOut.write(in, inOff, inLen);
        }

        @Override
        public void write(int i) throws IOException {
            this.exOut.write(i);
        }

        void outputTo(Digest digest) {
            this.exOut.outputTo(digest);
            this.exOut.reset();
        }
    }

    private static class ExposedByteArrayOutputStream
    extends ByteArrayOutputStream {
        private ExposedByteArrayOutputStream() {
        }

        void outputTo(Digest digest) {
            digest.update(this.buf, 0, this.count);
        }
    }

    public static final class KeyGenParameters
    extends GeneralParameters<GeneralAlgorithm> {
        private final KeyParameters[] keyParameters;

        public KeyGenParameters(KeyParameters ... keyParameters) {
            super(ALGORITHM);
            if (keyParameters.length == 0) {
                throw new IllegalArgumentException("at least one keyParameter required");
            }
            this.keyParameters = keyParameters;
        }
    }

    public static final class KeyPairGenerator
    extends GuardedAsymmetricKeyPairGenerator<KeyGenParameters, AsymmetricLMSPublicKey, AsymmetricLMSPrivateKey> {
        private AsymmetricCipherKeyPairGenerator engine;

        public KeyPairGenerator(KeyGenParameters parameters, SecureRandom random) {
            super(parameters);
            KeyParameters[] keyParams = parameters.keyParameters;
            if (keyParams.length == 1) {
                LMSKeyGenerationParameters param = new LMSKeyGenerationParameters(new LMSParameters(keyParams[0].sigParams, keyParams[0].otsParams), random);
                this.engine = new LMSKeyPairGenerator();
                this.engine.init(param);
            } else {
                LMSParameters[] hssParams = new LMSParameters[keyParams.length];
                for (int i = 0; i != keyParams.length; ++i) {
                    hssParams[i] = new LMSParameters(keyParams[i].sigParams, keyParams[i].otsParams);
                }
                HSSKeyGenerationParameters param = new HSSKeyGenerationParameters(hssParams, random);
                this.engine = new HSSKeyPairGenerator();
                this.engine.init(param);
            }
        }

        @Override
        protected AsymmetricKeyPair<AsymmetricLMSPublicKey, AsymmetricLMSPrivateKey> doGenerateKeyPair() {
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            if (this.engine instanceof LMSKeyPairGenerator) {
                LMSPublicKeyParameters pub = (LMSPublicKeyParameters)pair.getPublic();
                LMSPrivateKeyParameters priv = (LMSPrivateKeyParameters)pair.getPrivate();
                return new AsymmetricKeyPair<AsymmetricLMSPublicKey, AsymmetricLMSPrivateKey>(new AsymmetricLMSPublicKey(1, pub.getEncoded()), new AsymmetricLMSPrivateKey(1, priv.getEncoded(), pub.getEncoded()));
            }
            HSSPublicKeyParameters pub = (HSSPublicKeyParameters)pair.getPublic();
            HSSPrivateKeyParameters priv = (HSSPrivateKeyParameters)pair.getPrivate();
            return new AsymmetricKeyPair<AsymmetricLMSPublicKey, AsymmetricLMSPrivateKey>(new AsymmetricLMSPublicKey(pub.getL(), pub.getLMSPublicKey().getEncoded()), new AsymmetricLMSPrivateKey(priv.getL(), priv.getEncoded(), pub.getLMSPublicKey().getEncoded()));
        }
    }

    public static final class KeyParameters
    extends GeneralParameters<GeneralAlgorithm> {
        private final LMSigParameters sigParams;
        private final LMOtsParameters otsParams;

        private KeyParameters(LMSigParameters sigParams, LMOtsParameters otsParams) {
            super(ALGORITHM);
            this.sigParams = sigParams;
            this.otsParams = otsParams;
        }

        KeyParameters(LMSigParameters sigParams) {
            this(sigParams, sha256_n32_w4.otsParameters);
        }

        public KeyParameters using(OTSParameters otsParameters) {
            return new KeyParameters(this.sigParams, otsParameters.otsParameters);
        }
    }

    private static class LmsDigestProvider
    implements DigestProvider {
        private LmsDigestProvider() {
        }

        @Override
        public Digest getDigest(ASN1ObjectIdentifier digOid) {
            if (digOid.equals(NISTObjectIdentifiers.id_sha256)) {
                return (Digest)FipsRegister.getProvider(FipsSHS.Algorithm.SHA256).createEngine();
            }
            if (digOid.equals(NISTObjectIdentifiers.id_sha512)) {
                return (Digest)FipsRegister.getProvider(FipsSHS.Algorithm.SHA512).createEngine();
            }
            if (digOid.equals(NISTObjectIdentifiers.id_shake128)) {
                return (Digest)FipsRegister.getProvider(FipsSHS.Algorithm.SHAKE128).createEngine();
            }
            if (digOid.equals(NISTObjectIdentifiers.id_shake256) || digOid.equals(NISTObjectIdentifiers.id_shake256_len)) {
                return (Digest)FipsRegister.getProvider(FipsSHS.Algorithm.SHAKE256).createEngine();
            }
            throw new IllegalArgumentException("unrecognized digest OID: " + digOid);
        }
    }

    public static final class OTSParameters {
        private final LMOtsParameters otsParameters;

        OTSParameters(LMOtsParameters sigParameters) {
            this.otsParameters = sigParameters;
        }
    }

    public static final class OperatorFactory
    extends GuardedSignatureOperatorFactory<Parameters> {
        @Override
        protected OutputSigner<Parameters> doCreateSigner(AsymmetricPrivateKey key, final Parameters parameters) {
            final LMSContextBasedSigner signer = ((AsymmetricLMSPrivateKey)key).getContextBasedSigner();
            return new OutputSigner<Parameters>(){
                final LMSContext lmsContext;
                {
                    this.lmsContext = signer.generateLMSContext();
                }

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public UpdateOutputStream getSigningStream() {
                    return new DigestOutputStream(this.lmsContext);
                }

                @Override
                public byte[] getSignature() throws PlainInputProcessingException {
                    byte[] sig = signer.generateSignature(this.lmsContext);
                    return sig;
                }

                @Override
                public int getSignature(byte[] output, int off) throws PlainInputProcessingException {
                    byte[] sig = this.getSignature();
                    System.arraycopy(sig, 0, output, off, sig.length);
                    return sig.length;
                }
            };
        }

        @Override
        protected OutputVerifier<Parameters> doCreateVerifier(AsymmetricPublicKey key, final Parameters parameters) {
            final LMSContextBasedVerifier verifier = ((AsymmetricLMSPublicKey)key).getContextBasedVerifier();
            return new OutputVerifier<Parameters>(){
                final ByteArrayUpdateOutputStream bOut = new ByteArrayUpdateOutputStream();

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public UpdateOutputStream getVerifyingStream() {
                    return this.bOut;
                }

                @Override
                public boolean isVerified(byte[] signature) throws InvalidSignatureException {
                    LMSContext lmsContext;
                    try {
                        lmsContext = verifier.generateLMSContext(signature);
                    }
                    catch (InvalidSignatureException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        throw new InvalidSignatureException("exception parsing signature: " + e.getMessage(), e);
                    }
                    this.bOut.outputTo(lmsContext);
                    return verifier.verify(lmsContext);
                }
            };
        }

        @Override
        protected OutputValidator<Parameters> doCreateValidator(AsymmetricPublicKey key, final Parameters parameters, byte[] signature) throws InvalidSignatureException {
            LMSContext lmsContext;
            final LMSContextBasedVerifier verifier = ((AsymmetricLMSPublicKey)key).getContextBasedVerifier();
            try {
                lmsContext = verifier.generateLMSContext(signature);
            }
            catch (InvalidSignatureException e) {
                throw e;
            }
            catch (IOException e) {
                throw new InvalidSignatureException("exception parsing signature: " + e.getMessage(), e);
            }
            return new OutputValidator<Parameters>(){
                final DigestOutputStream dOut;
                {
                    this.dOut = new DigestOutputStream(lmsContext);
                }

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public UpdateOutputStream getValidatingStream() {
                    return this.dOut;
                }

                @Override
                public boolean isValidated() {
                    return verifier.verify(lmsContext);
                }
            };
        }
    }

    public static final class Parameters
    extends GeneralParameters<GeneralAlgorithm> {
        Parameters(GeneralAlgorithm algorithm) {
            super(algorithm);
        }
    }
}

