/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.macs.HMac;
import org.bouncycastle.crypto.internal.params.HKDFKeyParameters;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;

class HKDFKeyGenerator {
    private HMac hMacHash;
    private int hashLen;

    public HKDFKeyGenerator(Digest hash) {
        this.hMacHash = new HMac(hash);
        this.hashLen = hash.getDigestSize();
    }

    public HKDFKeyGenerator(HMac hMac) {
        this.hMacHash = hMac;
        this.hashLen = hMac.getUnderlyingDigest().getDigestSize();
    }

    public KeyParameter generate(HKDFKeyParameters params) {
        if (params.skipExtract()) {
            return new KeyParameterImpl(params.getIKM());
        }
        return this.extract(params.getSalt(), params.getIKM());
    }

    private KeyParameter extract(byte[] salt, byte[] ikm) {
        if (salt == null) {
            this.hMacHash.init(new KeyParameterImpl(new byte[this.hashLen]));
        } else {
            this.hMacHash.init(new KeyParameterImpl(salt));
        }
        this.hMacHash.update(ikm, 0, ikm.length);
        byte[] prk = new byte[this.hashLen];
        this.hMacHash.doFinal(prk, 0);
        return new KeyParameterImpl(prk);
    }
}

