/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricLMSKey;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.internal.Permissions;
import org.bouncycastle.crypto.internal.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.internal.pqc.lms.Composer;
import org.bouncycastle.crypto.internal.pqc.lms.HSSPrivateKeyParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LMSContextBasedSigner;
import org.bouncycastle.crypto.internal.pqc.lms.LMSPrivateKeyParameters;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Properties;

public final class AsymmetricLMSPrivateKey
extends AsymmetricLMSKey
implements AsymmetricPrivateKey {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private final byte[] keyData;
    private byte[] publicData;
    private ASN1Set attributes;
    private int hashCode;
    private AsymmetricKeyParameter lwKey;

    public AsymmetricLMSPrivateKey(int levels, byte[] keyData, byte[] publicData) {
        super(levels);
        this.keyData = Arrays.clone(keyData);
        this.publicData = Arrays.clone(publicData);
        this.hashCode = this.calculateHashCode();
        this.lwKey = AsymmetricLMSPrivateKey.getLwKey(this);
    }

    public AsymmetricLMSPrivateKey(byte[] encoding) throws IOException {
        this(PrivateKeyInfo.getInstance(encoding));
    }

    public AsymmetricLMSPrivateKey(PrivateKeyInfo keyInfo) throws IOException {
        this(ASN1OctetString.getInstance(keyInfo.parsePrivateKey()).getOctets(), keyInfo.getPublicKeyData(), keyInfo.getAttributes());
    }

    private AsymmetricLMSPrivateKey(byte[] keyEnc, ASN1BitString pubKey, ASN1Set attributes) {
        this(Pack.bigEndianToInt(keyEnc, 0), keyEnc, pubKey, attributes);
    }

    private AsymmetricLMSPrivateKey(int L, byte[] keyEnc, ASN1BitString pubKey, ASN1Set attributes) {
        super(L);
        this.keyData = Arrays.copyOfRange(keyEnc, 4, keyEnc.length);
        this.attributes = attributes;
        this.hashCode = this.calculateHashCode();
        this.lwKey = AsymmetricLMSPrivateKey.getLwKey(this);
        if (pubKey != null) {
            byte[] pubEnc = pubKey.getOctets();
            this.publicData = Arrays.copyOfRange(pubEnc, 4, pubEnc.length);
        } else {
            this.publicData = this.lwKey instanceof LMSPrivateKeyParameters ? ((LMSPrivateKeyParameters)this.lwKey).getPublicKey().getEncoded() : ((HSSPrivateKeyParameters)this.lwKey).getPublicKey().getLMSPublicKey().getEncoded();
        }
    }

    public long getUsagesRemaining() {
        if (this.lwKey instanceof LMSPrivateKeyParameters) {
            return ((LMSPrivateKeyParameters)this.lwKey).getUsagesRemaining();
        }
        return ((HSSPrivateKeyParameters)this.lwKey).getUsagesRemaining();
    }

    public long getIndex() {
        if (this.lwKey instanceof LMSPrivateKeyParameters) {
            return ((LMSPrivateKeyParameters)this.lwKey).getIndex();
        }
        return ((HSSPrivateKeyParameters)this.lwKey).getIndex();
    }

    public byte[] getSecret() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        byte[] kd = Arrays.clone(this.keyData);
        KeyUtils.checkDestroyed(this);
        return kd;
    }

    public byte[] getPublicData() {
        KeyUtils.checkDestroyed(this);
        return Arrays.clone(this.publicData);
    }

    public AsymmetricLMSPrivateKey extractKeyShard(int usageCount) {
        if (this.lwKey instanceof LMSPrivateKeyParameters) {
            LMSPrivateKeyParameters shard = ((LMSPrivateKeyParameters)this.lwKey).extractKeyShard(usageCount);
            return new AsymmetricLMSPrivateKey(1, shard.getEncoded(), this.publicData);
        }
        HSSPrivateKeyParameters shard = ((HSSPrivateKeyParameters)this.lwKey).extractKeyShard(usageCount);
        return new AsymmetricLMSPrivateKey(this.getL(), shard.getEncoded(), this.publicData);
    }

    @Override
    public byte[] getEncoded() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        KeyUtils.checkDestroyed(this);
        byte[] encoding = Composer.compose().u32str(this.L).bytes(this.keyData).build();
        byte[] pubEncoding = Composer.compose().u32str(this.L).bytes(this.publicData).build();
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
        if (Properties.isOverrideSet("org.bouncycastle.pkcs8.v1_info_only")) {
            return KeyUtils.getEncodedPrivateKeyInfo(algorithmIdentifier, new DEROctetString(encoding), this.attributes, null);
        }
        return KeyUtils.getEncodedPrivateKeyInfo(algorithmIdentifier, new DEROctetString(encoding), this.attributes, pubEncoding);
    }

    @Override
    public void destroy() {
        this.checkApprovedOnlyModeStatus();
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            Arrays.clear(this.keyData);
            if (this.publicData != null) {
                Arrays.clear(this.publicData);
            }
            this.publicData = null;
            this.attributes = null;
            this.lwKey = null;
            this.hashCode = -1;
            super.zeroize();
        }
    }

    @Override
    public boolean isDestroyed() {
        this.checkApprovedOnlyModeStatus();
        return this.hasBeenDestroyed.get();
    }

    @Override
    public boolean equals(Object o) {
        this.checkApprovedOnlyModeStatus();
        if (this == o) {
            return true;
        }
        if (!(o instanceof AsymmetricLMSPrivateKey)) {
            return false;
        }
        AsymmetricLMSPrivateKey other = (AsymmetricLMSPrivateKey)o;
        other.checkApprovedOnlyModeStatus();
        if (this.isDestroyed() || other.isDestroyed()) {
            return false;
        }
        if (!Arrays.constantTimeAreEqual(this.getSecret(), other.getSecret())) {
            return false;
        }
        return this.getAlgorithm().equals(other.getAlgorithm());
    }

    @Override
    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int result = this.getAlgorithm().hashCode();
        result = 31 * result + Arrays.hashCode(this.keyData);
        return result;
    }

    public LMSContextBasedSigner getContextBasedSigner() {
        return (LMSContextBasedSigner)((Object)this.lwKey);
    }

    private static AsymmetricKeyParameter getLwKey(final AsymmetricLMSPrivateKey privKey) {
        return AccessController.doPrivileged(new PrivilegedAction<AsymmetricKeyParameter>(){

            @Override
            public AsymmetricKeyParameter run() {
                try {
                    if (privKey.getL() == 1) {
                        return LMSPrivateKeyParameters.getInstance(privKey.getSecret());
                    }
                    return HSSPrivateKeyParameters.getInstance(privKey.getSecret());
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }
}

