/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import org.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricGOST3410Key;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.GOST3410Parameters;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.math.ec.ECPoint;

public final class AsymmetricECGOST3410PublicKey
extends AsymmetricGOST3410Key<ECDomainParameters>
implements AsymmetricPublicKey {
    private ECPoint w;

    public AsymmetricECGOST3410PublicKey(Algorithm algorithm, GOST3410Parameters<ECDomainParameters> params, ECPoint w) {
        super(algorithm, params);
        this.w = KeyUtils.validated(((ECDomainParameters)this.getParameters().getDomainParameters()).getCurve(), w);
    }

    public AsymmetricECGOST3410PublicKey(Algorithm algorithm, byte[] enc) {
        this(algorithm, SubjectPublicKeyInfo.getInstance(enc));
    }

    public AsymmetricECGOST3410PublicKey(Algorithm algorithm, SubjectPublicKeyInfo publicKeyInfo) {
        super(algorithm, ecAcceptable, publicKeyInfo.getAlgorithm());
        this.w = KeyUtils.validated(((ECDomainParameters)this.getParameters().getDomainParameters()).getCurve(), this.parsePublicKey(publicKeyInfo));
    }

    private ECPoint parsePublicKey(SubjectPublicKeyInfo publicKeyInfo) {
        byte[] y;
        byte[] x;
        ASN1OctetString key;
        try {
            key = ASN1OctetString.getInstance(publicKeyInfo.parsePublicKey());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("error recovering public key: " + e.getMessage(), e);
        }
        byte[] keyEnc = key.getOctets();
        if (keyEnc.length == 64) {
            int i;
            x = new byte[32];
            y = new byte[32];
            for (i = 0; i != x.length; ++i) {
                x[i] = keyEnc[31 - i];
            }
            for (i = 0; i != y.length; ++i) {
                y[i] = keyEnc[63 - i];
            }
        } else {
            int i;
            x = new byte[64];
            y = new byte[64];
            for (i = 0; i != x.length; ++i) {
                x[i] = keyEnc[63 - i];
            }
            for (i = 0; i != y.length; ++i) {
                y[i] = keyEnc[127 - i];
            }
        }
        return ((ECDomainParameters)this.getParameters().getDomainParameters()).getCurve().validatePoint(new BigInteger(1, x), new BigInteger(1, y));
    }

    public ECPoint getW() {
        return this.w;
    }

    @Override
    public byte[] getEncoded() {
        ASN1ObjectIdentifier id;
        byte[] encKey;
        BigInteger bX = this.w.getAffineXCoord().toBigInteger();
        BigInteger bY = this.w.getAffineYCoord().toBigInteger();
        if (bX.bitLength() > 264 || bY.bitLength() > 264) {
            encKey = new byte[128];
            this.extractBytes(encKey, 0, bX);
            this.extractBytes(encKey, 64, bY);
        } else {
            encKey = new byte[64];
            this.extractBytes(encKey, 0, bX);
            this.extractBytes(encKey, 32, bY);
        }
        if (this.getParameters().getPublicKeyParamSet() != null) {
            GOST3410PublicKeyAlgParameters pubParams = new GOST3410PublicKeyAlgParameters(this.getParameters().getPublicKeyParamSet(), this.getParameters().getDigestParamSet(), this.getParameters().getEncryptionParamSet());
            if (encKey.length == 128) {
                return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_512, pubParams), new DEROctetString(encKey));
            }
            if (pubParams.getEncryptionParamSet().on(RosstandartObjectIdentifiers.id_tc26)) {
                return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_256, pubParams), new DEROctetString(encKey));
            }
            return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, pubParams), new DEROctetString(encKey));
        }
        if (encKey.length == 128) {
            return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_512), new DEROctetString(encKey));
        }
        if (this.getParameters().getDomainParameters() instanceof NamedECDomainParameters && (id = ((NamedECDomainParameters)this.getParameters().getDomainParameters()).getID()).on(RosstandartObjectIdentifiers.id_tc26)) {
            return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_256), new DEROctetString(encKey));
        }
        return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001), new DEROctetString(encKey));
    }

    private void extractBytes(byte[] encKey, int offSet, BigInteger bI) {
        int half;
        byte[] val = bI.toByteArray();
        if (val.length < (half = encKey.length / 2)) {
            byte[] tmp = new byte[half];
            System.arraycopy(val, 0, tmp, tmp.length - val.length, val.length);
            val = tmp;
        }
        for (int i = 0; i != half; ++i) {
            encKey[offSet + i] = val[val.length - 1 - i];
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AsymmetricECGOST3410PublicKey)) {
            return false;
        }
        AsymmetricECGOST3410PublicKey other = (AsymmetricECGOST3410PublicKey)o;
        return this.w.equals(other.w) && this.getParameters().equals(other.getParameters());
    }

    @Override
    public int hashCode() {
        int result = this.w.hashCode();
        result = 31 * result + this.getParameters().hashCode();
        return result;
    }
}

