/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.util;

import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPublicKey;
import org.bouncycastle.crypto.fips.FipsEC;

public class ECKeyUtil {
    public static ECPublicKey createKeyWithCompression(ECPublicKey ecPublicKey) {
        return new ECPublicKeyWithCompression(ecPublicKey);
    }

    private static class ECPublicKeyWithCompression
    implements ECPublicKey {
        private final ECPublicKey ecPublicKey;

        public ECPublicKeyWithCompression(ECPublicKey ecPublicKey) {
            this.ecPublicKey = ecPublicKey;
        }

        @Override
        public ECPoint getW() {
            return this.ecPublicKey.getW();
        }

        @Override
        public String getAlgorithm() {
            return this.ecPublicKey.getAlgorithm();
        }

        @Override
        public String getFormat() {
            return this.ecPublicKey.getFormat();
        }

        @Override
        public byte[] getEncoded() {
            AsymmetricECPublicKey ecPubKey = new AsymmetricECPublicKey((Algorithm)FipsEC.ALGORITHM, this.ecPublicKey.getEncoded());
            return ecPubKey.getEncoded(true);
        }

        @Override
        public ECParameterSpec getParams() {
            return this.ecPublicKey.getParams();
        }
    }
}

