/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.spec;

import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.util.Arrays;

public class TwoStepKDFParameterSpec
implements AlgorithmParameterSpec {
    private final byte[] salt;
    private final byte[] info;
    private final KDFMode kdfMode;
    private final int r;
    private final CounterLocation location;
    private final byte[] iv;

    private TwoStepKDFParameterSpec(Builder builder) {
        this.kdfMode = builder.kdfMode;
        this.salt = builder.salt;
        this.info = builder.info;
        this.r = builder.r;
        this.location = builder.location;
        this.iv = builder.iv;
    }

    public KDFMode getKDFMode() {
        return this.kdfMode;
    }

    public byte[] getSalt() {
        return Arrays.clone(this.salt);
    }

    public byte[] getInfo() {
        return Arrays.clone(this.info);
    }

    public int getR() {
        return this.r;
    }

    public CounterLocation getCounterLocation() {
        return this.location;
    }

    public byte[] getIV() {
        return this.iv;
    }

    public static class Builder {
        private final KDFMode kdfMode;
        private final int r;
        private byte[] salt;
        private byte[] info;
        private CounterLocation location;
        private byte[] iv;

        public Builder(KDFMode kdfMode) {
            if (kdfMode == KDFMode.Counter) {
                throw new IllegalArgumentException("Counter mode needs to be used with r value");
            }
            this.kdfMode = kdfMode;
            this.r = -1;
        }

        public Builder(KDFMode kdfMode, int r) {
            if (r % 8 != 0) {
                throw new IllegalArgumentException("r must be a multiple of 8");
            }
            this.kdfMode = kdfMode;
            this.r = r;
            this.location = CounterLocation.AfterIterationData;
        }

        public Builder withSalt(byte[] salt) {
            this.salt = Arrays.clone(salt);
            return this;
        }

        public Builder withInfo(byte[] info) {
            this.info = Arrays.clone(info);
            return this;
        }

        public Builder withIV(byte[] iv) {
            this.iv = Arrays.clone(iv);
            return this;
        }

        public Builder withCounterLocation(CounterLocation location) {
            if (this.r < 0) {
                throw new IllegalStateException("no counter width specified in constructor");
            }
            this.location = location;
            return this;
        }

        public TwoStepKDFParameterSpec build() {
            return new TwoStepKDFParameterSpec(this);
        }
    }

    public static enum CounterLocation {
        AfterIterationData,
        AfterFixedInput,
        BeforeIterationData;

    }

    public static enum KDFMode {
        Counter,
        Feedback,
        DoublePipeline;

    }
}

