/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.CertificateFactory;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.JcaJceKeyHelper;
import org.bouncycastle.jcajce.provider.X509KeyFactory;

class ProvX509
extends AsymmetricAlgorithmProvider {
    ProvX509() {
    }

    @Override
    public void configure(final BouncyCastleFipsProvider provider) {
        provider.addAlgorithmImplementation("KeyFactory.X.509", "org.bouncycastle.jcajce.provider.asymmetric.x509.KeyFactory", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new X509KeyFactory(provider);
            }
        });
        provider.addAlias("Alg.Alias.KeyFactory.X509", "X.509");
        provider.addAlgorithmImplementation("CertificateFactory.X.509", "org.bouncycastle.jcajce.provider.asymmetric.x509.CertificateFactory", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new CertificateFactory(new JcaJceKeyHelper(provider));
            }
        });
        provider.addAlias("Alg.Alias.CertificateFactory.X509", "X.509");
    }
}

