/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.RSAPrivateKeySpec;
import javax.security.auth.Destroyable;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAPrivateKey;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.ProvKey;
import org.bouncycastle.util.Strings;

class ProvRSAPrivateKey
implements Destroyable,
RSAPrivateKey,
ProvKey<AsymmetricRSAPrivateKey> {
    static final long serialVersionUID = 5110188922551353628L;
    private transient AsymmetricRSAPrivateKey baseKey;

    ProvRSAPrivateKey(Algorithm algorithm, RSAPrivateKey key) {
        this.baseKey = new AsymmetricRSAPrivateKey(algorithm, key.getModulus(), key.getPrivateExponent());
    }

    ProvRSAPrivateKey(Algorithm algorithm, RSAPrivateKeySpec keySpec) {
        this.baseKey = new AsymmetricRSAPrivateKey(algorithm, keySpec.getModulus(), keySpec.getPrivateExponent());
    }

    ProvRSAPrivateKey(AsymmetricRSAPrivateKey key) {
        this.baseKey = key;
    }

    @Override
    public AsymmetricRSAPrivateKey getBaseKey() {
        KeyUtil.checkDestroyed(this.baseKey);
        return this.baseKey;
    }

    @Override
    public BigInteger getModulus() {
        return this.baseKey.getModulus();
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.baseKey.getPrivateExponent();
    }

    @Override
    public String getFormat() {
        KeyUtil.checkDestroyed(this.baseKey);
        return "PKCS#8";
    }

    @Override
    public String getAlgorithm() {
        KeyUtil.checkDestroyed(this.baseKey);
        if ("RSA/PSS".equals(this.baseKey.getAlgorithm().getName())) {
            return "RSASSA-PSS";
        }
        return "RSA";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public void destroy() {
        this.baseKey.destroy();
    }

    @Override
    public boolean isDestroyed() {
        return this.baseKey.isDestroyed();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String nl = Strings.lineSeparator();
        if (this.isDestroyed()) {
            buf.append("RSA Private Key [DESTROYED]").append(nl);
        } else {
            buf.append("RSA Private Key [").append(KeyUtil.generateFingerPrint(this.getModulus())).append("],[]").append(nl);
            buf.append("         modulus: ").append(this.getModulus().toString(16)).append(nl);
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProvRSAPrivateKey)) {
            return false;
        }
        ProvRSAPrivateKey other = (ProvRSAPrivateKey)o;
        return this.baseKey.equals(other.baseKey);
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Algorithm alg = (Algorithm)in.readObject();
        byte[] enc = (byte[])in.readObject();
        this.baseKey = new AsymmetricRSAPrivateKey(alg, enc);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.isDestroyed()) {
            throw new IOException("key has been destroyed");
        }
        out.defaultWriteObject();
        out.writeObject(this.baseKey.getAlgorithm());
        out.writeObject(this.getEncoded());
    }
}

