/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.BEROutputStream;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.GOST28147Parameters;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.AuthenticatedSafe;
import org.bouncycastle.asn1.pkcs.CertBag;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.EncryptedData;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.MacData;
import org.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.Pfx;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.SafeBag;
import org.bouncycastle.asn1.util.ASN1Dump;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.PasswordConverter;
import org.bouncycastle.crypto.fips.FipsDigestAlgorithm;
import org.bouncycastle.crypto.fips.FipsOutputDigestCalculator;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.general.PBKD;
import org.bouncycastle.crypto.general.SecureHash;
import org.bouncycastle.jcajce.BCLoadStoreParameter;
import org.bouncycastle.jcajce.ConsistentKeyPair;
import org.bouncycastle.jcajce.PKCS12Key;
import org.bouncycastle.jcajce.PKCS12KeyWithParameters;
import org.bouncycastle.jcajce.PKCS12StoreParameter;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BaseAlgorithmParameters;
import org.bouncycastle.jcajce.provider.BaseKDFSecretKeyFactory;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.KeyIvSizeProvider;
import org.bouncycastle.jcajce.provider.PBKDFPBEKey;
import org.bouncycastle.jcajce.provider.ProvIOException;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.spec.GOST28147ParameterSpec;
import org.bouncycastle.jcajce.spec.PBKDF2KeySpec;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

class ProvPKCS12
extends AsymmetricAlgorithmProvider {
    private static final Logger LOG = Logger.getLogger(ProvPKCS12.class.getName());
    private static final KeyIvSizeProvider sizeProvider = new KeyIvSizeProvider();
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.keystore.pkcs12.";

    ProvPKCS12() {
    }

    static SecretKey getSecretKey(DigestAlgorithm prf, String algName, PBEKeySpec pbeKeySpec, PasswordBasedDeriver.KeyType keyType, int keySizeInBits) {
        PasswordBasedDeriver<PBKD.Parameters> deriver = new PBKD.DeriverFactory().createDeriver(PBKD.PKCS12.using(prf, PasswordConverter.PKCS12, pbeKeySpec.getPassword()).withIterationCount(pbeKeySpec.getIterationCount()).withSalt(pbeKeySpec.getSalt()));
        byte[] key = deriver.deriveKey(keyType, (keySizeInBits + 7) / 8);
        return new PBKDFPBEKey(key, algName, pbeKeySpec);
    }

    static byte[] getSecretKey(SecretKey pbeKey, PBEParameterSpec pbeSpec, PasswordBasedDeriver.KeyType keyType, int keySizeInBits) {
        PasswordBasedDeriver<PBKD.Parameters> deriver = new PBKD.DeriverFactory().createDeriver(PBKD.PKCS12.using(FipsSHS.Algorithm.SHA1, pbeKey.getEncoded()).withIterationCount(pbeSpec.getIterationCount()).withSalt(pbeSpec.getSalt()));
        return deriver.deriveKey(keyType, (keySizeInBits + 7) / 8);
    }

    static byte[] getSecretKey(SecretKey pbeKey, DigestAlgorithm digest, PBEParameterSpec pbeSpec, PasswordBasedDeriver.KeyType keyType, int keySizeInBits) {
        PasswordBasedDeriver<PBKD.Parameters> deriver = new PBKD.DeriverFactory().createDeriver(PBKD.PKCS12.using(digest, pbeKey.getEncoded()).withIterationCount(pbeSpec.getIterationCount()).withSalt(pbeSpec.getSalt()));
        return deriver.deriveKey(keyType, (keySizeInBits + 7) / 8);
    }

    static byte[][] getSecretKeyAndIV(SecretKey pbeKey, DigestAlgorithm digest, PBEParameterSpec pbeSpec, PasswordBasedDeriver.KeyType keyType, int keySizeInBits, int ivvSizeInBits) {
        PasswordBasedDeriver<PBKD.Parameters> deriver = new PBKD.DeriverFactory().createDeriver(PBKD.PKCS12.using(digest, pbeKey.getEncoded()).withIterationCount(pbeSpec.getIterationCount()).withSalt(pbeSpec.getSalt()));
        return deriver.deriveKeyAndIV(keyType, (keySizeInBits + 7) / 8, (ivvSizeInBits + 7) / 8);
    }

    @Override
    public void configure(final BouncyCastleFipsProvider provider) {
        provider.addAlgorithmImplementation("KeyStore.PKCS12", "org.bouncycastle.jcajce.provider.keystore.pkcs12.PKCS12KeyStoreSpi$BCPKCS12KeyStore3DES", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BCPKCS12KeyStore3DES(true, provider);
            }
        });
        provider.addAlias("Alg.Alias.KeyStore.BCPKCS12", "PKCS12");
        provider.addAlias("Alg.Alias.KeyStore.PKCS12-3DES-3DES", "PKCS12");
        provider.addAlgorithmImplementation("KeyStore.PKCS12-DEF", "org.bouncycastle.jcajce.provider.keystore.pkcs12.PKCS12KeyStoreSpi$DefPKCS12KeyStore3DES", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new DefPKCS12KeyStore3DES(provider);
            }
        });
        provider.addAlias("Alg.Alias.KeyStore.PKCS12-DEF-3DES-3DES", "PKCS12-DEF");
        provider.addAlgorithmImplementation("KeyStore.PKCS12-3DES-40RC2", "org.bouncycastle.jcajce.provider.keystore.pkcs12.PKCS12KeyStoreSpi$BCPKCS12KeyStore", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BCPKCS12KeyStore3DES40BitRC2(provider);
            }
        }));
        provider.addAlgorithmImplementation("KeyStore.PKCS12-DEF-3DES-40RC2", "org.bouncycastle.jcajce.provider.keystore.pkcs12.PKCS12KeyStoreSpi$DefPKCS12KeyStore", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new DefPKCS12KeyStore3DES40BitRC2(provider);
            }
        }));
        provider.addAlgorithmImplementation("AlgorithmParameters.PBKDF-PKCS12", "org.bouncycastle.jcajce.provider.keystore.pkcs12.PKCS12AlgParams", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new AlgParams();
            }
        }));
        provider.addAlgorithmImplementation("AlgorithmParameters.PBKDF-PKCS12WITHSHA256", "org.bouncycastle.jcajce.provider.keystore.pkcs12.PKCS12SHA256AlgParams", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new AlgParams();
            }
        }));
        provider.addAlgorithmImplementation("SecretKeyFactory.PBKDF-PKCS12", "org.bouncycastle.jcajce.provider.keystore.pkcs12.PKCS12SecKeyFact", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new GeneralKeyFactory("PBKDF-PKCS12withSHA1", FipsSHS.Algorithm.SHA1, PasswordBasedDeriver.KeyType.CIPHER);
            }
        }));
        provider.addAlgorithmImplementation("SecretKeyFactory.PBKDF-PKCS12WITHSHA256", "org.bouncycastle.jcajce.provider.keystore.pkcs12.PKCS12SHA256SecKeyFact", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new GeneralKeyFactory("PBKDF-PKCS12withSHA256", FipsSHS.Algorithm.SHA256, PasswordBasedDeriver.KeyType.CIPHER);
            }
        }));
    }

    static class AlgParams
    extends BaseAlgorithmParameters {
        PKCS12PBEParams params;

        AlgParams() {
        }

        @Override
        protected byte[] localGetEncoded() throws IOException {
            return this.params.getEncoded("DER");
        }

        @Override
        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == PBEParameterSpec.class || paramSpec == AlgorithmParameterSpec.class) {
                return new PBEParameterSpec(this.params.getIV(), this.params.getIterations().intValue());
            }
            throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + paramSpec.getName());
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (!(paramSpec instanceof PBEParameterSpec)) {
                throw new InvalidParameterSpecException("PBEParameterSpec required to initialise a PBKDF-PKCS12 parameters algorithm parameters object");
            }
            PBEParameterSpec pbeSpec = (PBEParameterSpec)paramSpec;
            this.params = new PKCS12PBEParams(pbeSpec.getSalt(), pbeSpec.getIterationCount());
        }

        @Override
        protected void localInit(byte[] params) throws IOException {
            this.params = PKCS12PBEParams.getInstance(params);
        }

        @Override
        protected String engineToString() {
            return "PBKDF-PKCS12 Parameters";
        }
    }

    private static class BCPKCS12KeyStore3DES
    extends PKCS12KeyStoreSpi {
        public BCPKCS12KeyStore3DES(boolean matchOnProbe, BouncyCastleFipsProvider fipsProvider) {
            super(true, fipsProvider, fipsProvider, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd3_KeyTripleDES_CBC);
        }
    }

    private static class BCPKCS12KeyStore3DES40BitRC2
    extends PKCS12KeyStoreSpi {
        public BCPKCS12KeyStore3DES40BitRC2(BouncyCastleFipsProvider fipsProvider) {
            super(fipsProvider, fipsProvider, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd40BitRC2_CBC);
        }
    }

    private static class DefPKCS12KeyStore3DES
    extends PKCS12KeyStoreSpi {
        public DefPKCS12KeyStore3DES(BouncyCastleFipsProvider fipsProvider) {
            super(fipsProvider, null, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd3_KeyTripleDES_CBC);
        }
    }

    private static class DefPKCS12KeyStore3DES40BitRC2
    extends PKCS12KeyStoreSpi {
        public DefPKCS12KeyStore3DES40BitRC2(BouncyCastleFipsProvider fipsProvider) {
            super(fipsProvider, null, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd40BitRC2_CBC);
        }
    }

    static class GeneralKeyFactory
    extends BaseKDFSecretKeyFactory {
        private final String algName;
        private final FipsDigestAlgorithm prf;
        private final PasswordBasedDeriver.KeyType keyType;

        protected GeneralKeyFactory(String algName, FipsDigestAlgorithm prf, PasswordBasedDeriver.KeyType keyType) {
            this.algName = algName;
            this.prf = prf;
            this.keyType = keyType;
        }

        @Override
        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PBEKeySpec) {
                PBEKeySpec pbeKeySpec = (PBEKeySpec)keySpec;
                if (pbeKeySpec.getSalt() == null) {
                    return new PKCS12Key(pbeKeySpec.getPassword());
                }
                return ProvPKCS12.getSecretKey(this.prf, this.algName, pbeKeySpec, this.keyType, pbeKeySpec.getKeyLength());
            }
            if (keySpec == null) {
                throw new InvalidKeySpecException("KeySpec cannot be null");
            }
            throw new InvalidKeySpecException("Invalid KeySpec: " + keySpec.getClass().getName());
        }
    }

    static class KeyFactory
    extends BaseKDFSecretKeyFactory {
        private final String algName;
        private final int keySizeInBits;
        private final PasswordBasedDeriver.KeyType keyType;
        private final DigestAlgorithm prf;

        protected KeyFactory(String algName, DigestAlgorithm prf, PasswordBasedDeriver.KeyType keyType, int keySizeInBits) {
            this.algName = algName;
            this.prf = prf;
            this.keyType = keyType;
            this.keySizeInBits = keySizeInBits;
        }

        protected KeyFactory(String algName, PasswordBasedDeriver.KeyType keyType, int keySizeInBits) {
            this(algName, FipsSHS.Algorithm.SHA1, keyType, keySizeInBits);
        }

        @Override
        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PBEKeySpec) {
                PBEKeySpec pbeKeySpec = (PBEKeySpec)keySpec;
                if (pbeKeySpec.getSalt() == null) {
                    return new PKCS12Key(((PBEKeySpec)keySpec).getPassword());
                }
                return ProvPKCS12.getSecretKey(this.prf, this.algName, pbeKeySpec, this.keyType, this.keySizeInBits);
            }
            if (keySpec == null) {
                throw new InvalidKeySpecException("KeySpec cannot be null");
            }
            throw new InvalidKeySpecException("Invalid KeySpec: " + keySpec.getClass().getName());
        }
    }

    private static class PKCS12KeyStoreSpi
    extends KeyStoreSpi
    implements PKCSObjectIdentifiers,
    X509ObjectIdentifiers {
        private static final int SALT_SIZE = 20;
        private static final int MIN_ITERATIONS = 1024;
        private IgnoresCaseHashtable privateKeyCache = new IgnoresCaseHashtable();
        private IgnoresCaseHashtable keys = new IgnoresCaseHashtable();
        private IgnoresCaseHashtable localIds = new IgnoresCaseHashtable();
        private IgnoresCaseHashtable certs = new IgnoresCaseHashtable();
        private Hashtable chainCerts = new Hashtable();
        private Hashtable keyCerts = new Hashtable();
        private boolean wrongPKCS12Zero = false;
        static final int NULL = 0;
        static final int CERTIFICATE = 1;
        static final int KEY = 2;
        static final int SECRET = 3;
        static final int SEALED = 4;
        static final int KEY_PRIVATE = 0;
        static final int KEY_PUBLIC = 1;
        static final int KEY_SECRET = 2;
        protected final SecureRandom random;
        private CertificateFactory certFact;
        private final boolean matchOnProbe;
        private BouncyCastleFipsProvider fipsProvider;
        private ASN1ObjectIdentifier keyAlgorithm;
        private ASN1ObjectIdentifier certAlgorithm;

        public PKCS12KeyStoreSpi(BouncyCastleFipsProvider fipsProvider, Provider certProvider, ASN1ObjectIdentifier keyAlgorithm, ASN1ObjectIdentifier certAlgorithm) {
            this(false, fipsProvider, certProvider, keyAlgorithm, certAlgorithm);
        }

        public PKCS12KeyStoreSpi(boolean matchOnProbe, BouncyCastleFipsProvider fipsProvider, Provider certProvider, ASN1ObjectIdentifier keyAlgorithm, ASN1ObjectIdentifier certAlgorithm) {
            this.matchOnProbe = matchOnProbe;
            this.fipsProvider = fipsProvider;
            this.keyAlgorithm = keyAlgorithm;
            this.certAlgorithm = certAlgorithm;
            this.random = fipsProvider.getDefaultSecureRandom();
            try {
                this.certFact = certProvider != null ? CertificateFactory.getInstance("X.509", certProvider) : CertificateFactory.getInstance("X.509");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("can't create cert factory - " + e.toString());
            }
        }

        private static SubjectKeyIdentifier createSubjectKeyId(PublicKey pubKey) throws IOException {
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(pubKey.getEncoded()));
            return new SubjectKeyIdentifier(PKCS12KeyStoreSpi.getDigest(info));
        }

        private static byte[] getDigest(SubjectPublicKeyInfo spki) {
            FipsOutputDigestCalculator<FipsSHS.Parameters> calculator = new FipsSHS.OperatorFactory<FipsSHS.Parameters>().createOutputDigestCalculator(FipsSHS.SHA1);
            calculator.getDigestStream().update(spki.getPublicKeyData().getBytes());
            return calculator.getDigest();
        }

        @Override
        public boolean engineProbe(InputStream stream) throws IOException {
            if (!this.matchOnProbe) {
                return false;
            }
            BufferedInputStream storeStream = stream instanceof BufferedInputStream ? (BufferedInputStream)stream : new BufferedInputStream(stream);
            storeStream.mark(10);
            int hdr = storeStream.read();
            if (hdr != 48) {
                return false;
            }
            storeStream.reset();
            ASN1InputStream asn1Stream = new ASN1InputStream(storeStream);
            try {
                Pfx.getInstance(asn1Stream.readObject());
            }
            catch (Exception e) {
                return false;
            }
            return asn1Stream.available() == 0;
        }

        public Enumeration engineAliases() {
            Hashtable<Object, String> tab = new Hashtable<Object, String>();
            Enumeration e = this.certs.keys();
            while (e.hasMoreElements()) {
                tab.put(e.nextElement(), "cert");
            }
            e = this.keys.keys();
            while (e.hasMoreElements()) {
                String a = (String)e.nextElement();
                if (tab.get(a) != null) continue;
                tab.put(a, "key");
            }
            return tab.keys();
        }

        @Override
        public boolean engineContainsAlias(String alias) {
            if (alias == null) {
                throw new NullPointerException("alias value is null");
            }
            return this.certs.get(alias) != null || this.keys.get(alias) != null;
        }

        @Override
        public void engineDeleteEntry(String alias) throws KeyStoreException {
            Key k = (Key)this.keys.remove(alias);
            this.privateKeyCache.remove(alias);
            Certificate c = (Certificate)this.certs.remove(alias);
            if (c != null) {
                this.removeChainCert(c);
            }
            if (k != null) {
                String id = (String)this.localIds.remove(alias);
                if (id != null) {
                    c = (Certificate)this.keyCerts.remove(id);
                }
                if (c != null) {
                    this.removeChainCert(c);
                }
            }
        }

        private void removeChainCert(Certificate c) throws KeyStoreException {
            try {
                this.chainCerts.remove(new CertId(c.getPublicKey()));
            }
            catch (IOException e) {
                throw new KeyStoreException("Exception: " + e.getMessage(), e);
            }
        }

        @Override
        public Certificate engineGetCertificate(String alias) {
            if (alias == null) {
                throw new IllegalArgumentException("null alias passed to getCertificate.");
            }
            Certificate c = (Certificate)this.certs.get(alias);
            if (c == null) {
                String id = (String)this.localIds.get(alias);
                c = id != null ? (Certificate)this.keyCerts.get(id) : (Certificate)this.keyCerts.get(alias);
            }
            return c;
        }

        @Override
        public String engineGetCertificateAlias(Certificate cert) {
            String ta;
            Certificate tc;
            Enumeration c = this.certs.elements();
            Enumeration k = this.certs.keys();
            while (c.hasMoreElements()) {
                tc = (Certificate)c.nextElement();
                ta = (String)k.nextElement();
                if (!tc.equals(cert)) continue;
                return ta;
            }
            c = this.keyCerts.elements();
            k = this.keyCerts.keys();
            while (c.hasMoreElements()) {
                tc = (Certificate)c.nextElement();
                ta = (String)k.nextElement();
                if (!tc.equals(cert)) continue;
                return ta;
            }
            return null;
        }

        @Override
        public Certificate[] engineGetCertificateChain(String alias) {
            if (alias == null) {
                throw new IllegalArgumentException("null alias passed to getCertificateChain.");
            }
            if (!this.engineIsKeyEntry(alias)) {
                return null;
            }
            Certificate c = this.engineGetCertificate(alias);
            if (c != null) {
                Vector<Certificate> cs = new Vector<Certificate>();
                while (c != null) {
                    Principal s;
                    Principal i;
                    byte[] authBytes;
                    AuthorityKeyIdentifier id;
                    X509Certificate x509c = (X509Certificate)c;
                    Certificate nextC = null;
                    byte[] bytes = x509c.getExtensionValue(Extension.authorityKeyIdentifier.getId());
                    if (bytes != null && (id = AuthorityKeyIdentifier.getInstance(authBytes = ASN1OctetString.getInstance(bytes).getOctets())).getKeyIdentifier() != null) {
                        nextC = (Certificate)this.chainCerts.get(new CertId(id.getKeyIdentifier()));
                    }
                    if (nextC == null && !(i = x509c.getIssuerDN()).equals(s = x509c.getSubjectDN())) {
                        Enumeration e = this.chainCerts.keys();
                        while (e.hasMoreElements()) {
                            X509Certificate crt = (X509Certificate)this.chainCerts.get(e.nextElement());
                            Principal sub = crt.getSubjectDN();
                            if (!sub.equals(i)) continue;
                            try {
                                x509c.verify(crt.getPublicKey());
                                nextC = crt;
                                break;
                            }
                            catch (Exception exception) {
                            }
                        }
                    }
                    if (cs.contains(c)) {
                        c = null;
                        continue;
                    }
                    cs.addElement(c);
                    if (nextC != c) {
                        c = nextC;
                        continue;
                    }
                    c = null;
                }
                Certificate[] certChain = new Certificate[cs.size()];
                for (int i = 0; i != certChain.length; ++i) {
                    certChain[i] = (Certificate)cs.elementAt(i);
                }
                return certChain;
            }
            return null;
        }

        @Override
        public Date engineGetCreationDate(String alias) {
            if (alias == null) {
                throw new NullPointerException("alias == null");
            }
            if (this.keys.get(alias) == null && this.certs.get(alias) == null) {
                return null;
            }
            return new Date();
        }

        @Override
        public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
            if (alias == null) {
                throw new IllegalArgumentException("null alias passed to getKey.");
            }
            Key key = (Key)this.keys.get(alias);
            try {
                if (key instanceof PrivateKey) {
                    if (this.privateKeyCache.get(alias) != null) {
                        return key;
                    }
                    Certificate cert = this.engineGetCertificate(alias);
                    if (cert != null) {
                        new ConsistentKeyPair(cert.getPublicKey(), (PrivateKey)key);
                        this.privateKeyCache.put(alias, key);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new UnrecoverableKeyException(e.getMessage());
            }
            return key;
        }

        @Override
        public boolean engineIsCertificateEntry(String alias) {
            return this.certs.get(alias) != null && this.keys.get(alias) == null;
        }

        @Override
        public boolean engineIsKeyEntry(String alias) {
            return this.keys.get(alias) != null;
        }

        @Override
        public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
            if (this.keys.get(alias) != null) {
                throw new KeyStoreException("There is a key entry with the name " + alias + ".");
            }
            this.certs.put(alias, cert);
            this.putChainCert(cert);
        }

        @Override
        public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
            throw new KeyStoreException("operation not supported");
        }

        @Override
        public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
            if (!(key instanceof PrivateKey)) {
                throw new KeyStoreException("PKCS12 does not support non-PrivateKeys");
            }
            if (chain == null) {
                throw new KeyStoreException("no certificate chain for private key");
            }
            if (this.keys.get(alias) != null) {
                this.engineDeleteEntry(alias);
            }
            try {
                new ConsistentKeyPair(chain[0].getPublicKey(), (PrivateKey)key);
            }
            catch (IllegalArgumentException e) {
                throw new KeyStoreException(e.getMessage());
            }
            this.keys.put(alias, key);
            this.privateKeyCache.put(alias, key);
            this.certs.put(alias, chain[0]);
            for (int i = 0; i != chain.length; ++i) {
                this.putChainCert(chain[i]);
            }
        }

        private void putChainCert(Certificate c) throws KeyStoreException {
            try {
                this.chainCerts.put(new CertId(c.getPublicKey()), c);
            }
            catch (IOException e) {
                throw new KeyStoreException("Exception: " + e.getMessage(), e);
            }
        }

        @Override
        public int engineSize() {
            Hashtable<Object, String> tab = new Hashtable<Object, String>();
            Enumeration e = this.certs.keys();
            while (e.hasMoreElements()) {
                tab.put(e.nextElement(), "cert");
            }
            e = this.keys.keys();
            while (e.hasMoreElements()) {
                String a = (String)e.nextElement();
                if (tab.get(a) != null) continue;
                tab.put(a, "key");
            }
            return tab.size();
        }

        @Override
        public void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException {
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                super.engineSetEntry(alias, entry, new KeyStore.PasswordProtection(new char[0]));
            } else {
                if (entry instanceof KeyStore.SecretKeyEntry) {
                    throw new KeyStoreException("PKCS12 does not support storage of symmetric keys.");
                }
                super.engineSetEntry(alias, entry, null);
            }
        }

        protected PrivateKey unwrapKey(AlgorithmIdentifier algId, byte[] data, char[] password) throws IOException {
            ASN1ObjectIdentifier algorithm = algId.getAlgorithm();
            try {
                Cipher cipher;
                if (algorithm.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
                    cipher = this.createPKCS12Cipher(4, password, algId);
                } else if (algorithm.equals(PKCSObjectIdentifiers.id_PBES2)) {
                    cipher = this.createPBES2Cipher(4, password, algId);
                } else {
                    throw new IOException("exception unwrapping private key - cannot recognize: " + algorithm);
                }
                return (PrivateKey)cipher.unwrap(data, "", 2);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ProvIOException("exception unwrapping private key - " + e.toString(), e);
            }
        }

        protected byte[] wrapKey(AlgorithmIdentifier algId, Key key, char[] password) throws IOException {
            ASN1ObjectIdentifier algorithm = algId.getAlgorithm();
            try {
                Cipher cipher;
                if (algorithm.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
                    cipher = this.createPKCS12Cipher(3, password, algId);
                } else if (algorithm.equals(PKCSObjectIdentifiers.id_PBES2)) {
                    cipher = this.createPBES2Cipher(3, password, algId);
                } else {
                    throw new IOException("exception unwrapping private key - cannot recognize: " + algorithm);
                }
                return cipher.wrap(key);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ProvIOException("exception unwrapping private key - " + e.toString(), e);
            }
        }

        protected byte[] cryptData(boolean forEncryption, AlgorithmIdentifier algId, char[] password, byte[] data) throws IOException {
            ASN1ObjectIdentifier algorithm = algId.getAlgorithm();
            int mode = forEncryption ? 1 : 2;
            try {
                Cipher cipher;
                if (algorithm.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
                    cipher = this.createPKCS12Cipher(mode, password, algId);
                } else if (algorithm.equals(PKCSObjectIdentifiers.id_PBES2)) {
                    cipher = this.createPBES2Cipher(mode, password, algId);
                } else {
                    throw new IOException("unknown PBE algorithm: " + algorithm);
                }
                return cipher.doFinal(data);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ProvIOException("exception decrypting data - " + e.toString(), e);
            }
        }

        private Cipher createPKCS12Cipher(int mode, char[] password, AlgorithmIdentifier algId) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
            PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algId.getParameters());
            PKCS12KeyWithParameters key = new PKCS12KeyWithParameters(password, this.wrongPKCS12Zero, pbeParams.getIV(), pbeParams.getIterations().intValue());
            Cipher cipher = Cipher.getInstance(algId.getAlgorithm().getId(), this.fipsProvider);
            cipher.init(mode, (Key)key, this.random);
            return cipher;
        }

        private Cipher createPBES2Cipher(int mode, char[] password, AlgorithmIdentifier algId) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
            AlgorithmParameterSpec params;
            PBES2Parameters alg = PBES2Parameters.getInstance(algId.getParameters());
            PBKDF2Params func = PBKDF2Params.getInstance(alg.getKeyDerivationFunc().getParameters());
            AlgorithmIdentifier encScheme = AlgorithmIdentifier.getInstance(alg.getEncryptionScheme());
            SecretKeyFactory keyFact = SecretKeyFactory.getInstance(alg.getKeyDerivationFunc().getAlgorithm().getId(), this.fipsProvider);
            SecretKey key = func.isDefaultPrf() ? keyFact.generateSecret(new PBEKeySpec(password, func.getSalt(), func.getIterationCount().intValue(), sizeProvider.getKeySize(encScheme) * 8)) : keyFact.generateSecret(new PBKDF2KeySpec(password, func.getSalt(), func.getIterationCount().intValue(), sizeProvider.getKeySize(encScheme) * 8, func.getPrf()));
            Cipher cipher = Cipher.getInstance(encScheme.getAlgorithm().getId());
            ASN1Encodable encParams = encScheme.getParameters();
            if (encParams instanceof ASN1OctetString) {
                params = new IvParameterSpec(ASN1OctetString.getInstance(encParams).getOctets());
            } else {
                GOST28147Parameters gParams = GOST28147Parameters.getInstance(encParams);
                params = new GOST28147ParameterSpec(gParams.getEncryptionParamSet(), gParams.getIV());
            }
            cipher.init(mode, (Key)key, params, this.random);
            return cipher;
        }

        @Override
        public void engineLoad(InputStream stream, char[] password) throws IOException {
            this.privateKeyCache.clear();
            if (stream == null) {
                return;
            }
            if (password == null) {
                throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
            }
            BufferedInputStream bufIn = new BufferedInputStream(stream);
            bufIn.mark(10);
            int head = bufIn.read();
            if (head < 0) {
                throw new EOFException("no data in keystore stream");
            }
            if (head != 48) {
                throw new IOException("stream does not represent a PKCS12 key store");
            }
            bufIn.reset();
            ASN1InputStream bIn = new ASN1InputStream(bufIn);
            ASN1Sequence obj = (ASN1Sequence)bIn.readObject();
            Pfx bag = Pfx.getInstance(obj);
            ContentInfo info = bag.getAuthSafe();
            Vector<SafeBag> chain = new Vector<SafeBag>();
            boolean unmarkedKey = false;
            if (bag.getMacData() != null) {
                MacData mData = bag.getMacData();
                DigestInfo dInfo = mData.getMac();
                AlgorithmIdentifier algId = dInfo.getAlgorithmId();
                byte[] salt = mData.getSalt();
                int itCount = mData.getIterationCount().intValue();
                byte[] data = ((ASN1OctetString)info.getContent()).getOctets();
                try {
                    byte[] res = this.calculatePbeMac(algId, salt, itCount, password, data);
                    byte[] dig = dInfo.getDigest();
                    if (!Arrays.constantTimeAreEqual(res, dig)) {
                        if (password.length > 0) {
                            throw new IOException("PKCS12 key store mac invalid - wrong password or corrupted file.");
                        }
                        res = this.calculatePbeMacWrongZero(algId, salt, itCount, data);
                        if (!Arrays.constantTimeAreEqual(res, dig)) {
                            throw new IOException("PKCS12 key store mac invalid - wrong password or corrupted file.");
                        }
                        this.wrongPKCS12Zero = true;
                    }
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ProvIOException("error constructing MAC: " + e.toString(), e);
                }
            }
            this.keys = new IgnoresCaseHashtable();
            this.localIds = new IgnoresCaseHashtable();
            if (info.getContentType().equals(data)) {
                bIn = new ASN1InputStream(((ASN1OctetString)info.getContent()).getOctets());
                AuthenticatedSafe authSafe = AuthenticatedSafe.getInstance(bIn.readObject());
                ContentInfo[] c = authSafe.getContentInfo();
                for (int i = 0; i != c.length; ++i) {
                    if (c[i].getContentType().equals(data)) {
                        ASN1InputStream dIn = new ASN1InputStream(((ASN1OctetString)c[i].getContent()).getOctets());
                        ASN1Sequence seq = (ASN1Sequence)dIn.readObject();
                        for (int j = 0; j != seq.size(); ++j) {
                            SafeBag b = SafeBag.getInstance(seq.getObjectAt(j));
                            if (b.getBagId().equals(pkcs8ShroudedKeyBag)) {
                                EncryptedPrivateKeyInfo eIn = EncryptedPrivateKeyInfo.getInstance(b.getBagValue());
                                PrivateKey privKey = this.unwrapKey(eIn.getEncryptionAlgorithm(), eIn.getEncryptedData(), password);
                                String alias = null;
                                ASN1OctetString localId = null;
                                if (b.getBagAttributes() != null) {
                                    Enumeration e = b.getBagAttributes().getObjects();
                                    while (e.hasMoreElements()) {
                                        ASN1Sequence sq = (ASN1Sequence)e.nextElement();
                                        ASN1ObjectIdentifier aOid = (ASN1ObjectIdentifier)sq.getObjectAt(0);
                                        ASN1Set attrSet = (ASN1Set)sq.getObjectAt(1);
                                        ASN1Primitive attr = null;
                                        if (attrSet.size() <= 0) continue;
                                        attr = (ASN1Primitive)attrSet.getObjectAt(0);
                                        if (aOid.equals(pkcs_9_at_friendlyName)) {
                                            if (alias != null && !alias.equals(DERBMPString.getInstance(attr).getString())) {
                                                throw new IOException("attempt to add existing attribute with different value");
                                            }
                                            alias = DERBMPString.getInstance(attr).getString();
                                            this.keys.put(alias, privKey);
                                            continue;
                                        }
                                        if (!aOid.equals(pkcs_9_at_localKeyId)) continue;
                                        if (localId != null && !localId.equals(attr)) {
                                            throw new IOException("attempt to add existing attribute with different value");
                                        }
                                        localId = ASN1OctetString.getInstance(attr);
                                    }
                                }
                                if (localId != null) {
                                    String name = Strings.fromByteArray(Hex.encode(localId.getOctets()));
                                    if (alias == null) {
                                        this.keys.put(name, privKey);
                                        continue;
                                    }
                                    this.localIds.put(alias, name);
                                    continue;
                                }
                                unmarkedKey = true;
                                this.keys.put("unmarked", privKey);
                                continue;
                            }
                            if (b.getBagId().equals(certBag)) {
                                chain.addElement(b);
                                continue;
                            }
                            LOG.info("extra in data " + b.getBagId());
                            LOG.fine(ASN1Dump.dumpAsString(b));
                        }
                        continue;
                    }
                    if (c[i].getContentType().equals(encryptedData)) {
                        EncryptedData d = EncryptedData.getInstance(c[i].getContent());
                        byte[] octets = this.cryptData(false, d.getEncryptionAlgorithm(), password, d.getContent().getOctets());
                        ASN1Sequence seq = (ASN1Sequence)ASN1Primitive.fromByteArray(octets);
                        for (int j = 0; j != seq.size(); ++j) {
                            String name;
                            ASN1Primitive attr;
                            ASN1Set attrSet;
                            ASN1ObjectIdentifier aOid;
                            ASN1Sequence sq;
                            Enumeration e;
                            ASN1OctetString localId;
                            String alias;
                            PrivateKey privKey;
                            SafeBag b = SafeBag.getInstance(seq.getObjectAt(j));
                            if (b.getBagId().equals(certBag)) {
                                chain.addElement(b);
                                continue;
                            }
                            if (b.getBagId().equals(pkcs8ShroudedKeyBag)) {
                                EncryptedPrivateKeyInfo eIn = EncryptedPrivateKeyInfo.getInstance(b.getBagValue());
                                privKey = this.unwrapKey(eIn.getEncryptionAlgorithm(), eIn.getEncryptedData(), password);
                                alias = null;
                                localId = null;
                                e = b.getBagAttributes().getObjects();
                                while (e.hasMoreElements()) {
                                    sq = (ASN1Sequence)e.nextElement();
                                    aOid = (ASN1ObjectIdentifier)sq.getObjectAt(0);
                                    attrSet = (ASN1Set)sq.getObjectAt(1);
                                    attr = null;
                                    if (attrSet.size() <= 0) continue;
                                    attr = (ASN1Primitive)attrSet.getObjectAt(0);
                                    if (aOid.equals(pkcs_9_at_friendlyName)) {
                                        if (alias != null && !alias.equals(DERBMPString.getInstance(attr).getString())) {
                                            throw new IOException("attempt to add existing attribute with different value");
                                        }
                                        alias = DERBMPString.getInstance(attr).getString();
                                        this.keys.put(alias, privKey);
                                        continue;
                                    }
                                    if (!aOid.equals(pkcs_9_at_localKeyId)) continue;
                                    if (localId != null && !localId.equals(attr)) {
                                        throw new IOException("attempt to add existing attribute with different value");
                                    }
                                    localId = ASN1OctetString.getInstance(attr);
                                }
                                name = Strings.fromByteArray(Hex.encode(localId.getOctets()));
                                if (alias == null) {
                                    this.keys.put(name, privKey);
                                    continue;
                                }
                                this.localIds.put(alias, name);
                                continue;
                            }
                            if (b.getBagId().equals(keyBag)) {
                                PrivateKeyInfo kInfo = PrivateKeyInfo.getInstance(b.getBagValue());
                                privKey = this.fipsProvider.getPrivateKey(kInfo);
                                alias = null;
                                localId = null;
                                e = b.getBagAttributes().getObjects();
                                while (e.hasMoreElements()) {
                                    sq = (ASN1Sequence)e.nextElement();
                                    aOid = (ASN1ObjectIdentifier)sq.getObjectAt(0);
                                    attrSet = (ASN1Set)sq.getObjectAt(1);
                                    attr = null;
                                    if (attrSet.size() <= 0) continue;
                                    attr = (ASN1Primitive)attrSet.getObjectAt(0);
                                    if (aOid.equals(pkcs_9_at_friendlyName)) {
                                        if (alias != null && !alias.equals(DERBMPString.getInstance(attr).getString())) {
                                            throw new IOException("attempt to add existing attribute with different value");
                                        }
                                        alias = DERBMPString.getInstance(attr).getString();
                                        this.keys.put(alias, privKey);
                                        continue;
                                    }
                                    if (!aOid.equals(pkcs_9_at_localKeyId)) continue;
                                    if (localId != null && !localId.equals(attr)) {
                                        throw new IOException("attempt to add existing attribute with different value");
                                    }
                                    localId = ASN1OctetString.getInstance(attr);
                                }
                                name = Strings.fromByteArray(Hex.encode(localId.getOctets()));
                                if (alias == null) {
                                    this.keys.put(name, privKey);
                                    continue;
                                }
                                this.localIds.put(alias, name);
                                continue;
                            }
                            LOG.info("extra in encryptedData " + b.getBagId());
                            LOG.fine(ASN1Dump.dumpAsString(b));
                        }
                        continue;
                    }
                    LOG.info("extra " + c[i].getContentType().getId());
                    LOG.fine("extra " + ASN1Dump.dumpAsString(c[i].getContent()));
                }
            }
            this.certs = new IgnoresCaseHashtable();
            this.chainCerts = new Hashtable();
            this.keyCerts = new Hashtable();
            for (int i = 0; i != chain.size(); ++i) {
                String name;
                Certificate cert;
                SafeBag b = (SafeBag)chain.elementAt(i);
                CertBag cb = CertBag.getInstance(b.getBagValue());
                if (!cb.getCertId().equals(x509Certificate)) {
                    throw new IOException("Unsupported certificate type: " + cb.getCertId());
                }
                try {
                    ByteArrayInputStream cIn = new ByteArrayInputStream(((ASN1OctetString)cb.getCertValue()).getOctets());
                    cert = this.certFact.generateCertificate(cIn);
                }
                catch (Exception e) {
                    throw new ProvIOException(e.toString(), e);
                }
                ASN1OctetString localId = null;
                String alias = null;
                if (b.getBagAttributes() != null) {
                    Enumeration e = b.getBagAttributes().getObjects();
                    while (e.hasMoreElements()) {
                        ASN1Sequence sq = (ASN1Sequence)e.nextElement();
                        ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)sq.getObjectAt(0);
                        ASN1Primitive attr = (ASN1Primitive)((ASN1Set)sq.getObjectAt(1)).getObjectAt(0);
                        if (oid.equals(pkcs_9_at_friendlyName)) {
                            if (alias != null && !alias.equals(DERBMPString.getInstance(attr).getString())) {
                                throw new IOException("attempt to add existing attribute with different value");
                            }
                            alias = DERBMPString.getInstance(attr).getString();
                            continue;
                        }
                        if (!oid.equals(pkcs_9_at_localKeyId)) continue;
                        if (localId != null && !localId.equals(attr)) {
                            throw new IOException("attempt to add existing attribute with different value");
                        }
                        localId = ASN1OctetString.getInstance(attr);
                    }
                }
                this.chainCerts.put(new CertId(cert.getPublicKey()), cert);
                if (unmarkedKey) {
                    if (!this.keyCerts.isEmpty()) continue;
                    name = Strings.fromByteArray(Hex.encode(PKCS12KeyStoreSpi.createSubjectKeyId(cert.getPublicKey()).getKeyIdentifier()));
                    this.keyCerts.put(name, cert);
                    this.keys.put(name, this.keys.remove("unmarked"));
                    continue;
                }
                if (localId != null) {
                    name = Strings.fromByteArray(Hex.encode(localId.getOctets()));
                    this.keyCerts.put(name, cert);
                }
                if (alias == null) continue;
                this.certs.put(alias, cert);
            }
        }

        @Override
        public void engineStore(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
            if (param == null) {
                this.engineLoad(null, null);
            } else if (param instanceof BCLoadStoreParameter) {
                BCLoadStoreParameter bcParam = (BCLoadStoreParameter)param;
                this.engineLoad(bcParam.getInputStream(), Utils.extractPassword(param));
            } else if (param instanceof PKCS12StoreParameter) {
                PKCS12StoreParameter bcParam = (PKCS12StoreParameter)param;
                char[] password = Utils.extractPassword(param);
                this.doStore(bcParam.getOutputStream(), password, bcParam.isForDEREncoding());
            } else {
                throw new IllegalArgumentException("no support for 'param' of type " + param.getClass().getName());
            }
        }

        @Override
        public void engineStore(OutputStream stream, char[] password) throws IOException {
            this.doStore(stream, password, false);
        }

        private void doStore(OutputStream stream, char[] password, boolean useDEREncoding) throws IOException {
            MacData mData;
            ASN1EncodableVector fSeq;
            ASN1EncodableVector fName;
            CertBag cBag;
            Certificate cert;
            if (password == null) {
                throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
            }
            ASN1EncodableVector keyS = new ASN1EncodableVector();
            Enumeration ks = this.keys.keys();
            while (ks.hasMoreElements()) {
                byte[] kSalt = new byte[20];
                this.random.nextBytes(kSalt);
                String name = (String)ks.nextElement();
                PrivateKey privKey = (PrivateKey)this.keys.get(name);
                PKCS12PBEParams kParams = new PKCS12PBEParams(kSalt, 1024);
                AlgorithmIdentifier kAlgId = new AlgorithmIdentifier(this.keyAlgorithm, kParams);
                byte[] kBytes = this.wrapKey(kAlgId, privKey, password);
                EncryptedPrivateKeyInfo kInfo = new EncryptedPrivateKeyInfo(kAlgId, kBytes);
                ASN1EncodableVector kName = new ASN1EncodableVector();
                ASN1EncodableVector kSeq = new ASN1EncodableVector();
                Certificate ct = this.engineGetCertificate(name);
                kSeq.add(pkcs_9_at_localKeyId);
                kSeq.add(new DERSet(PKCS12KeyStoreSpi.createSubjectKeyId(ct.getPublicKey())));
                kName.add(new DERSequence(kSeq));
                kSeq = new ASN1EncodableVector();
                kSeq.add(pkcs_9_at_friendlyName);
                kSeq.add(new DERSet(new DERBMPString(name)));
                kName.add(new DERSequence(kSeq));
                SafeBag kBag = new SafeBag(pkcs8ShroudedKeyBag, kInfo.toASN1Primitive(), new DERSet(kName));
                keyS.add(kBag);
            }
            byte[] keySEncoded = new DERSequence(keyS).getEncoded("DER");
            BEROctetString keyString = new BEROctetString(keySEncoded);
            byte[] cSalt = new byte[20];
            this.random.nextBytes(cSalt);
            ASN1EncodableVector certSeq = new ASN1EncodableVector();
            PKCS12PBEParams cParams = new PKCS12PBEParams(cSalt, 1024);
            AlgorithmIdentifier cAlgId = new AlgorithmIdentifier(this.certAlgorithm, cParams.toASN1Primitive());
            Hashtable<Certificate, Certificate> doneCerts = new Hashtable<Certificate, Certificate>();
            Enumeration cs = this.keys.keys();
            while (cs.hasMoreElements()) {
                try {
                    String name = (String)cs.nextElement();
                    cert = this.engineGetCertificate(name);
                    boolean cAttrSet = false;
                    cBag = new CertBag(x509Certificate, new DEROctetString(cert.getEncoded()));
                    fName = new ASN1EncodableVector();
                    fSeq = new ASN1EncodableVector();
                    fSeq.add(pkcs_9_at_localKeyId);
                    fSeq.add(new DERSet(PKCS12KeyStoreSpi.createSubjectKeyId(cert.getPublicKey())));
                    fName.add(new DERSequence(fSeq));
                    fSeq = new ASN1EncodableVector();
                    fSeq.add(pkcs_9_at_friendlyName);
                    fSeq.add(new DERSet(new DERBMPString(name)));
                    fName.add(new DERSequence(fSeq));
                    SafeBag sBag = new SafeBag(certBag, cBag.toASN1Primitive(), new DERSet(fName));
                    certSeq.add(sBag);
                    doneCerts.put(cert, cert);
                }
                catch (CertificateEncodingException e) {
                    throw new IOException("Error encoding certificate: " + e.toString());
                }
            }
            cs = this.certs.keys();
            while (cs.hasMoreElements()) {
                try {
                    String certId = (String)cs.nextElement();
                    cert = (Certificate)this.certs.get(certId);
                    boolean cAttrSet = false;
                    if (this.keys.get(certId) != null) continue;
                    cBag = new CertBag(x509Certificate, new DEROctetString(cert.getEncoded()));
                    fName = new ASN1EncodableVector();
                    fSeq = new ASN1EncodableVector();
                    fSeq.add(pkcs_9_at_friendlyName);
                    fSeq.add(new DERSet(new DERBMPString(certId)));
                    fName.add(new DERSequence(fSeq));
                    TBSCertificate tbsCert = TBSCertificate.getInstance(((X509Certificate)cert).getTBSCertificate());
                    Extensions exts = tbsCert.getExtensions();
                    if (exts != null) {
                        Extension extUsage = exts.getExtension(Extension.extendedKeyUsage);
                        if (extUsage != null) {
                            fSeq = new ASN1EncodableVector();
                            fSeq.add(MiscObjectIdentifiers.id_oracle_pkcs12_trusted_key_usage);
                            fSeq.add(new DERSet(ExtendedKeyUsage.getInstance(extUsage.getParsedValue()).getUsages()));
                            fName.add(new DERSequence(fSeq));
                        } else {
                            fSeq = new ASN1EncodableVector();
                            fSeq.add(MiscObjectIdentifiers.id_oracle_pkcs12_trusted_key_usage);
                            fSeq.add(new DERSet(KeyPurposeId.anyExtendedKeyUsage));
                            fName.add(new DERSequence(fSeq));
                        }
                    } else {
                        fSeq = new ASN1EncodableVector();
                        fSeq.add(MiscObjectIdentifiers.id_oracle_pkcs12_trusted_key_usage);
                        fSeq.add(new DERSet(KeyPurposeId.anyExtendedKeyUsage));
                        fName.add(new DERSequence(fSeq));
                    }
                    SafeBag sBag = new SafeBag(certBag, cBag.toASN1Primitive(), new DERSet(fName));
                    certSeq.add(sBag);
                    doneCerts.put(cert, cert);
                }
                catch (CertificateEncodingException e) {
                    throw new IOException("Error encoding certificate: " + e.toString());
                }
            }
            Set usedSet = this.getUsedCertificateSet();
            cs = this.chainCerts.keys();
            while (cs.hasMoreElements()) {
                try {
                    CertId certId = (CertId)cs.nextElement();
                    Certificate cert2 = (Certificate)this.chainCerts.get(certId);
                    if (!usedSet.contains(cert2) || doneCerts.get(cert2) != null) continue;
                    cBag = new CertBag(x509Certificate, new DEROctetString(cert2.getEncoded()));
                    fName = new ASN1EncodableVector();
                    SafeBag sBag = new SafeBag(certBag, cBag.toASN1Primitive(), new DERSet(fName));
                    certSeq.add(sBag);
                }
                catch (CertificateEncodingException e) {
                    throw new IOException("Error encoding certificate: " + e.toString());
                }
            }
            byte[] certSeqEncoded = new DERSequence(certSeq).getEncoded("DER");
            byte[] certBytes = this.cryptData(true, cAlgId, password, certSeqEncoded);
            EncryptedData cInfo = new EncryptedData(data, cAlgId, new BEROctetString(certBytes));
            ContentInfo[] info = new ContentInfo[]{new ContentInfo(data, keyString), new ContentInfo(encryptedData, cInfo.toASN1Primitive())};
            AuthenticatedSafe auth = new AuthenticatedSafe(info);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream asn1Out = useDEREncoding ? new DEROutputStream(bOut) : new BEROutputStream(bOut);
            asn1Out.writeObject(auth);
            byte[] pkg = bOut.toByteArray();
            ContentInfo mainInfo = new ContentInfo(data, new BEROctetString(pkg));
            byte[] mSalt = new byte[20];
            int itCount = 1024;
            this.random.nextBytes(mSalt);
            byte[] data = ((ASN1OctetString)mainInfo.getContent()).getOctets();
            try {
                AlgorithmIdentifier algId = new AlgorithmIdentifier(id_SHA1, DERNull.INSTANCE);
                byte[] res = this.calculatePbeMac(algId, mSalt, itCount, password, data);
                DigestInfo dInfo = new DigestInfo(algId, res);
                mData = new MacData(dInfo, mSalt, itCount);
            }
            catch (Exception e) {
                throw new IOException("error constructing MAC: " + e.toString());
            }
            Pfx pfx = new Pfx(mainInfo, mData);
            asn1Out = useDEREncoding ? new DEROutputStream(stream) : new BEROutputStream(stream);
            asn1Out.writeObject(pfx);
        }

        private byte[] calculatePbeMacWrongZero(AlgorithmIdentifier algID, byte[] salt, int itCount, byte[] data) throws Exception {
            byte[] derivedKey = this.getDerivedMacKey(algID, new byte[2], salt, itCount);
            String algOID = algID.getAlgorithm().getId();
            Mac mac = Mac.getInstance(algOID, this.fipsProvider);
            mac.init(new SecretKeySpec(derivedKey, algOID));
            mac.update(data);
            return mac.doFinal();
        }

        private byte[] calculatePbeMac(AlgorithmIdentifier algID, byte[] salt, int itCount, char[] password, byte[] data) throws Exception {
            byte[] derivedKey = this.getDerivedMacKey(algID, PasswordConverter.PKCS12.convert(password), salt, itCount);
            String algOID = algID.getAlgorithm().getId();
            Mac mac = Mac.getInstance(algOID, this.fipsProvider);
            mac.init(new SecretKeySpec(derivedKey, algOID));
            mac.update(data);
            return mac.doFinal();
        }

        private byte[] getDerivedMacKey(AlgorithmIdentifier algID, byte[] password, byte[] salt, int itCount) {
            int keySize;
            PasswordBasedDeriver<PBKD.Parameters> deriver;
            if (algID.getAlgorithm().equals(CryptoProObjectIdentifiers.gostR3411)) {
                deriver = new PBKD.DeriverFactory().createDeriver(PBKD.PKCS12.using(SecureHash.Algorithm.GOST3411, password).withSalt(salt).withIterationCount(itCount));
                keySize = 32;
            } else if (algID.getAlgorithm().equals(NISTObjectIdentifiers.id_sha224)) {
                deriver = new PBKD.DeriverFactory().createDeriver(PBKD.PKCS12.using(FipsSHS.Algorithm.SHA224, password).withSalt(salt).withIterationCount(itCount));
                keySize = 28;
            } else if (algID.getAlgorithm().equals(NISTObjectIdentifiers.id_sha256)) {
                deriver = new PBKD.DeriverFactory().createDeriver(PBKD.PKCS12.using(FipsSHS.Algorithm.SHA256, password).withSalt(salt).withIterationCount(itCount));
                keySize = 32;
            } else {
                deriver = new PBKD.DeriverFactory().createDeriver(PBKD.PKCS12.using(FipsSHS.Algorithm.SHA1, password).withSalt(salt).withIterationCount(itCount));
                keySize = 20;
            }
            return deriver.deriveKey(PasswordBasedDeriver.KeyType.MAC, keySize);
        }

        private Set getUsedCertificateSet() {
            String alias;
            HashSet<Certificate> usedSet = new HashSet<Certificate>();
            Enumeration en = this.keys.keys();
            while (en.hasMoreElements()) {
                alias = (String)en.nextElement();
                Certificate[] certs = this.engineGetCertificateChain(alias);
                for (int i = 0; i != certs.length; ++i) {
                    usedSet.add(certs[i]);
                }
            }
            en = this.certs.keys();
            while (en.hasMoreElements()) {
                alias = (String)en.nextElement();
                Certificate cert = this.engineGetCertificate(alias);
                usedSet.add(cert);
            }
            return usedSet;
        }

        private static class CertId {
            byte[] id;

            CertId(PublicKey key) throws IOException {
                this.id = PKCS12KeyStoreSpi.createSubjectKeyId(key).getKeyIdentifier();
            }

            CertId(byte[] id) {
                this.id = id;
            }

            public int hashCode() {
                return Arrays.hashCode(this.id);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CertId)) {
                    return false;
                }
                CertId cId = (CertId)o;
                return Arrays.areEqual(this.id, cId.id);
            }
        }

        private static class IgnoresCaseHashtable {
            private Hashtable orig = new Hashtable();
            private Hashtable keys = new Hashtable();

            private IgnoresCaseHashtable() {
            }

            public void put(String key, Object value) {
                String lower = Strings.toLowerCase(key);
                String k = (String)this.keys.get(lower);
                if (k != null) {
                    this.orig.remove(k);
                }
                this.keys.put(lower, key);
                this.orig.put(key, value);
            }

            public Enumeration keys() {
                return this.orig.keys();
            }

            public Object remove(String alias) {
                if (alias == null) {
                    return null;
                }
                String k = (String)this.keys.remove(Strings.toLowerCase(alias));
                if (k == null) {
                    return null;
                }
                return this.orig.remove(k);
            }

            public Object get(String alias) {
                if (alias == null) {
                    return null;
                }
                String k = (String)this.keys.get(Strings.toLowerCase(alias));
                if (k == null) {
                    return null;
                }
                return this.orig.get(k);
            }

            public Enumeration elements() {
                return this.orig.elements();
            }

            public void clear() {
                this.orig.clear();
            }
        }
    }
}

