/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.asymmetric.AsymmetricLMSPublicKey;
import org.bouncycastle.jcajce.interfaces.LMSPublicKey;

class ProvLMSPublicKey
implements LMSPublicKey {
    private static final long serialVersionUID = 1L;
    private transient AsymmetricLMSPublicKey baseKey;

    ProvLMSPublicKey(SubjectPublicKeyInfo keyInfo) throws IOException {
        this.baseKey = new AsymmetricLMSPublicKey(keyInfo);
    }

    ProvLMSPublicKey(AsymmetricLMSPublicKey baseKey) {
        this.baseKey = baseKey;
    }

    @Override
    public final String getAlgorithm() {
        return "LMS";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProvLMSPublicKey) {
            ProvLMSPublicKey otherKey = (ProvLMSPublicKey)o;
            return this.baseKey.equals(otherKey.baseKey);
        }
        return false;
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    @Override
    public int getLevels() {
        return this.baseKey.getL();
    }

    AsymmetricLMSPublicKey getBaseKey() {
        return this.baseKey;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.baseKey = new AsymmetricLMSPublicKey(enc);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

