/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.bc.EncryptedObjectStoreData;
import org.bouncycastle.asn1.bc.EncryptedPrivateKeyData;
import org.bouncycastle.asn1.bc.EncryptedSecretKeyData;
import org.bouncycastle.asn1.bc.ObjectData;
import org.bouncycastle.asn1.bc.ObjectDataSequence;
import org.bouncycastle.asn1.bc.ObjectStore;
import org.bouncycastle.asn1.bc.ObjectStoreData;
import org.bouncycastle.asn1.bc.ObjectStoreIntegrityCheck;
import org.bouncycastle.asn1.bc.PbkdMacIntegrityCheck;
import org.bouncycastle.asn1.bc.SecretKeyData;
import org.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.asn1.misc.ScryptParams;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.nsri.NSRIObjectIdentifiers;
import org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.CipherOutputStream;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InvalidWrappingException;
import org.bouncycastle.crypto.KDFCalculator;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.PasswordConverter;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.fips.FipsAES;
import org.bouncycastle.crypto.fips.FipsKeyUnwrapper;
import org.bouncycastle.crypto.fips.FipsKeyWrapper;
import org.bouncycastle.crypto.fips.FipsOutputAEADDecryptor;
import org.bouncycastle.crypto.fips.FipsOutputAEADEncryptor;
import org.bouncycastle.crypto.fips.FipsPBKD;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.Scrypt;
import org.bouncycastle.crypto.util.PBKDF2Config;
import org.bouncycastle.crypto.util.PBKDFConfig;
import org.bouncycastle.crypto.util.ScryptConfig;
import org.bouncycastle.internal.asn1.cms.CCMParameters;
import org.bouncycastle.jcajce.BCFKSLoadStoreParameter;
import org.bouncycastle.jcajce.BCLoadStoreParameter;
import org.bouncycastle.jcajce.ConsistentKeyPair;
import org.bouncycastle.jcajce.provider.AlgorithmProvider;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.JcaJceKeyHelper;
import org.bouncycastle.jcajce.provider.ProvIOException;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.provider.X509CertificateObject;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

class ProvBCFKS
extends AlgorithmProvider {
    private static final Map<String, ASN1ObjectIdentifier> oidMap = new HashMap<String, ASN1ObjectIdentifier>();
    private static final Map<ASN1ObjectIdentifier, String> publicAlgMap = new HashMap<ASN1ObjectIdentifier, String>();
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.keystore.bcfks.";

    ProvBCFKS() {
    }

    private static String getPublicKeyAlg(ASN1ObjectIdentifier oid) {
        String algName = publicAlgMap.get(oid);
        if (algName != null) {
            return algName;
        }
        return oid.getId();
    }

    @Override
    public void configure(final BouncyCastleFipsProvider provider) {
        provider.addAlgorithmImplementation("KeyStore.BCFKS", "org.bouncycastle.jcajce.provider.keystore.bcfks.BCFKSKeyStore", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BCFIPSKeyStoreSpi(true, provider);
            }
        });
        provider.addAlgorithmImplementation("KeyStore.IBCFKS", "org.bouncycastle.jcajce.provider.keystore.bcfks.IBCFKSKeyStore", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BCFIPSImmutableKeyStoreSpi(provider);
            }
        });
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            provider.addAlgorithmImplementation("KeyStore.BCFKS-DEF", "org.bouncycastle.jcajce.provider.keystore.bcfks.BCSFKSDefKeyStore", new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object constructorParameter) {
                    return new BCFIPSKeyStoreSpi(false, null);
                }
            }));
            provider.addAlgorithmImplementation("KeyStore.IBCFKS-DEF", "org.bouncycastle.jcajce.provider.keystore.bcfks.IBCFKSDefKeyStore", new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object constructorParameter) {
                    return new BCFIPSImmutableKeyStoreSpi(null);
                }
            }));
        }
    }

    static {
        oidMap.put("DESEDE", OIWObjectIdentifiers.desEDE);
        oidMap.put("TRIPLEDES", OIWObjectIdentifiers.desEDE);
        oidMap.put("TDEA", OIWObjectIdentifiers.desEDE);
        oidMap.put("HMACSHA1", PKCSObjectIdentifiers.id_hmacWithSHA1);
        oidMap.put("HMACSHA224", PKCSObjectIdentifiers.id_hmacWithSHA224);
        oidMap.put("HMACSHA256", PKCSObjectIdentifiers.id_hmacWithSHA256);
        oidMap.put("HMACSHA384", PKCSObjectIdentifiers.id_hmacWithSHA384);
        oidMap.put("HMACSHA512", PKCSObjectIdentifiers.id_hmacWithSHA512);
        oidMap.put("SEED", KISAObjectIdentifiers.id_seedCBC);
        oidMap.put("CAMELLIA.128", NTTObjectIdentifiers.id_camellia128_cbc);
        oidMap.put("CAMELLIA.192", NTTObjectIdentifiers.id_camellia192_cbc);
        oidMap.put("CAMELLIA.256", NTTObjectIdentifiers.id_camellia256_cbc);
        oidMap.put("ARIA.128", NSRIObjectIdentifiers.id_aria128_cbc);
        oidMap.put("ARIA.192", NSRIObjectIdentifiers.id_aria192_cbc);
        oidMap.put("ARIA.256", NSRIObjectIdentifiers.id_aria256_cbc);
        publicAlgMap.put(PKCSObjectIdentifiers.rsaEncryption, "RSA");
        publicAlgMap.put(X9ObjectIdentifiers.id_ecPublicKey, "EC");
        publicAlgMap.put(OIWObjectIdentifiers.elGamalAlgorithm, "DH");
        publicAlgMap.put(PKCSObjectIdentifiers.dhKeyAgreement, "DH");
        publicAlgMap.put(X9ObjectIdentifiers.id_dsa, "DSA");
    }

    static class BCFIPSImmutableKeyStoreSpi
    extends BCFIPSKeyStoreSpi
    implements PKCSObjectIdentifiers,
    X509ObjectIdentifiers {
        private final Map<String, byte[]> cache;
        private final byte[] seedKey;
        private boolean isLoaded;

        public BCFIPSImmutableKeyStoreSpi(BouncyCastleFipsProvider provider) {
            super(false, provider);
            try {
                this.seedKey = new byte[32];
                if (provider != null) {
                    SecureRandom.getInstance("DEFAULT", provider).nextBytes(this.seedKey);
                } else {
                    SecureRandom.getInstance("DEFAULT").nextBytes(this.seedKey);
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("can't create cert factory - " + e.toString());
            }
            this.cache = new HashMap<String, byte[]>();
        }

        @Override
        public void engineDeleteEntry(String alias) throws KeyStoreException {
            throw new KeyStoreException("delete operation not supported in immutable mode");
        }

        @Override
        public void engineSetKeyEntry(String alias, Key key, char[] password, java.security.cert.Certificate[] chain) throws KeyStoreException {
            throw new KeyStoreException("set operation not supported in immutable mode");
        }

        @Override
        public void engineSetKeyEntry(String alias, byte[] keyEncoding, java.security.cert.Certificate[] chain) throws KeyStoreException {
            throw new KeyStoreException("set operation not supported in immutable mode");
        }

        @Override
        public void engineSetCertificateEntry(String alias, java.security.cert.Certificate cert) throws KeyStoreException {
            throw new KeyStoreException("set operation not supported in immutable mode");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void engineLoad(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
            BCFIPSImmutableKeyStoreSpi bCFIPSImmutableKeyStoreSpi = this;
            synchronized (bCFIPSImmutableKeyStoreSpi) {
                if (this.isLoaded) {
                    throw new IOException("immutable keystore already loaded");
                }
                this.isLoaded = true;
            }
            super.engineLoad(loadStoreParameter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void engineLoad(InputStream inputStream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
            BCFIPSImmutableKeyStoreSpi bCFIPSImmutableKeyStoreSpi = this;
            synchronized (bCFIPSImmutableKeyStoreSpi) {
                if (this.isLoaded) {
                    throw new IOException("immutable keystore already loaded");
                }
                this.isLoaded = true;
            }
            super.engineLoad(inputStream, password);
        }

        @Override
        public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
            byte[] hash;
            byte[] mac = this.calculateMac(alias, password);
            if (this.cache.containsKey(alias) && !Arrays.constantTimeAreEqual(hash = this.cache.get(alias), mac)) {
                throw new UnrecoverableKeyException("unable to recover key (" + alias + ")");
            }
            Key key = super.engineGetKey(alias, password);
            if (key != null && !this.cache.containsKey(alias)) {
                this.cache.put(alias, mac);
            }
            return key;
        }

        private byte[] calculateMac(String alias, char[] password) {
            byte[] encoding = password != null ? Arrays.concatenate(Strings.toUTF8ByteArray(password), Strings.toUTF8ByteArray(alias)) : Arrays.concatenate(this.seedKey, Strings.toUTF8ByteArray(alias));
            byte[] rv = new byte[32];
            new Scrypt.KDFFactory().createKDFCalculator(Scrypt.ALGORITHM.using(this.seedKey, 16384, 8, 1, encoding)).generateBytes(rv);
            return rv;
        }
    }

    static class BCFIPSKeyStoreSpi
    extends KeyStoreSpi {
        private static final BigInteger CERTIFICATE = BigInteger.valueOf(0L);
        private static final BigInteger PRIVATE_KEY = BigInteger.valueOf(1L);
        private static final BigInteger SECRET_KEY = BigInteger.valueOf(2L);
        private static final BigInteger PROTECTED_PRIVATE_KEY = BigInteger.valueOf(3L);
        private static final BigInteger PROTECTED_SECRET_KEY = BigInteger.valueOf(4L);
        private final boolean matchOnProbe;
        private final BouncyCastleFipsProvider fipsProvider;
        private final Map<String, ObjectData> entries = new HashMap<String, ObjectData>();
        private final Map<String, PrivateKey> privateKeyCache = new HashMap<String, PrivateKey>();
        private AlgorithmIdentifier hmacAlgorithm;
        private KeyDerivationFunc hmacPkbdAlgorithm;
        private Date creationDate;
        private Date lastModifiedDate;
        private ASN1ObjectIdentifier storeEncryptionAlgorithm = NISTObjectIdentifiers.id_aes256_CCM;

        BCFIPSKeyStoreSpi(boolean matchOnProbe, BouncyCastleFipsProvider fipsProvider) {
            this.matchOnProbe = matchOnProbe;
            this.fipsProvider = fipsProvider;
        }

        @Override
        public boolean engineProbe(InputStream stream) throws IOException {
            if (!this.matchOnProbe) {
                return false;
            }
            BufferedInputStream storeStream = stream instanceof BufferedInputStream ? (BufferedInputStream)stream : new BufferedInputStream(stream);
            storeStream.mark(10);
            int hdr = storeStream.read();
            if (hdr != 48) {
                return false;
            }
            storeStream.reset();
            ASN1InputStream asn1Stream = new ASN1InputStream(storeStream);
            try {
                ObjectStore.getInstance(asn1Stream.readObject());
            }
            catch (Exception e) {
                return false;
            }
            return asn1Stream.available() == 0;
        }

        @Override
        public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
            ObjectData ent = this.entries.get(alias);
            if (ent != null) {
                if (ent.getType().equals(PRIVATE_KEY) || ent.getType().equals(PROTECTED_PRIVATE_KEY)) {
                    PrivateKey cachedKey = this.privateKeyCache.get(alias);
                    if (cachedKey != null) {
                        return cachedKey;
                    }
                    EncryptedPrivateKeyData encPrivData = EncryptedPrivateKeyData.getInstance(ent.getData());
                    EncryptedPrivateKeyInfo encInfo = EncryptedPrivateKeyInfo.getInstance(encPrivData.getEncryptedPrivateKeyInfo());
                    try {
                        PrivateKeyInfo pInfo = PrivateKeyInfo.getInstance(this.decryptData("PRIVATE_KEY_ENCRYPTION", encInfo.getEncryptionAlgorithm(), password, encInfo.getEncryptedData()));
                        KeyFactory kFact = this.fipsProvider != null ? KeyFactory.getInstance(pInfo.getPrivateKeyAlgorithm().getAlgorithm().getId(), this.fipsProvider) : KeyFactory.getInstance(ProvBCFKS.getPublicKeyAlg(pInfo.getPrivateKeyAlgorithm().getAlgorithm()));
                        PrivateKey privateKey = kFact.generatePrivate(new PKCS8EncodedKeySpec(pInfo.getEncoded()));
                        new ConsistentKeyPair(this.engineGetCertificate(alias).getPublicKey(), privateKey);
                        this.privateKeyCache.put(alias, privateKey);
                        return privateKey;
                    }
                    catch (Exception e) {
                        throw new UnrecoverableKeyException("BCFKS KeyStore unable to recover private key (" + alias + "): " + e.getMessage());
                    }
                }
                if (ent.getType().equals(SECRET_KEY) || ent.getType().equals(PROTECTED_SECRET_KEY)) {
                    EncryptedSecretKeyData encKeyData = EncryptedSecretKeyData.getInstance(ent.getData());
                    try {
                        SecretKeyData keyData = SecretKeyData.getInstance(this.decryptData("SECRET_KEY_ENCRYPTION", encKeyData.getKeyEncryptionAlgorithm(), password, encKeyData.getEncryptedKeyData()));
                        SecretKeyFactory kFact = this.fipsProvider != null ? SecretKeyFactory.getInstance(keyData.getKeyAlgorithm().getId(), this.fipsProvider) : SecretKeyFactory.getInstance(keyData.getKeyAlgorithm().getId());
                        return kFact.generateSecret(new SecretKeySpec(keyData.getKeyBytes(), keyData.getKeyAlgorithm().getId()));
                    }
                    catch (Exception e) {
                        throw new UnrecoverableKeyException("BCFKS KeyStore unable to recover secret key (" + alias + "): " + e.getMessage());
                    }
                }
                throw new UnrecoverableKeyException("BCFKS KeyStore unable to recover secret key (" + alias + "): type not recognized");
            }
            return null;
        }

        @Override
        public java.security.cert.Certificate[] engineGetCertificateChain(String alias) {
            ObjectData ent = this.entries.get(alias);
            if (ent != null && (ent.getType().equals(PRIVATE_KEY) || ent.getType().equals(PROTECTED_PRIVATE_KEY))) {
                EncryptedPrivateKeyData encPrivData = EncryptedPrivateKeyData.getInstance(ent.getData());
                Certificate[] certificates = encPrivData.getCertificateChain();
                java.security.cert.Certificate[] chain = new X509Certificate[certificates.length];
                for (int i = 0; i != chain.length; ++i) {
                    chain[i] = this.decodeCertificate(certificates[i]);
                }
                return chain;
            }
            return null;
        }

        @Override
        public java.security.cert.Certificate engineGetCertificate(String s) {
            ObjectData ent = this.entries.get(s);
            if (ent != null) {
                if (ent.getType().equals(PRIVATE_KEY) || ent.getType().equals(PROTECTED_PRIVATE_KEY)) {
                    EncryptedPrivateKeyData encPrivData = EncryptedPrivateKeyData.getInstance(ent.getData());
                    Certificate[] certificates = encPrivData.getCertificateChain();
                    return this.decodeCertificate(certificates[0]);
                }
                if (ent.getType().equals(CERTIFICATE)) {
                    return this.decodeCertificate(ent.getData());
                }
            }
            return null;
        }

        private java.security.cert.Certificate decodeCertificate(Object cert) {
            try {
                if (this.fipsProvider != null) {
                    return new X509CertificateObject(new JcaJceKeyHelper(this.fipsProvider), Certificate.getInstance(cert));
                }
                try {
                    CertificateFactory certFact = CertificateFactory.getInstance("X.509");
                    return certFact.generateCertificate(new ByteArrayInputStream(Certificate.getInstance(cert).getEncoded()));
                }
                catch (Exception e) {
                    return new X509CertificateObject(null, Certificate.getInstance(cert));
                }
            }
            catch (CertificateParsingException e) {
                return null;
            }
        }

        @Override
        public Date engineGetCreationDate(String s) {
            ObjectData ent = this.entries.get(s);
            if (ent != null) {
                try {
                    return ent.getLastModifiedDate().getDate();
                }
                catch (ParseException e) {
                    return new Date();
                }
            }
            return null;
        }

        @Override
        public void engineSetKeyEntry(String alias, Key key, char[] password, java.security.cert.Certificate[] chain) throws KeyStoreException {
            Date creationDate;
            Date lastEditDate = creationDate = new Date();
            ObjectData entry = this.entries.get(alias);
            if (entry != null) {
                creationDate = this.extractCreationDate(entry, creationDate);
            }
            this.privateKeyCache.remove(alias);
            if (key instanceof PrivateKey) {
                if (chain == null) {
                    throw new KeyStoreException("BCFKS KeyStore requires a certificate chain for private key storage.");
                }
                try {
                    EncryptedPrivateKeyInfo keyInfo;
                    Object opFact;
                    new ConsistentKeyPair(chain[0].getPublicKey(), (PrivateKey)key);
                    byte[] encodedKey = key.getEncoded();
                    KeyDerivationFunc pbkdAlgId = this.generatePkbdAlgorithmIdentifier(32);
                    byte[] keyBytes = this.generateKey(pbkdAlgId, "PRIVATE_KEY_ENCRYPTION", password != null ? password : new char[]{}, 32);
                    if (this.storeEncryptionAlgorithm.equals(NISTObjectIdentifiers.id_aes256_CCM)) {
                        opFact = new FipsAES.AEADOperatorFactory();
                        FipsAES.AuthParameters aeadParams = FipsAES.CCM.withIV(this.getDefaultSecureRandom());
                        FipsOutputAEADEncryptor<FipsAES.AuthParameters> encryptor = ((FipsAES.AEADOperatorFactory)opFact).createOutputAEADEncryptor((SymmetricKey)new SymmetricSecretKey(FipsAES.CCM, keyBytes), aeadParams);
                        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                        CipherOutputStream encOut = encryptor.getEncryptingStream(bOut);
                        encOut.write(encodedKey);
                        ((OutputStream)encOut).close();
                        PBES2Parameters pbeParams = new PBES2Parameters(pbkdAlgId, new EncryptionScheme(NISTObjectIdentifiers.id_aes256_CCM, new CCMParameters(aeadParams.getIV(), aeadParams.getMACSizeInBits() / 8)));
                        keyInfo = new EncryptedPrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, pbeParams), bOut.toByteArray());
                    } else {
                        opFact = new FipsAES.KeyWrapOperatorFactory();
                        FipsAES.WrapParameters wrapParams = FipsAES.KWP;
                        FipsKeyWrapper<FipsAES.WrapParameters> wrapper = ((FipsAES.KeyWrapOperatorFactory)opFact).createKeyWrapper(new SymmetricSecretKey(FipsAES.KWP, keyBytes), wrapParams);
                        PBES2Parameters pbeParams = new PBES2Parameters(pbkdAlgId, new EncryptionScheme(NISTObjectIdentifiers.id_aes256_wrap_pad));
                        keyInfo = new EncryptedPrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, pbeParams), wrapper.wrap(encodedKey, 0, encodedKey.length));
                    }
                    EncryptedPrivateKeyData keySeq = this.createPrivateKeySequence(keyInfo, chain);
                    this.entries.put(alias, new ObjectData(PRIVATE_KEY, alias, creationDate, lastEditDate, keySeq.getEncoded(), null));
                }
                catch (Exception e) {
                    throw new KeyStoreException("BCFKS KeyStore exception storing private key: " + e.toString(), e);
                }
            } else if (key instanceof SecretKey) {
                if (chain != null) {
                    throw new KeyStoreException("BCFKS KeyStore cannot store certificate chain with secret key.");
                }
                try {
                    EncryptedSecretKeyData keyData;
                    SecretKeyData secKeyData;
                    byte[] encodedKey = key.getEncoded();
                    String keyAlg = Strings.toUpperCase(key.getAlgorithm());
                    if (keyAlg.indexOf("AES") > -1) {
                        secKeyData = new SecretKeyData(NISTObjectIdentifiers.aes, encodedKey);
                    } else {
                        ASN1ObjectIdentifier algOid = (ASN1ObjectIdentifier)oidMap.get(keyAlg);
                        if (algOid != null) {
                            secKeyData = new SecretKeyData(algOid, encodedKey);
                        } else {
                            algOid = (ASN1ObjectIdentifier)oidMap.get(keyAlg + "." + encodedKey.length * 8);
                            if (algOid != null) {
                                secKeyData = new SecretKeyData(algOid, encodedKey);
                            } else {
                                throw new KeyStoreException("BCFKS KeyStore cannot recognize secret key (" + keyAlg + ") for storage.");
                            }
                        }
                    }
                    KeyDerivationFunc pbkdAlgId = this.generatePkbdAlgorithmIdentifier(32);
                    byte[] keyBytes = this.generateKey(pbkdAlgId, "SECRET_KEY_ENCRYPTION", password != null ? password : new char[]{}, 32);
                    if (this.storeEncryptionAlgorithm.equals(NISTObjectIdentifiers.id_aes256_CCM)) {
                        FipsAES.AEADOperatorFactory opFact = new FipsAES.AEADOperatorFactory();
                        FipsAES.AuthParameters aeadParams = FipsAES.CCM.withIV(this.getDefaultSecureRandom());
                        FipsOutputAEADEncryptor<FipsAES.AuthParameters> encryptor = opFact.createOutputAEADEncryptor((SymmetricKey)new SymmetricSecretKey(FipsAES.CCM, keyBytes), aeadParams);
                        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                        CipherOutputStream encOut = encryptor.getEncryptingStream(bOut);
                        encOut.write(secKeyData.getEncoded());
                        ((OutputStream)encOut).close();
                        PBES2Parameters pbeParams = new PBES2Parameters(pbkdAlgId, new EncryptionScheme(NISTObjectIdentifiers.id_aes256_CCM, new CCMParameters(aeadParams.getIV(), aeadParams.getMACSizeInBits() / 8)));
                        keyData = new EncryptedSecretKeyData(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, pbeParams), bOut.toByteArray());
                    } else {
                        FipsAES.KeyWrapOperatorFactory opFact = new FipsAES.KeyWrapOperatorFactory();
                        FipsAES.WrapParameters wrapParams = FipsAES.KWP;
                        FipsKeyWrapper<FipsAES.WrapParameters> wrapper = opFact.createKeyWrapper(new SymmetricSecretKey(FipsAES.KWP, keyBytes), wrapParams);
                        PBES2Parameters pbeParams = new PBES2Parameters(pbkdAlgId, new EncryptionScheme(NISTObjectIdentifiers.id_aes256_wrap_pad));
                        keyData = new EncryptedSecretKeyData(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, pbeParams), wrapper.wrap(encodedKey, 0, encodedKey.length));
                    }
                    this.entries.put(alias, new ObjectData(SECRET_KEY, alias, creationDate, lastEditDate, keyData.getEncoded(), null));
                }
                catch (Exception e) {
                    throw new KeyStoreException("BCFKS KeyStore exception storing private key: " + e.toString(), e);
                }
            } else {
                throw new KeyStoreException("BCFKS KeyStore unable to recognize key.");
            }
            this.lastModifiedDate = lastEditDate;
        }

        private SecureRandom getDefaultSecureRandom() {
            if (this.fipsProvider != null) {
                return this.fipsProvider.getDefaultSecureRandom();
            }
            return new SecureRandom();
        }

        private EncryptedPrivateKeyData createPrivateKeySequence(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, java.security.cert.Certificate[] chain) throws CertificateEncodingException {
            Certificate[] certChain = new Certificate[chain.length];
            for (int i = 0; i != chain.length; ++i) {
                certChain[i] = Certificate.getInstance(chain[i].getEncoded());
            }
            return new EncryptedPrivateKeyData(encryptedPrivateKeyInfo, certChain);
        }

        @Override
        public void engineSetKeyEntry(String alias, byte[] keyBytes, java.security.cert.Certificate[] chain) throws KeyStoreException {
            Date creationDate;
            Date lastEditDate = creationDate = new Date();
            ObjectData entry = this.entries.get(alias);
            if (entry != null) {
                creationDate = this.extractCreationDate(entry, creationDate);
            }
            if (chain != null) {
                EncryptedPrivateKeyInfo encInfo;
                try {
                    encInfo = EncryptedPrivateKeyInfo.getInstance(keyBytes);
                }
                catch (Exception e) {
                    throw new KeyStoreException("BCFKS KeyStore private key encoding must be an EncryptedPrivateKeyInfo.", e);
                }
                try {
                    this.privateKeyCache.remove(alias);
                    this.entries.put(alias, new ObjectData(PROTECTED_PRIVATE_KEY, alias, creationDate, lastEditDate, this.createPrivateKeySequence(encInfo, chain).getEncoded(), null));
                }
                catch (Exception e) {
                    throw new KeyStoreException("BCFKS KeyStore exception storing protected private key: " + e.toString(), e);
                }
            }
            try {
                this.entries.put(alias, new ObjectData(PROTECTED_SECRET_KEY, alias, creationDate, lastEditDate, keyBytes, null));
            }
            catch (Exception e) {
                throw new KeyStoreException("BCFKS KeyStore exception storing protected private key: " + e.toString(), e);
            }
            this.lastModifiedDate = lastEditDate;
        }

        @Override
        public void engineSetCertificateEntry(String alias, java.security.cert.Certificate certificate) throws KeyStoreException {
            Date creationDate;
            ObjectData entry = this.entries.get(alias);
            Date lastEditDate = creationDate = new Date();
            if (entry != null) {
                if (!entry.getType().equals(CERTIFICATE)) {
                    throw new KeyStoreException("BCFKS KeyStore already has a key entry with alias " + alias);
                }
                creationDate = this.extractCreationDate(entry, creationDate);
            }
            try {
                this.entries.put(alias, new ObjectData(CERTIFICATE, alias, creationDate, lastEditDate, certificate.getEncoded(), null));
            }
            catch (CertificateEncodingException e) {
                throw new KeyStoreException("BCFKS KeyStore unable to handle certificate: " + e.getMessage(), e);
            }
            this.lastModifiedDate = lastEditDate;
        }

        private Date extractCreationDate(ObjectData entry, Date creationDate) {
            try {
                creationDate = entry.getCreationDate().getDate();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return creationDate;
        }

        @Override
        public void engineDeleteEntry(String alias) throws KeyStoreException {
            ObjectData entry = this.entries.get(alias);
            if (entry == null) {
                return;
            }
            this.privateKeyCache.remove(alias);
            this.entries.remove(alias);
            this.lastModifiedDate = new Date();
        }

        @Override
        public Enumeration<String> engineAliases() {
            final Iterator<String> it = new HashSet<String>(this.entries.keySet()).iterator();
            return new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return it.hasNext();
                }

                @Override
                public String nextElement() {
                    return (String)it.next();
                }
            };
        }

        @Override
        public boolean engineContainsAlias(String alias) {
            if (alias == null) {
                throw new NullPointerException("alias value is null");
            }
            return this.entries.containsKey(alias);
        }

        @Override
        public int engineSize() {
            return this.entries.size();
        }

        @Override
        public boolean engineIsKeyEntry(String alias) {
            ObjectData ent = this.entries.get(alias);
            if (ent != null) {
                BigInteger entryType = ent.getType();
                return entryType.equals(PRIVATE_KEY) || entryType.equals(SECRET_KEY) || entryType.equals(PROTECTED_PRIVATE_KEY) || entryType.equals(PROTECTED_SECRET_KEY);
            }
            return false;
        }

        @Override
        public boolean engineIsCertificateEntry(String alias) {
            ObjectData ent = this.entries.get(alias);
            if (ent != null) {
                return ent.getType().equals(CERTIFICATE);
            }
            return false;
        }

        @Override
        public String engineGetCertificateAlias(java.security.cert.Certificate certificate) {
            byte[] encodedCert;
            if (certificate == null) {
                return null;
            }
            try {
                encodedCert = certificate.getEncoded();
            }
            catch (CertificateEncodingException e) {
                return null;
            }
            for (Map.Entry<String, ObjectData> entry : this.entries.entrySet()) {
                ObjectData ent = entry.getValue();
                if (ent.getType().equals(CERTIFICATE)) {
                    if (!Arrays.areEqual(ent.getData(), encodedCert)) continue;
                    return entry.getKey();
                }
                if (!ent.getType().equals(PRIVATE_KEY) && !ent.getType().equals(PROTECTED_PRIVATE_KEY)) continue;
                try {
                    EncryptedPrivateKeyData encPrivData = EncryptedPrivateKeyData.getInstance(ent.getData());
                    if (!Arrays.areEqual(encPrivData.getCertificateChain()[0].toASN1Primitive().getEncoded(), encodedCert)) continue;
                    return entry.getKey();
                }
                catch (IOException iOException) {
                }
            }
            return null;
        }

        private KeyDerivationFunc generatePkbdAlgorithmIdentifier(PBKDFConfig pbkdfConfig, int keySizeInBytes) {
            if (MiscObjectIdentifiers.id_scrypt.equals(pbkdfConfig.getAlgorithm())) {
                ScryptConfig scryptConfig = (ScryptConfig)pbkdfConfig;
                byte[] pbkdSalt = new byte[scryptConfig.getSaltLength()];
                this.getDefaultSecureRandom().nextBytes(pbkdSalt);
                ScryptParams params = new ScryptParams(pbkdSalt, scryptConfig.getCostParameter(), scryptConfig.getBlockSize(), scryptConfig.getParallelizationParameter(), keySizeInBytes);
                return new KeyDerivationFunc(MiscObjectIdentifiers.id_scrypt, params);
            }
            PBKDF2Config pbkdf2Config = (PBKDF2Config)pbkdfConfig;
            byte[] pbkdSalt = new byte[pbkdf2Config.getSaltLength()];
            this.getDefaultSecureRandom().nextBytes(pbkdSalt);
            return new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, new PBKDF2Params(pbkdSalt, pbkdf2Config.getIterationCount(), keySizeInBytes, pbkdf2Config.getPRF()));
        }

        private KeyDerivationFunc generatePkbdAlgorithmIdentifier(KeyDerivationFunc baseAlg, int keySizeInBytes) {
            if (MiscObjectIdentifiers.id_scrypt.equals(baseAlg.getAlgorithm())) {
                ScryptParams oldParams = ScryptParams.getInstance(baseAlg.getParameters());
                byte[] pbkdSalt = new byte[oldParams.getSalt().length];
                this.getDefaultSecureRandom().nextBytes(pbkdSalt);
                ScryptParams params = new ScryptParams(pbkdSalt, oldParams.getCostParameter(), oldParams.getBlockSize(), oldParams.getParallelizationParameter(), BigInteger.valueOf(keySizeInBytes));
                return new KeyDerivationFunc(MiscObjectIdentifiers.id_scrypt, params);
            }
            PBKDF2Params oldParams = PBKDF2Params.getInstance(baseAlg.getParameters());
            byte[] pbkdSalt = new byte[oldParams.getSalt().length];
            this.getDefaultSecureRandom().nextBytes(pbkdSalt);
            PBKDF2Params params = new PBKDF2Params(pbkdSalt, oldParams.getIterationCount().intValue(), keySizeInBytes, oldParams.getPrf());
            return new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, params);
        }

        private byte[] generateKey(KeyDerivationFunc pbkdAlgorithm, String purpose, char[] password, int defKeySize) throws IOException {
            byte[] encPassword = PasswordConverter.PKCS12.convert(password);
            byte[] differentiator = PasswordConverter.PKCS12.convert(purpose.toCharArray());
            int keySizeInBytes = defKeySize;
            if (MiscObjectIdentifiers.id_scrypt.equals(pbkdAlgorithm.getAlgorithm())) {
                ScryptParams params = ScryptParams.getInstance(pbkdAlgorithm.getParameters());
                if (params.getKeyLength() != null) {
                    keySizeInBytes = params.getKeyLength().intValue();
                } else if (keySizeInBytes == -1) {
                    throw new IOException("no keyLength found in ScryptParams");
                }
                Scrypt.KDFFactory scryptFact = new Scrypt.KDFFactory();
                byte[] seed = Arrays.concatenate(encPassword, differentiator);
                KDFCalculator<Scrypt.Parameters> calculator = scryptFact.createKDFCalculator(Scrypt.ALGORITHM.using(params.getSalt(), params.getCostParameter().intValue(), params.getBlockSize().intValue(), params.getBlockSize().intValue(), seed));
                byte[] rv = new byte[keySizeInBytes];
                calculator.generateBytes(rv);
                Arrays.clear(seed);
                Arrays.clear(encPassword);
                return rv;
            }
            if (pbkdAlgorithm.getAlgorithm().equals(PKCSObjectIdentifiers.id_PBKDF2)) {
                FipsPBKD.Parameters parameters;
                PBKDF2Params pbkdf2Params = PBKDF2Params.getInstance(pbkdAlgorithm.getParameters());
                if (pbkdf2Params.getKeyLength() != null) {
                    keySizeInBytes = pbkdf2Params.getKeyLength().intValue();
                } else if (keySizeInBytes == -1) {
                    throw new IOException("no keyLength found in PBKDF2Params");
                }
                FipsPBKD.DeriverFactory pbeFact = new FipsPBKD.DeriverFactory();
                if (pbkdf2Params.getPrf().getAlgorithm().equals(PKCSObjectIdentifiers.id_hmacWithSHA512)) {
                    parameters = FipsPBKD.PBKDF2.using(FipsSHS.Algorithm.SHA512_HMAC, Arrays.concatenate(encPassword, differentiator)).withIterationCount(pbkdf2Params.getIterationCount().intValue()).withSalt(pbkdf2Params.getSalt());
                } else if (pbkdf2Params.getPrf().getAlgorithm().equals(NISTObjectIdentifiers.id_hmacWithSHA3_512)) {
                    parameters = FipsPBKD.PBKDF2.using(FipsSHS.Algorithm.SHA3_512_HMAC, Arrays.concatenate(encPassword, differentiator)).withIterationCount(pbkdf2Params.getIterationCount().intValue()).withSalt(pbkdf2Params.getSalt());
                } else {
                    throw new IOException("BCFKS KeyStore: unrecognized MAC PBKD PRF: " + pbkdf2Params.getPrf().getAlgorithm());
                }
                PasswordBasedDeriver<FipsPBKD.Parameters> deriver = pbeFact.createDeriver(parameters);
                return deriver.deriveKey(PasswordBasedDeriver.KeyType.CIPHER, keySizeInBytes);
            }
            throw new IOException("BCFKS KeyStore: unrecognized MAC PBKD.");
        }

        private void verifyMac(byte[] content, PbkdMacIntegrityCheck integrityCheck, char[] password) throws NoSuchAlgorithmException, IOException {
            byte[] check = this.calculateMac(content, integrityCheck.getMacAlgorithm(), integrityCheck.getPbkdAlgorithm(), password);
            if (!Arrays.constantTimeAreEqual(check, integrityCheck.getMac())) {
                throw new IOException("BCFKS KeyStore corrupted: MAC calculation failed.");
            }
        }

        private byte[] calculateMac(byte[] content, AlgorithmIdentifier algorithm, KeyDerivationFunc pbkdAlgorithm, char[] password) throws NoSuchAlgorithmException, IOException {
            String algorithmId = algorithm.getAlgorithm().getId();
            Mac mac = this.fipsProvider != null ? Mac.getInstance(algorithmId, this.fipsProvider) : Mac.getInstance(algorithmId);
            try {
                mac.init(new SecretKeySpec(this.generateKey(pbkdAlgorithm, "INTEGRITY_CHECK", password != null ? password : new char[]{}, -1), algorithmId));
            }
            catch (InvalidKeyException e) {
                throw new ProvIOException("Cannot set up MAC calculation: " + e.getMessage(), e);
            }
            return mac.doFinal(content);
        }

        @Override
        public void engineLoad(KeyStore.LoadStoreParameter parameter) throws CertificateException, NoSuchAlgorithmException, IOException {
            if (parameter == null) {
                this.engineLoad(null, null);
            } else if (parameter instanceof BCFKSLoadStoreParameter) {
                BCFKSLoadStoreParameter bcParam = (BCFKSLoadStoreParameter)parameter;
                char[] password = Utils.extractPassword(bcParam);
                this.hmacPkbdAlgorithm = this.generatePkbdAlgorithmIdentifier(bcParam.getStorePBKDFConfig(), 64);
                this.storeEncryptionAlgorithm = bcParam.getStoreEncryptionAlgorithm() == BCFKSLoadStoreParameter.EncryptionAlgorithm.AES256_CCM ? NISTObjectIdentifiers.id_aes256_CCM : NISTObjectIdentifiers.id_aes256_wrap_pad;
                this.hmacAlgorithm = bcParam.getStoreMacAlgorithm() == BCFKSLoadStoreParameter.MacAlgorithm.HmacSHA512 ? new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA512, DERNull.INSTANCE) : new AlgorithmIdentifier(NISTObjectIdentifiers.id_hmacWithSHA3_512, DERNull.INSTANCE);
                AlgorithmIdentifier presetHmacAlgorithm = this.hmacAlgorithm;
                ASN1ObjectIdentifier presetStoreEncryptionAlgorithm = this.storeEncryptionAlgorithm;
                InputStream inputStream = bcParam.getInputStream();
                this.engineLoad(inputStream, password);
                if (!(inputStream == null || presetHmacAlgorithm.equals(this.hmacAlgorithm) && this.isSimilarHmacPbkd(bcParam.getStorePBKDFConfig(), this.hmacPkbdAlgorithm) && presetStoreEncryptionAlgorithm.equals(this.storeEncryptionAlgorithm))) {
                    throw new IOException("configuration parameters do not match existing store");
                }
            } else if (parameter instanceof BCLoadStoreParameter) {
                BCLoadStoreParameter bcParam = (BCLoadStoreParameter)parameter;
                this.engineLoad(bcParam.getInputStream(), Utils.extractPassword(parameter));
            } else {
                throw new IllegalArgumentException("no support for 'param' of type " + parameter.getClass().getName());
            }
        }

        private boolean isSimilarHmacPbkd(PBKDFConfig storePBKDFConfig, KeyDerivationFunc hmacPkbdAlgorithm) {
            if (!storePBKDFConfig.getAlgorithm().equals(hmacPkbdAlgorithm.getAlgorithm())) {
                return false;
            }
            if (MiscObjectIdentifiers.id_scrypt.equals(hmacPkbdAlgorithm.getAlgorithm())) {
                if (!(storePBKDFConfig instanceof ScryptConfig)) {
                    return false;
                }
                ScryptConfig scryptConfig = (ScryptConfig)storePBKDFConfig;
                ScryptParams sParams = ScryptParams.getInstance(hmacPkbdAlgorithm.getParameters());
                if (scryptConfig.getSaltLength() != sParams.getSalt().length || scryptConfig.getBlockSize() != sParams.getBlockSize().intValue() || scryptConfig.getCostParameter() != sParams.getCostParameter().intValue() || scryptConfig.getParallelizationParameter() != sParams.getParallelizationParameter().intValue()) {
                    return false;
                }
            } else {
                if (!(storePBKDFConfig instanceof PBKDF2Config)) {
                    return false;
                }
                PBKDF2Config pbkdf2Config = (PBKDF2Config)storePBKDFConfig;
                PBKDF2Params pbkdf2Params = PBKDF2Params.getInstance(hmacPkbdAlgorithm.getParameters());
                if (pbkdf2Config.getSaltLength() != pbkdf2Params.getSalt().length || pbkdf2Config.getIterationCount() != pbkdf2Params.getIterationCount().intValue()) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void engineStore(KeyStore.LoadStoreParameter parameter) throws CertificateException, NoSuchAlgorithmException, IOException {
            if (parameter == null) {
                throw new IllegalArgumentException("'param' arg cannot be null");
            }
            if (parameter instanceof BCFKSLoadStoreParameter) {
                BCFKSLoadStoreParameter bcParam = (BCFKSLoadStoreParameter)parameter;
                char[] password = Utils.extractPassword(bcParam);
                this.hmacPkbdAlgorithm = this.generatePkbdAlgorithmIdentifier(bcParam.getStorePBKDFConfig(), 64);
                this.storeEncryptionAlgorithm = bcParam.getStoreEncryptionAlgorithm() == BCFKSLoadStoreParameter.EncryptionAlgorithm.AES256_CCM ? NISTObjectIdentifiers.id_aes256_CCM : NISTObjectIdentifiers.id_aes256_wrap_pad;
                this.hmacAlgorithm = bcParam.getStoreMacAlgorithm() == BCFKSLoadStoreParameter.MacAlgorithm.HmacSHA512 ? new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA512, DERNull.INSTANCE) : new AlgorithmIdentifier(NISTObjectIdentifiers.id_hmacWithSHA3_512, DERNull.INSTANCE);
                this.engineStore(bcParam.getOutputStream(), password);
            } else if (parameter instanceof BCLoadStoreParameter) {
                BCLoadStoreParameter bcParam = (BCLoadStoreParameter)parameter;
                this.engineStore(bcParam.getOutputStream(), Utils.extractPassword(parameter));
            } else {
                throw new IllegalArgumentException("no support for 'param' of type " + parameter.getClass().getName());
            }
        }

        @Override
        public void engineStore(OutputStream outputStream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
            EncryptedObjectStoreData encStoreData;
            Object opFact;
            if (this.creationDate == null) {
                throw new IOException("KeyStore not initialized");
            }
            ObjectData[] dataArray = this.entries.values().toArray(new ObjectData[this.entries.size()]);
            KeyDerivationFunc pbkdAlgId = this.generatePkbdAlgorithmIdentifier(this.hmacPkbdAlgorithm, 32);
            byte[] keyBytes = this.generateKey(pbkdAlgId, "STORE_ENCRYPTION", password != null ? password : new char[]{}, 32);
            ObjectStoreData storeData = new ObjectStoreData(this.hmacAlgorithm, this.creationDate, this.lastModifiedDate, new ObjectDataSequence(dataArray), null);
            if (this.storeEncryptionAlgorithm.equals(NISTObjectIdentifiers.id_aes256_CCM)) {
                opFact = new FipsAES.AEADOperatorFactory();
                FipsAES.AuthParameters aeadParams = FipsAES.CCM.withIV(this.getDefaultSecureRandom());
                FipsOutputAEADEncryptor<FipsAES.AuthParameters> encryptor = ((FipsAES.AEADOperatorFactory)opFact).createOutputAEADEncryptor((SymmetricKey)new SymmetricSecretKey(FipsAES.CCM, keyBytes), aeadParams);
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                CipherOutputStream encOut = encryptor.getEncryptingStream(bOut);
                encOut.write(storeData.getEncoded());
                ((OutputStream)encOut).close();
                PBES2Parameters pbeParams = new PBES2Parameters(pbkdAlgId, new EncryptionScheme(NISTObjectIdentifiers.id_aes256_CCM, new CCMParameters(aeadParams.getIV(), aeadParams.getMACSizeInBits() / 8)));
                encStoreData = new EncryptedObjectStoreData(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, pbeParams), bOut.toByteArray());
            } else {
                opFact = new FipsAES.KeyWrapOperatorFactory();
                FipsAES.WrapParameters wrapParams = FipsAES.KWP;
                FipsKeyWrapper<FipsAES.WrapParameters> wrapper = ((FipsAES.KeyWrapOperatorFactory)opFact).createKeyWrapper(new SymmetricSecretKey(FipsAES.KWP, keyBytes), wrapParams);
                PBES2Parameters pbeParams = new PBES2Parameters(pbkdAlgId, new EncryptionScheme(NISTObjectIdentifiers.id_aes256_wrap_pad));
                byte[] data = storeData.getEncoded();
                encStoreData = new EncryptedObjectStoreData(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, pbeParams), wrapper.wrap(data, 0, data.length));
            }
            if (MiscObjectIdentifiers.id_scrypt.equals(this.hmacPkbdAlgorithm.getAlgorithm())) {
                ScryptParams sParams = ScryptParams.getInstance(this.hmacPkbdAlgorithm.getParameters());
                this.hmacPkbdAlgorithm = this.generatePkbdAlgorithmIdentifier(this.hmacPkbdAlgorithm, sParams.getKeyLength().intValue());
            } else {
                PBKDF2Params pbkdf2Params = PBKDF2Params.getInstance(this.hmacPkbdAlgorithm.getParameters());
                this.hmacPkbdAlgorithm = this.generatePkbdAlgorithmIdentifier(this.hmacPkbdAlgorithm, pbkdf2Params.getKeyLength().intValue());
            }
            byte[] mac = this.calculateMac(encStoreData.getEncoded(), this.hmacAlgorithm, this.hmacPkbdAlgorithm, password);
            ObjectStore store = new ObjectStore(encStoreData, new ObjectStoreIntegrityCheck(new PbkdMacIntegrityCheck(this.hmacAlgorithm, this.hmacPkbdAlgorithm, mac)));
            outputStream.write(store.getEncoded());
            outputStream.flush();
        }

        @Override
        public void engineLoad(InputStream inputStream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
            ObjectStoreData storeData;
            this.entries.clear();
            this.privateKeyCache.clear();
            this.creationDate = null;
            this.lastModifiedDate = null;
            if (inputStream == null) {
                this.lastModifiedDate = this.creationDate = new Date();
                this.hmacAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA512, DERNull.INSTANCE);
                this.hmacPkbdAlgorithm = this.generatePkbdAlgorithmIdentifier(64);
                return;
            }
            ASN1InputStream aIn = new ASN1InputStream(inputStream);
            ObjectStore store = ObjectStore.getInstance(aIn.readObject());
            if (store == null) {
                throw new EOFException("no data in keystore stream");
            }
            ObjectStoreIntegrityCheck integrityCheck = store.getIntegrityCheck();
            if (integrityCheck.getType() != 0) {
                throw new IOException("BCFKS KeyStore unable to recognize integrity check.");
            }
            PbkdMacIntegrityCheck pbkdMacIntegrityCheck = PbkdMacIntegrityCheck.getInstance(integrityCheck.getIntegrityCheck());
            this.hmacAlgorithm = pbkdMacIntegrityCheck.getMacAlgorithm();
            this.hmacPkbdAlgorithm = pbkdMacIntegrityCheck.getPbkdAlgorithm();
            this.verifyMac(store.getStoreData().toASN1Primitive().getEncoded(), pbkdMacIntegrityCheck, password);
            ASN1Encodable sData = store.getStoreData();
            if (sData instanceof EncryptedObjectStoreData) {
                EncryptedObjectStoreData encryptedStoreData = (EncryptedObjectStoreData)sData;
                AlgorithmIdentifier protectAlgId = encryptedStoreData.getEncryptionAlgorithm();
                storeData = ObjectStoreData.getInstance(this.decryptData("STORE_ENCRYPTION", protectAlgId, password, encryptedStoreData.getEncryptedContent().getOctets()));
            } else {
                storeData = ObjectStoreData.getInstance(sData);
            }
            try {
                this.creationDate = storeData.getCreationDate().getDate();
                this.lastModifiedDate = storeData.getLastModifiedDate().getDate();
            }
            catch (ParseException e) {
                throw new IOException("BCFKS KeyStore unable to parse store data information.");
            }
            if (!storeData.getIntegrityAlgorithm().equals(this.hmacAlgorithm)) {
                throw new IOException("BCFKS KeyStore storeData integrity algorithm does not match store integrity algorithm.");
            }
            Iterator<ASN1Encodable> it = storeData.getObjectDataSequence().iterator();
            while (it.hasNext()) {
                ObjectData objData = ObjectData.getInstance(it.next());
                this.entries.put(objData.getIdentifier(), objData);
            }
        }

        private byte[] decryptData(String purpose, AlgorithmIdentifier protectAlgId, char[] password, byte[] encryptedData) throws IOException {
            if (!protectAlgId.getAlgorithm().equals(PKCSObjectIdentifiers.id_PBES2)) {
                throw new IOException("BCFKS KeyStore cannot recognize protection algorithm.");
            }
            PBES2Parameters pbes2Parameters = PBES2Parameters.getInstance(protectAlgId.getParameters());
            EncryptionScheme algId = pbes2Parameters.getEncryptionScheme();
            if (algId.getAlgorithm().equals(NISTObjectIdentifiers.id_aes256_CCM)) {
                CCMParameters ccmParameters = CCMParameters.getInstance(algId.getParameters());
                FipsAES.AuthParameters aeadParams = FipsAES.CCM.withIV(ccmParameters.getNonce()).withMACSize(ccmParameters.getIcvLen() * 8);
                FipsAES.AEADOperatorFactory opFact = new FipsAES.AEADOperatorFactory();
                byte[] keyBytes = this.generateKey(pbes2Parameters.getKeyDerivationFunc(), purpose, password != null ? password : new char[]{}, 32);
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                FipsOutputAEADDecryptor<FipsAES.AuthParameters> decryptor = opFact.createOutputAEADDecryptor((SymmetricKey)new SymmetricSecretKey(FipsAES.CCM, keyBytes), aeadParams);
                CipherOutputStream dOut = decryptor.getDecryptingStream(bOut);
                dOut.write(encryptedData);
                ((OutputStream)dOut).close();
                return bOut.toByteArray();
            }
            if (algId.getAlgorithm().equals(NISTObjectIdentifiers.id_aes256_wrap_pad)) {
                FipsAES.WrapParameters kwpParams = FipsAES.KWP;
                FipsAES.KeyWrapOperatorFactory opFact = new FipsAES.KeyWrapOperatorFactory();
                byte[] keyBytes = this.generateKey(pbes2Parameters.getKeyDerivationFunc(), purpose, password != null ? password : new char[]{}, 32);
                FipsKeyUnwrapper<FipsAES.WrapParameters> decryptor = opFact.createKeyUnwrapper(new SymmetricSecretKey(FipsAES.KWP, keyBytes), kwpParams);
                try {
                    return decryptor.unwrap(encryptedData, 0, encryptedData.length);
                }
                catch (InvalidWrappingException e) {
                    throw new IOException(e.getMessage());
                }
            }
            throw new IOException("BCFKS KeyStore cannot recognize protection encryption algorithm.");
        }

        private KeyDerivationFunc generatePkbdAlgorithmIdentifier(int keySizeInBytes) {
            byte[] pbkdSalt = new byte[64];
            this.getDefaultSecureRandom().nextBytes(pbkdSalt);
            return new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, new PBKDF2Params(pbkdSalt, 16384, keySizeInBytes, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA512, DERNull.INSTANCE)));
        }
    }
}

