/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AuthenticationParameters;
import org.bouncycastle.crypto.MACOperatorFactory;
import org.bouncycastle.crypto.OutputMACCalculator;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.jcajce.provider.MacParametersCreator;
import org.bouncycastle.jcajce.provider.Utils;

class BaseMac
extends MacSpi {
    private final Algorithm algorithm;
    private final MACOperatorFactory factory;
    private final MacParametersCreator parametersCreator;
    private final int keySizeInBits;
    private OutputMACCalculator macCalculator;
    private UpdateOutputStream macStream;
    private AuthenticationParameters initParams;

    protected BaseMac(Algorithm algorithm, MACOperatorFactory factory, MacParametersCreator parametersCreator) {
        this(algorithm, factory, parametersCreator, 0);
    }

    protected BaseMac(Parameters parameters, MACOperatorFactory factory, MacParametersCreator parametersCreator) {
        this(parameters.getAlgorithm(), factory, parametersCreator, 0);
    }

    protected BaseMac(Parameters parameters, MACOperatorFactory factory, MacParametersCreator parametersCreator, int keySizeInBits) {
        this(parameters.getAlgorithm(), factory, parametersCreator, keySizeInBits);
    }

    protected BaseMac(Algorithm algorithm, MACOperatorFactory factory, MacParametersCreator parametersCreator, int keySizeInBits) {
        this.algorithm = algorithm;
        this.factory = factory;
        this.parametersCreator = parametersCreator;
        this.keySizeInBits = keySizeInBits;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        SymmetricKey symmetricKey = Utils.convertKey(this.algorithm, key);
        if (this.keySizeInBits != 0 && Utils.keyNotLength(symmetricKey, this.keySizeInBits)) {
            throw new InvalidKeyException("MAC requires key of size " + this.keySizeInBits + " bits");
        }
        try {
            this.initParams = this.parametersCreator.createParameters(false, params, null);
            this.macCalculator = this.factory.createOutputMACCalculator(symmetricKey, this.initParams);
            this.macStream = this.macCalculator.getMACStream();
        }
        catch (IllegalArgumentException e) {
            throw new InvalidAlgorithmParameterException(e.getMessage(), e.getCause());
        }
    }

    @Override
    protected int engineGetMacLength() {
        if (this.initParams == null) {
            return (this.parametersCreator.getBaseParameters().getMACSizeInBits() + 7) / 8;
        }
        return (this.initParams.getMACSizeInBits() + 7) / 8;
    }

    @Override
    protected void engineReset() {
        if (this.macCalculator != null) {
            this.macCalculator.reset();
        }
    }

    @Override
    protected void engineUpdate(byte input) {
        this.macStream.update(input);
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        this.macStream.update(input, offset, len);
    }

    @Override
    protected byte[] engineDoFinal() {
        return this.macCalculator.getMAC();
    }
}

