/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import org.bouncycastle.jcajce.provider.ProvIOException;

abstract class BaseAlgorithmParameters
extends AlgorithmParametersSpi {
    BaseAlgorithmParameters() {
    }

    protected boolean isASN1FormatString(String format) {
        return format == null || format.equals("ASN.1");
    }

    @Override
    protected final <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        if (paramSpec == null) {
            throw new NullPointerException("Argument to getParameterSpec must not be null");
        }
        return (T)this.localEngineGetParameterSpec(paramSpec);
    }

    @Override
    protected final void engineInit(byte[] encoding) throws IOException {
        this.engineInit(encoding, "ASN.1");
    }

    @Override
    protected final byte[] engineGetEncoded() throws IOException {
        return this.engineGetEncoded("ASN.1");
    }

    @Override
    protected byte[] engineGetEncoded(String format) throws IOException {
        if (this.isASN1FormatString(format)) {
            return this.localGetEncoded();
        }
        throw new IOException("Unknown parameter format: " + format);
    }

    @Override
    protected void engineInit(byte[] params, String format) throws IOException {
        if (params == null) {
            throw new NullPointerException("Encoded parameters cannot be null");
        }
        if (this.isASN1FormatString(format)) {
            try {
                this.localInit(params);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ProvIOException("Parameter parsing failed: " + e.getMessage(), e);
            }
        } else {
            throw new IOException("Unknown parameter format: " + format);
        }
    }

    protected abstract byte[] localGetEncoded() throws IOException;

    protected abstract void localInit(byte[] var1) throws IOException;

    protected abstract AlgorithmParameterSpec localEngineGetParameterSpec(Class var1) throws InvalidParameterSpecException;
}

