/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util;

import java.security.SecureRandom;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.EntropySourceProvider;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsEntropyConfig;
import org.bouncycastle.crypto.fips.FipsOutputXOFCalculator;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsSecureRandom;
import org.bouncycastle.crypto.general.GeneralSecureRandom;

public class BasicEntropySourceProvider
implements EntropySourceProvider {
    private final SecureRandom _sr;
    private final boolean _predictionResistant;

    public BasicEntropySourceProvider(SecureRandom random, boolean isPredictionResistant) {
        this._sr = random;
        this._predictionResistant = isPredictionResistant;
    }

    @Override
    public EntropySource get(final int bitsRequired) {
        return new EntropySource(){

            @Override
            public boolean isPredictionResistant() {
                return BasicEntropySourceProvider.this._predictionResistant;
            }

            @Override
            public byte[] getEntropy() {
                if (BasicEntropySourceProvider.this._sr instanceof FipsSecureRandom || BasicEntropySourceProvider.this._sr instanceof GeneralSecureRandom) {
                    byte[] rv = new byte[(bitsRequired + 7) / 8];
                    BasicEntropySourceProvider.this._sr.nextBytes(rv);
                    return rv;
                }
                if (FipsEntropyConfig.getH() != 8.0f) {
                    int neededBits = (int)((float)bitsRequired / FipsEntropyConfig.getH() + 1.0f);
                    byte[] noise = BasicEntropySourceProvider.this._sr.generateSeed((neededBits + 7) / 8);
                    FipsOutputXOFCalculator<FipsSHS.Parameters> shake256 = new FipsSHS.XOFOperatorFactory<FipsSHS.Parameters>().createOutputXOFCalculator(FipsSHS.SHAKE256);
                    UpdateOutputStream uOut = shake256.getFunctionStream();
                    uOut.update(noise);
                    uOut.finished();
                    return shake256.getFunctionOutput((bitsRequired + 7) / 8);
                }
                return BasicEntropySourceProvider.this._sr.generateSeed((bitsRequired + 7) / 8);
            }

            @Override
            public int entropySize() {
                return bitsRequired;
            }
        };
    }
}

