/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.wrappers;

import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.wrappers.SP80038FWrapper;
import org.bouncycastle.util.Arrays;

public final class SP80038FWrapEngine
extends SP80038FWrapper {
    public SP80038FWrapEngine(BlockCipher engine, boolean useReverseDirection) {
        super(engine, ivKW, useReverseDirection);
    }

    @Override
    public String getAlgorithmName() {
        return this.engine.getAlgorithmName() + "/KW";
    }

    @Override
    public byte[] wrap(byte[] in, int inOff, int inLen) {
        if (!this.forWrapping) {
            throw new IllegalStateException("not set for wrapping");
        }
        int n = inLen / this.delta;
        if (n * this.delta != inLen) {
            throw new DataLengthException("wrap data must be a multiple of " + this.delta + " bytes");
        }
        byte[] block = new byte[inLen + this.iv.length];
        System.arraycopy(this.iv, 0, block, 0, this.iv.length);
        System.arraycopy(in, inOff, block, this.iv.length, inLen);
        return this.W(n, block);
    }

    @Override
    public byte[] unwrap(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.forWrapping) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int n = inLen / this.delta;
        if (n * this.delta != inLen) {
            throw new InvalidCipherTextException("unwrap data must be a multiple of " + this.delta + " bytes");
        }
        byte[] block = new byte[inLen - this.iv.length];
        byte[] a = new byte[this.iv.length];
        System.arraycopy(in, inOff, a, 0, this.iv.length);
        System.arraycopy(in, inOff + this.iv.length, block, 0, inLen - this.iv.length);
        this.invW(n, block, a);
        if (!Arrays.constantTimeAreEqual(a, this.iv)) {
            throw new InvalidCipherTextException("checksum failed");
        }
        return block;
    }
}

