/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.pqc.lms;

import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.pqc.lms.LMOtsParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LMSContext;
import org.bouncycastle.crypto.internal.pqc.lms.LMSigParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LmsDigestUtil;
import org.bouncycastle.crypto.internal.pqc.lms.LmsUtils;
import org.bouncycastle.crypto.internal.pqc.lms.SeedDerive;

class LMOtsPrivateKey {
    private final LMOtsParameters parameter;
    private final byte[] I;
    private final int q;
    private final byte[] masterSecret;

    public LMOtsPrivateKey(LMOtsParameters parameter, byte[] i, int q, byte[] masterSecret) {
        this.parameter = parameter;
        this.I = i;
        this.q = q;
        this.masterSecret = masterSecret;
    }

    LMSContext getSignatureContext(LMSigParameters sigParams, byte[][] path) {
        byte[] C = new byte[32];
        SeedDerive derive = this.getDerivationFunction();
        derive.setJ(-3);
        derive.deriveSeed(C, false);
        Digest ctx = LmsDigestUtil.getDigest(this.parameter.getDigestOID());
        LmsUtils.byteArray(this.getI(), ctx);
        LmsUtils.u32str(this.getQ(), ctx);
        LmsUtils.u16str((short)-32383, ctx);
        LmsUtils.byteArray(C, ctx);
        return new LMSContext(this, sigParams, ctx, C, path);
    }

    SeedDerive getDerivationFunction() {
        SeedDerive derive = new SeedDerive(this.I, this.masterSecret, LmsDigestUtil.getDigest(this.parameter.getDigestOID()));
        derive.setQ(this.q);
        return derive;
    }

    public LMOtsParameters getParameter() {
        return this.parameter;
    }

    public byte[] getI() {
        return this.I;
    }

    public int getQ() {
        return this.q;
    }

    public byte[] getMasterSecret() {
        return this.masterSecret;
    }
}

