/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.PBEParametersGenerator;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;

class PKCS5S2ParametersGenerator<T extends Parameters>
extends PBEParametersGenerator<T> {
    private Mac hMac;
    private byte[] state;

    public PKCS5S2ParametersGenerator(T parameters, Mac hMac) {
        super(parameters);
        this.hMac = hMac;
        this.state = new byte[hMac.getMacSize()];
    }

    private void F(byte[] S, int c, byte[] iBuf, byte[] out, int outOff) {
        if (c == 0) {
            throw new IllegalArgumentException("iteration count must be at least 1.");
        }
        if (S != null) {
            this.hMac.update(S, 0, S.length);
        }
        this.hMac.update(iBuf, 0, iBuf.length);
        this.hMac.doFinal(this.state, 0);
        System.arraycopy(this.state, 0, out, outOff, this.state.length);
        for (int count = 1; count < c; ++count) {
            this.hMac.update(this.state, 0, this.state.length);
            this.hMac.doFinal(this.state, 0);
            for (int j = 0; j != this.state.length; ++j) {
                int n = outOff + j;
                out[n] = (byte)(out[n] ^ this.state[j]);
            }
        }
    }

    private byte[] generateDerivedKey(int dkLen) {
        int hLen = this.hMac.getMacSize();
        int l = (dkLen + hLen - 1) / hLen;
        byte[] iBuf = new byte[4];
        byte[] outBytes = new byte[l * hLen];
        int outPos = 0;
        KeyParameterImpl param = new KeyParameterImpl(this.password);
        this.hMac.init(param);
        for (int i = 1; i <= l; ++i) {
            int n;
            int pos = 3;
            do {
                n = pos--;
            } while ((iBuf[n] = (byte)(iBuf[n] + 1)) == 0);
            this.F(this.salt, this.iterationCount, iBuf, outBytes, outPos);
            outPos += hLen;
        }
        return outBytes;
    }

    @Override
    public CipherParameters generateDerivedParameters(int keySize) {
        byte[] material = this.deriveKey(PasswordBasedDeriver.KeyType.CIPHER, keySize /= 8);
        return new KeyParameterImpl(material);
    }

    @Override
    public CipherParameters generateDerivedParameters(int keySize, int ivSize) {
        byte[][] material = this.deriveKeyAndIV(PasswordBasedDeriver.KeyType.CIPHER, keySize /= 8, ivSize /= 8);
        return new ParametersWithIV(new KeyParameterImpl(material[0]), material[1], keySize, ivSize);
    }

    @Override
    public CipherParameters generateDerivedMacParameters(int keySize) {
        return this.generateDerivedParameters(keySize);
    }

    @Override
    public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int keySizeInBytes) {
        switch (keyType) {
            case CIPHER: 
            case MAC: {
                return Arrays.copyOfRange(this.generateDerivedKey(keySizeInBytes), 0, keySizeInBytes);
            }
        }
        throw new IllegalStateException("Unknown type in deriveKey: " + keyType.name());
    }

    @Override
    public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int keySizeInBytes, int ivSizeInBytes) {
        byte[][] rv = new byte[2][];
        byte[] dKey = this.generateDerivedKey(keySizeInBytes + ivSizeInBytes);
        switch (keyType) {
            case CIPHER: 
            case MAC: {
                rv[0] = Arrays.copyOfRange(dKey, 0, keySizeInBytes);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type in deriveKeyAndIV: " + keyType.name());
            }
        }
        rv[1] = Arrays.copyOfRange(dKey, keySizeInBytes, keySizeInBytes + ivSizeInBytes);
        return rv;
    }
}

