/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.crypto.AEADOperatorFactory;
import org.bouncycastle.crypto.CipherOutputStream;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InputAEADDecryptor;
import org.bouncycastle.crypto.OutputAEADDecryptor;
import org.bouncycastle.crypto.OutputAEADEncryptor;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.internal.io.CipherInputStream;
import org.bouncycastle.crypto.internal.io.CipherOutputStreamImpl;
import org.bouncycastle.crypto.internal.modes.AEADCipher;

abstract class GuardedAEADOperatorFactory<T extends Parameters>
implements AEADOperatorFactory<T> {
    GuardedAEADOperatorFactory() {
        FipsStatus.isReady();
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved only mode.");
        }
    }

    @Override
    public OutputAEADEncryptor<T> createOutputAEADEncryptor(SymmetricKey key, T parameters) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", parameters.getAlgorithm());
        }
        return new OutEncryptor(this, key, parameters);
    }

    @Override
    public InputAEADDecryptor<T> createInputAEADDecryptor(SymmetricKey key, T parameters) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", parameters.getAlgorithm());
        }
        AEADCipher cipher = this.createAEADCipher(false, key, parameters);
        return new InputAEADDecryptor<T>((Parameters)parameters, cipher){
            final /* synthetic */ Parameters val$parameters;
            final /* synthetic */ AEADCipher val$cipher;
            {
                this.val$parameters = parameters;
                this.val$cipher = aEADCipher;
            }

            @Override
            public T getParameters() {
                return this.val$parameters;
            }

            @Override
            public UpdateOutputStream getAADStream() {
                return new AADStream(this.val$cipher);
            }

            @Override
            public InputStream getDecryptingStream(InputStream in) {
                return new CipherInputStream(in, this.val$cipher);
            }

            @Override
            public byte[] getMAC() {
                return this.val$cipher.getMac();
            }
        };
    }

    @Override
    public OutputAEADDecryptor<T> createOutputAEADDecryptor(SymmetricKey key, T parameters) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", parameters.getAlgorithm());
        }
        AEADCipher cipher = this.createAEADCipher(false, key, parameters);
        return new OutputAEADDecryptor<T>((Parameters)parameters, cipher){
            final /* synthetic */ Parameters val$parameters;
            final /* synthetic */ AEADCipher val$cipher;
            {
                this.val$parameters = parameters;
                this.val$cipher = aEADCipher;
            }

            @Override
            public T getParameters() {
                return this.val$parameters;
            }

            @Override
            public int getMaxOutputSize(int inputLen) {
                return this.val$cipher.getOutputSize(inputLen);
            }

            @Override
            public int getUpdateOutputSize(int inputLen) {
                return this.val$cipher.getUpdateOutputSize(inputLen);
            }

            @Override
            public UpdateOutputStream getAADStream() {
                return new AADStream(this.val$cipher);
            }

            @Override
            public CipherOutputStream getDecryptingStream(OutputStream out) {
                return new CipherOutputStreamImpl(out, this.val$cipher);
            }

            @Override
            public byte[] getMAC() {
                return this.val$cipher.getMac();
            }
        };
    }

    protected abstract AEADCipher createAEADCipher(boolean var1, SymmetricKey var2, T var3);

    private class AADStream
    extends UpdateOutputStream {
        private AEADCipher cipher;

        AADStream(AEADCipher cipher) {
            this.cipher = cipher;
        }

        @Override
        public void write(byte[] buf, int off, int len) throws IOException {
            this.cipher.processAADBytes(buf, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.cipher.processAADByte((byte)b);
        }
    }

    private static class OutEncryptor
    implements OutputAEADEncryptor<T> {
        private final T parameters;
        private final AEADCipher cipher;
        final /* synthetic */ GuardedAEADOperatorFactory this$0;

        OutEncryptor(SymmetricKey key, T parameters) {
            this.this$0 = var1_1;
            this.parameters = parameters;
            this.cipher = var1_1.createAEADCipher(true, key, parameters);
        }

        @Override
        public T getParameters() {
            return this.parameters;
        }

        @Override
        public int getMaxOutputSize(int inputLen) {
            return this.cipher.getOutputSize(inputLen);
        }

        @Override
        public int getUpdateOutputSize(int inputLen) {
            return this.cipher.getUpdateOutputSize(inputLen);
        }

        @Override
        public UpdateOutputStream getAADStream() {
            return this.this$0.new AADStream(this.cipher);
        }

        @Override
        public CipherOutputStream getEncryptingStream(OutputStream out) {
            return new CipherOutputStreamImpl(out, this.cipher);
        }

        @Override
        public byte[] getMAC() {
            return this.cipher.getMac();
        }
    }
}

