/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.params.DsaKeyGenerationParameters;
import org.bouncycastle.crypto.internal.params.DsaParameters;
import org.bouncycastle.crypto.internal.params.DsaPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.DsaPublicKeyParameters;

class DsaKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(1L);
    private DsaKeyGenerationParameters param;

    DsaKeyPairGenerator() {
    }

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (DsaKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DsaParameters dsaParams = this.param.getParameters();
        BigInteger x = DsaKeyPairGenerator.generatePrivateKey(dsaParams.getQ(), this.param.getRandom());
        BigInteger y = DsaKeyPairGenerator.calculatePublicKey(dsaParams.getP(), dsaParams.getG(), x);
        return new AsymmetricCipherKeyPair(new DsaPublicKeyParameters(y, dsaParams), new DsaPrivateKeyParameters(x, dsaParams));
    }

    private static BigInteger generatePrivateKey(BigInteger q, SecureRandom random) {
        BigInteger qSubOne = q.subtract(ONE);
        if (q.bitLength() <= 160) {
            BigInteger c;
            while ((c = new BigInteger(q.bitLength(), random)).compareTo(ONE) < 0 || c.compareTo(qSubOne) > 0) {
            }
            return c;
        }
        BigInteger c = new BigInteger(q.bitLength() + 64, random);
        return c.mod(qSubOne).add(ONE);
    }

    private static BigInteger calculatePublicKey(BigInteger p, BigInteger g, BigInteger x) {
        return g.modPow(x, p);
    }
}

