/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.EntropySourceProvider;

class FixedEntropySourceProvider
implements EntropySourceProvider {
    private final byte[] data;
    private final boolean isPredictionResistant;

    protected FixedEntropySourceProvider(byte[] data, boolean isPredictionResistant) {
        this.data = data;
        this.isPredictionResistant = isPredictionResistant;
    }

    @Override
    public EntropySource get(final int bitsRequired) {
        return new EntropySource(){
            int index = 0;

            @Override
            public boolean isPredictionResistant() {
                return FixedEntropySourceProvider.this.isPredictionResistant;
            }

            @Override
            public byte[] getEntropy() {
                byte[] rv = new byte[(bitsRequired + 7) / 8];
                System.arraycopy(FixedEntropySourceProvider.this.data, this.index, rv, 0, rv.length);
                this.index += (bitsRequired + 7) / 8;
                return rv;
            }

            @Override
            public int entropySize() {
                return bitsRequired;
            }
        };
    }
}

