/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.bouncycastle.LICENSE;
import org.bouncycastle.crypto.fips.FipsOperationError;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.SHA256Digest;
import org.bouncycastle.crypto.internal.macs.HMac;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public final class FipsStatus {
    public static final String READY = "READY";
    private static final Object statusLock = new Object();
    private static final String[] classes = new String[]{FipsSHS.class.getName()};
    private static final AtomicBoolean readyStatus = new AtomicBoolean(false);
    private static volatile Loader loader;
    private static volatile Throwable statusException;

    private FipsStatus() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReady() {
        Object object = statusLock;
        synchronized (object) {
            if (loader == null && statusException == null) {
                try {
                    loader = new Loader();
                    loader.run();
                }
                catch (Exception e) {
                    statusException = e;
                    FipsStatus.moveToErrorStatus(new FipsOperationError("Module startup failed: " + e.getMessage(), e));
                }
                FipsStatus.checksumValidate();
                readyStatus.set(true);
            } else if (statusException != null) {
                throw new FipsOperationError("Module in error status: " + statusException.getMessage(), statusException);
            }
        }
        return readyStatus.get();
    }

    static boolean isBooting() {
        return !readyStatus.get();
    }

    private static void checksumValidate() {
        final String rscName = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return FipsStatus.getResourceName();
            }
        });
        if (rscName == null) {
            FipsStatus.moveToErrorStatus(new FipsOperationError("Module checksum failed: unable to find"));
        }
        if (rscName.startsWith("jrt:/")) {
            FipsStatus.moveToErrorStatus(new FipsOperationError("Module checksum failed: unable to calculate"));
        } else {
            JarFile jarFile = AccessController.doPrivileged(new PrivilegedAction<JarFile>(){

                @Override
                public JarFile run() {
                    try {
                        return new JarFile(rscName);
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
            });
            if (jarFile != null) {
                try {
                    int ch;
                    byte[] hmac = FipsStatus.calculateModuleHMAC(jarFile);
                    InputStream macIn = jarFile.getInputStream(jarFile.getEntry("META-INF/HMAC.SHA256"));
                    StringBuilder sb = new StringBuilder(hmac.length * 2);
                    while ((ch = macIn.read()) >= 0 && ch != 13 && ch != 10) {
                        sb.append((char)ch);
                    }
                    byte[] fileMac = Hex.decode(sb.toString().trim());
                    if (!Arrays.constantTimeAreEqual(hmac, fileMac)) {
                        FipsStatus.moveToErrorStatus((Object)((Object)new FipsOperationError("Module checksum failed: expected [" + sb.toString().trim() + "] got [" + Strings.fromByteArray(Hex.encode(hmac)))) + "]");
                    }
                }
                catch (Exception e) {
                    statusException = e;
                    FipsStatus.moveToErrorStatus(new FipsOperationError("Module checksum failed: " + e.getMessage(), e));
                }
            }
        }
    }

    public static String getStatusMessage() {
        try {
            FipsStatus.isReady();
        }
        catch (FipsOperationError fipsOperationError) {
            // empty catch block
        }
        if (statusException != null) {
            return statusException.getMessage();
        }
        return READY;
    }

    private static void loadClass(String className) {
        try {
            Class.forName(className);
        }
        catch (ExceptionInInitializerError e) {
            statusException = e.getCause() != null ? e.getCause() : e;
            throw e;
        }
        catch (ClassNotFoundException e) {
            statusException = e;
            throw new IllegalStateException("Unable to initialize module: " + e.getMessage(), e);
        }
    }

    public static byte[] getModuleHMAC() {
        try {
            String rscName = FipsStatus.getResourceName();
            return FipsStatus.calculateModuleHMAC(new JarFile(rscName));
        }
        catch (Exception e) {
            return new byte[32];
        }
    }

    private static byte[] calculateModuleHMAC(JarFile jarFile) {
        try {
            HMac hMac = new HMac(new SHA256Digest());
            hMac.init(new KeyParameterImpl(Strings.toByteArray("Legion of the Bouncy Castle Inc.")));
            TreeMap<String, Object> index = new TreeMap<String, Object>();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                Object object;
                JarEntry jarEntry = entries.nextElement();
                if (jarEntry.isDirectory() || jarEntry.getName().startsWith("META-INF/") && jarEntry.getName().indexOf("versions") < 0 || jarEntry.getName().indexOf("module-info.class") > 0 || (object = index.put(jarEntry.getName(), jarEntry)) == null) continue;
                IllegalStateException e = new IllegalStateException("Unable to initialize module: duplicate entry found in jar file");
                statusException = e;
                throw e;
            }
            byte[] buf = new byte[8192];
            for (Map.Entry entry : index.entrySet()) {
                int n;
                JarEntry jarEntry = (JarEntry)entry.getValue();
                InputStream is = jarFile.getInputStream(jarEntry);
                byte[] encName = Strings.toUTF8ByteArray(jarEntry.getName());
                hMac.update((byte)91);
                hMac.update(encName, 0, encName.length);
                hMac.update(Pack.longToBigEndian(jarEntry.getSize()), 0, 8);
                hMac.update((byte)93);
                while ((n = is.read(buf, 0, buf.length)) != -1) {
                    hMac.update(buf, 0, n);
                }
                is.close();
            }
            hMac.update((byte)91);
            byte[] encName = Strings.toUTF8ByteArray("END");
            hMac.update(encName, 0, encName.length);
            hMac.update((byte)93);
            byte[] byArray = new byte[hMac.getMacSize()];
            hMac.doFinal(byArray, 0);
            return byArray;
        }
        catch (Exception e) {
            return new byte[32];
        }
    }

    private static String getResourceName() {
        String result = null;
        String markerName = LICENSE.class.getCanonicalName().replace(".", "/").replace("LICENSE", "MARKER");
        String marker = FipsStatus.getMarker(LICENSE.class, markerName);
        if (marker != null) {
            if (marker.startsWith("jar:file:") && marker.contains("!/")) {
                try {
                    String jarFilename;
                    result = jarFilename = URLDecoder.decode(marker.substring("jar:file:".length(), marker.lastIndexOf("!/")), "UTF-8");
                }
                catch (IOException e) {
                    result = null;
                }
            } else if (marker.startsWith("file:") && marker.endsWith(".jar")) {
                try {
                    String jarFilename;
                    result = jarFilename = URLDecoder.decode(marker.substring("file:".length()), "UTF-8");
                }
                catch (IOException e) {
                    result = null;
                }
            } else {
                if (marker.startsWith("jrt:")) {
                    return marker;
                }
                if (marker.startsWith("file:")) {
                    return marker;
                }
            }
        }
        return result;
    }

    static void moveToErrorStatus(String error) {
        FipsStatus.moveToErrorStatus(new FipsOperationError(error));
    }

    static void moveToErrorStatus(FipsOperationError error) {
        statusException = error;
        throw (FipsOperationError)((Object)statusException);
    }

    public static boolean isErrorStatus() {
        return statusException != null;
    }

    static String getMarker(final Class sourceClass, final String markerName) {
        ClassLoader loader = sourceClass.getClassLoader();
        if (loader != null) {
            Object resource = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        CodeSource cs = sourceClass.getProtectionDomain().getCodeSource();
                        return cs.getLocation();
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            });
            if (resource != null) {
                return resource.toString();
            }
            return loader.getResource(markerName).toString();
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return ClassLoader.getSystemResource(markerName).toString();
            }
        });
    }

    static class Loader {
        Loader() {
        }

        void run() throws Exception {
            for (String cls : classes) {
                if (FipsStatus.isErrorStatus()) continue;
                FipsStatus.loadClass(cls);
            }
        }
    }
}

