/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import org.bouncycastle.util.Arrays;

public class DHValidationParameters {
    private int usageIndex;
    private byte[] seed;
    private int counter;

    public DHValidationParameters(byte[] seed) {
        this(seed, -1, -1);
    }

    public DHValidationParameters(byte[] seed, int counter) {
        this(seed, counter, -1);
    }

    public DHValidationParameters(byte[] seed, int counter, int usageIndex) {
        this.seed = Arrays.clone(seed);
        this.counter = counter;
        this.usageIndex = usageIndex;
    }

    public int getCounter() {
        return this.counter;
    }

    public byte[] getSeed() {
        return Arrays.clone(this.seed);
    }

    public int getUsageIndex() {
        return this.usageIndex;
    }

    public int hashCode() {
        int code = this.counter;
        code += 37 * Arrays.hashCode(this.seed);
        return code += 37 * this.usageIndex;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DHValidationParameters)) {
            return false;
        }
        DHValidationParameters other = (DHValidationParameters)o;
        if (other.counter != this.counter) {
            return false;
        }
        if (other.usageIndex != this.usageIndex) {
            return false;
        }
        return Arrays.areEqual(this.seed, other.seed);
    }
}

