/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.oiw.ElGamalParameter;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.DHParameter;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.DomainParameters;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.asymmetric.DHDomainParameters;
import org.bouncycastle.crypto.asymmetric.DHValidationParameters;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;

public abstract class AsymmetricDHKey
implements AsymmetricKey {
    private final boolean approvedModeOnly = CryptoServicesRegistrar.isInApprovedOnlyMode();
    protected Algorithm algorithm;
    protected DHDomainParameters domainParameters;

    AsymmetricDHKey(Algorithm algorithm, DHDomainParameters domainParameters) {
        this.algorithm = algorithm;
        this.domainParameters = domainParameters;
    }

    AsymmetricDHKey(Algorithm algorithm, AlgorithmIdentifier algorithmIdentifier) {
        this.algorithm = algorithm;
        this.domainParameters = AsymmetricDHKey.decodeDomainParameters(algorithmIdentifier);
    }

    private static DHDomainParameters decodeDomainParameters(AlgorithmIdentifier algorithmIdentifier) {
        ASN1ObjectIdentifier id = algorithmIdentifier.getAlgorithm();
        ASN1Encodable parameters = algorithmIdentifier.getParameters();
        if (parameters == null) {
            throw new NullPointerException("AlgorithmIdentifier parameters cannot be empty");
        }
        if (id.equals(OIWObjectIdentifiers.elGamalAlgorithm)) {
            ElGamalParameter elg = ElGamalParameter.getInstance(parameters);
            return new DHDomainParameters(elg.getP(), elg.getG());
        }
        if (id.equals(PKCSObjectIdentifiers.dhKeyAgreement) || KeyUtils.isDHPKCSParam(parameters)) {
            DHParameter params = DHParameter.getInstance(parameters);
            if (params.getL() != null) {
                return new DHDomainParameters(params.getP(), null, params.getG(), params.getL().intValue());
            }
            return new DHDomainParameters(params.getP(), params.getG());
        }
        if (id.equals(X9ObjectIdentifiers.dhpublicnumber)) {
            DomainParameters params = DomainParameters.getInstance(parameters);
            if (params.getValidationParams() != null) {
                return new DHDomainParameters(params.getP(), params.getQ(), params.getG(), params.getJ(), new DHValidationParameters(params.getValidationParams().getSeed(), params.getValidationParams().getPgenCounter().intValue()));
            }
            return new DHDomainParameters(params.getP(), params.getQ(), params.getG(), params.getJ(), null);
        }
        throw new IllegalArgumentException("Unknown algorithm type: " + id);
    }

    @Override
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public DHDomainParameters getDomainParameters() {
        return this.domainParameters;
    }

    protected final boolean isThreadCorrectMode() {
        return this.approvedModeOnly == CryptoServicesRegistrar.isInApprovedOnlyMode();
    }

    protected final void checkApprovedOnlyModeStatus() {
        if (!this.isThreadCorrectMode()) {
            throw new FipsUnapprovedOperationError("No access to key in current thread.");
        }
    }

    protected void zeroize() {
        this.algorithm = null;
        this.domainParameters = null;
    }
}

