/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.spec;

import java.security.PrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.jcajce.spec.KTSKeySpec;
import org.bouncycastle.util.Arrays;

public class KTSExtractKeySpec
extends KTSKeySpec {
    private final PrivateKey privateKey;
    private final byte[] encapsulation;

    private KTSExtractKeySpec(PrivateKey privateKey, byte[] encapsulation, String algorithmName, int keySize, String macAlgorithm, int macKeySizeInBits, AlgorithmParameterSpec parameterSpec, AlgorithmIdentifier kdfAlgorithm, byte[] otherInfo) {
        super(algorithmName, keySize, macAlgorithm, macKeySizeInBits, parameterSpec, kdfAlgorithm, otherInfo);
        this.privateKey = privateKey;
        this.encapsulation = encapsulation;
    }

    public byte[] getEncapsulation() {
        return Arrays.clone(this.encapsulation);
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public static final class Builder {
        private final PrivateKey privateKey;
        private final String algorithmName;
        private final int keySizeInBits;
        private final byte[] encapsulation;
        private final byte[] otherInfo;
        private String macAlgorithm;
        private int macKeySizeInBits;
        private AlgorithmParameterSpec parameterSpec;
        private AlgorithmIdentifier kdfAlgorithm;

        public Builder(PrivateKey privateKey, byte[] encapsulation, String algorithmName, int keySizeInBits) {
            this(privateKey, encapsulation, algorithmName, keySizeInBits, null);
        }

        public Builder(PrivateKey privateKey, byte[] encapsulation, String algorithmName, int keySizeInBits, byte[] otherInfo) {
            this.privateKey = privateKey;
            this.algorithmName = algorithmName;
            this.keySizeInBits = keySizeInBits;
            this.encapsulation = Arrays.clone(encapsulation);
            this.kdfAlgorithm = KTSKeySpec.createAlgId(KTSKeySpec.KDF3.withPRF(FipsKDF.AgreementKDFPRF.SHA256));
            this.otherInfo = KTSKeySpec.copyOtherInfo(otherInfo);
        }

        public Builder withKdfAlgorithm(FipsKDF.AgreementKDFParametersBuilder kdfAlgorithm) {
            this.kdfAlgorithm = KTSKeySpec.createAlgId(kdfAlgorithm);
            return this;
        }

        public Builder withKdfAlgorithm(AlgorithmIdentifier kdfAlgorithm) {
            this.kdfAlgorithm = kdfAlgorithm;
            return this;
        }

        public Builder withMac(String macAlgorithmName, int macKeySizeInBits) {
            this.macAlgorithm = macAlgorithmName;
            this.macKeySizeInBits = macKeySizeInBits;
            if (macAlgorithmName != null && macKeySizeInBits <= 0) {
                throw new IllegalArgumentException("macKeySizeInBits must be greater than zero");
            }
            return this;
        }

        public Builder withParameterSpec(AlgorithmParameterSpec parameterSpec) {
            this.parameterSpec = parameterSpec;
            return this;
        }

        public KTSExtractKeySpec build() {
            return new KTSExtractKeySpec(this.privateKey, this.encapsulation, this.algorithmName, this.keySizeInBits, this.macAlgorithm, this.macKeySizeInBits, this.parameterSpec, this.kdfAlgorithm, this.otherInfo);
        }
    }
}

