/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import javax.security.auth.Destroyable;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricGOST3410PrivateKey;
import org.bouncycastle.jcajce.interfaces.GOST3410PrivateKey;
import org.bouncycastle.jcajce.provider.GOST3410Util;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.ProvKey;
import org.bouncycastle.jcajce.spec.GOST3410DomainParameterSpec;
import org.bouncycastle.jcajce.spec.GOST3410ParameterSpec;
import org.bouncycastle.jcajce.spec.GOST3410PrivateKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvGOST3410PrivateKey
implements Destroyable,
GOST3410PrivateKey,
ProvKey<AsymmetricGOST3410PrivateKey> {
    private static final long serialVersionUID = 8581661527592305464L;
    private transient AsymmetricGOST3410PrivateKey baseKey;

    ProvGOST3410PrivateKey(Algorithm algorithm, GOST3410PrivateKey key) {
        this.baseKey = new AsymmetricGOST3410PrivateKey(algorithm, GOST3410Util.convertToParams(key.getParams()), key.getX());
    }

    ProvGOST3410PrivateKey(Algorithm algorithm, GOST3410PrivateKeySpec keySpec) {
        this.baseKey = new AsymmetricGOST3410PrivateKey(algorithm, GOST3410Util.convertToParams(keySpec.getParams()), keySpec.getX());
    }

    ProvGOST3410PrivateKey(AsymmetricGOST3410PrivateKey key) {
        this.baseKey = key;
    }

    @Override
    public BigInteger getX() {
        return this.baseKey.getX();
    }

    @Override
    public GOST3410ParameterSpec<GOST3410DomainParameterSpec> getParams() {
        return GOST3410Util.convertToSpec(this.baseKey.getParameters());
    }

    @Override
    public AsymmetricGOST3410PrivateKey getBaseKey() {
        KeyUtil.checkDestroyed(this);
        return this.baseKey;
    }

    @Override
    public String getAlgorithm() {
        KeyUtil.checkDestroyed(this);
        return "GOST3410";
    }

    @Override
    public String getFormat() {
        KeyUtil.checkDestroyed(this);
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public void destroy() {
        this.baseKey.destroy();
    }

    @Override
    public boolean isDestroyed() {
        return this.baseKey.isDestroyed();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProvGOST3410PrivateKey)) {
            return false;
        }
        ProvGOST3410PrivateKey other = (ProvGOST3410PrivateKey)o;
        return this.baseKey.equals(other.baseKey);
    }

    public String toString() {
        if (this.isDestroyed()) {
            return KeyUtil.destroyedPrivateKeyToString("GOST3410");
        }
        try {
            return KeyUtil.privateKeyToString("GOST3410", this.baseKey.getX(), this.baseKey.getParameters().getDomainParameters());
        }
        catch (Exception e) {
            return KeyUtil.restrictedToString("GOST3410");
        }
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Algorithm alg = (Algorithm)in.readObject();
        byte[] enc = (byte[])in.readObject();
        this.baseKey = new AsymmetricGOST3410PrivateKey(alg, enc);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.isDestroyed()) {
            throw new IOException("key has been destroyed");
        }
        out.defaultWriteObject();
        out.writeObject(this.baseKey.getAlgorithm());
        out.writeObject(this.getEncoded());
    }
}

