/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.jcajce.provider.ParametersCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IvParametersCreator<T extends ParametersWithIV>
implements ParametersCreator {
    private final ParametersWithIV baseParameters;

    IvParametersCreator(ParametersWithIV baseParameters) {
        this.baseParameters = baseParameters;
    }

    public Parameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (spec instanceof IvParameterSpec) {
            return this.baseParameters.withIV(((IvParameterSpec)spec).getIV());
        }
        if (forEncryption && this.baseParameters.getAlgorithm().requiresAlgorithmParameters()) {
            return this.baseParameters.withIV(random);
        }
        return this.baseParameters;
    }
}

