/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.jcajce.provider.BaseAlgorithmParameters;

class IvAlgorithmParameters
extends BaseAlgorithmParameters {
    private byte[] iv;

    IvAlgorithmParameters() {
    }

    protected byte[] localGetEncoded() throws IOException {
        return new DEROctetString(this.iv).getEncoded();
    }

    protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (paramSpec == IvParameterSpec.class || paramSpec == AlgorithmParameterSpec.class) {
            return new IvParameterSpec(this.iv);
        }
        throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + paramSpec.getName());
    }

    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof IvParameterSpec)) {
            throw new InvalidParameterSpecException("IvParameterSpec required to initialise a IV parameters algorithm parameters object");
        }
        this.iv = ((IvParameterSpec)paramSpec).getIV();
    }

    protected void localInit(byte[] params) throws IOException {
        try {
            ASN1OctetString oct = (ASN1OctetString)ASN1Primitive.fromByteArray(params);
            this.iv = oct.getOctets();
        }
        catch (Exception e) {
            throw new IOException("Exception decoding: " + e);
        }
    }

    protected String engineToString() {
        return "IV Parameters";
    }
}

