/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.PolicyQualifierInfo;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.isismtt.ISISMTTObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.PKIXCRLStore;
import org.bouncycastle.jcajce.PKIXCRLStoreSelector;
import org.bouncycastle.jcajce.PKIXCertStore;
import org.bouncycastle.jcajce.PKIXCertStoreSelector;
import org.bouncycastle.jcajce.PKIXExtendedParameters;
import org.bouncycastle.jcajce.provider.AnnotatedException;
import org.bouncycastle.jcajce.provider.CertStatus;
import org.bouncycastle.jcajce.provider.PKIXCRLUtil;
import org.bouncycastle.jcajce.provider.PKIXPolicyNode;
import org.bouncycastle.jcajce.provider.RFC3280CertPathUtilities;
import org.bouncycastle.jcajce.provider.X509CRLObject;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.StoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CertPathValidatorUtilities {
    protected static final PKIXCRLUtil CRL_UTIL = new PKIXCRLUtil();
    protected static final String ANY_POLICY = "2.5.29.32.0";
    protected static final String CRL_NUMBER = Extension.cRLNumber.getId();
    protected static final int KEY_CERT_SIGN = 5;
    protected static final int CRL_SIGN = 6;
    protected static final String[] crlReasons = new String[]{"unspecified", "keyCompromise", "cACompromise", "affiliationChanged", "superseded", "cessationOfOperation", "certificateHold", "unknown", "removeFromCRL", "privilegeWithdrawn", "aACompromise"};

    CertPathValidatorUtilities() {
    }

    protected static TrustAnchor findTrustAnchor(X509Certificate cert, Set trustAnchors) throws AnnotatedException {
        return CertPathValidatorUtilities.findTrustAnchor(cert, trustAnchors, null);
    }

    protected static TrustAnchor findTrustAnchor(X509Certificate cert, Set trustAnchors, String sigProvider) throws AnnotatedException {
        TrustAnchor trust = null;
        PublicKey trustPublicKey = null;
        Exception invalidKeyEx = null;
        X509CertSelector certSelectX509 = new X509CertSelector();
        X500Principal certIssuer = CertPathValidatorUtilities.getEncodedIssuerPrincipal(cert);
        try {
            certSelectX509.setSubject(certIssuer.getEncoded());
        }
        catch (IOException ex) {
            throw new AnnotatedException("Cannot set subject search criteria for trust anchor.", ex);
        }
        Iterator iter = trustAnchors.iterator();
        while (iter.hasNext() && trust == null) {
            block15: {
                trust = (TrustAnchor)iter.next();
                if (trust.getTrustedCert() != null) {
                    if (certSelectX509.match(trust.getTrustedCert())) {
                        trustPublicKey = trust.getTrustedCert().getPublicKey();
                    } else {
                        trust = null;
                    }
                } else if (trust.getCAName() != null && trust.getCAPublicKey() != null) {
                    try {
                        X500Principal caName = new X500Principal(trust.getCAName());
                        if (certIssuer.equals(caName)) {
                            trustPublicKey = trust.getCAPublicKey();
                            break block15;
                        }
                        trust = null;
                    }
                    catch (IllegalArgumentException ex) {
                        trust = null;
                    }
                } else {
                    trust = null;
                }
            }
            if (trustPublicKey == null) continue;
            try {
                CertPathValidatorUtilities.verifyX509Certificate(cert, trustPublicKey, sigProvider);
            }
            catch (Exception ex) {
                invalidKeyEx = ex;
                trust = null;
                trustPublicKey = null;
            }
        }
        if (trust == null && invalidKeyEx != null) {
            throw new AnnotatedException("TrustAnchor found but certificate validation failed.", invalidKeyEx);
        }
        return trust;
    }

    static List<PKIXCertStore> getAdditionalStoresFromAltNames(byte[] issuerAlternativeName, Map<GeneralName, PKIXCertStore> altNameCertStoreMap) throws CertificateParsingException {
        if (issuerAlternativeName != null) {
            GeneralNames issuerAltName = GeneralNames.getInstance(ASN1OctetString.getInstance(issuerAlternativeName).getOctets());
            GeneralName[] names = issuerAltName.getNames();
            ArrayList<PKIXCertStore> stores = new ArrayList<PKIXCertStore>();
            for (int i = 0; i != names.length; ++i) {
                GeneralName altName = names[i];
                PKIXCertStore altStore = altNameCertStoreMap.get(altName);
                if (altStore == null) continue;
                stores.add(altStore);
            }
            return stores;
        }
        return Collections.EMPTY_LIST;
    }

    protected static X500Principal getEncodedIssuerPrincipal(Object cert) {
        return ((X509Certificate)cert).getIssuerX500Principal();
    }

    protected static Date getValidDate(PKIXExtendedParameters paramsPKIX) {
        Date validDate = paramsPKIX.getDate();
        if (validDate == null) {
            validDate = new Date();
        }
        return validDate;
    }

    protected static X500Name getSubjectDN(X509Certificate cert) {
        return X500Name.getInstance(cert.getSubjectX500Principal().getEncoded());
    }

    protected static X500Principal getSubjectPrincipal(X509Certificate cert) {
        return cert.getSubjectX500Principal();
    }

    protected static boolean isSelfIssued(X509Certificate cert) {
        return cert.getSubjectDN().equals(cert.getIssuerDN());
    }

    protected static ASN1Primitive getExtensionValue(X509Extension ext, String oid) throws AnnotatedException {
        byte[] bytes = ext.getExtensionValue(oid);
        if (bytes == null) {
            return null;
        }
        return CertPathValidatorUtilities.getObject(oid, bytes);
    }

    private static ASN1Primitive getObject(String oid, byte[] ext) throws AnnotatedException {
        try {
            ASN1OctetString octs = ASN1OctetString.getInstance(ext);
            return ASN1Primitive.fromByteArray(octs.getOctets());
        }
        catch (Exception e) {
            throw new AnnotatedException("exception processing extension " + oid, e);
        }
    }

    protected static X500Principal getIssuerPrincipal(X509CRL crl) {
        return crl.getIssuerX500Principal();
    }

    protected static AlgorithmIdentifier getAlgorithmIdentifier(PublicKey key) throws CertPathValidatorException {
        try {
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance(key.getEncoded());
            return info.getAlgorithm();
        }
        catch (Exception e) {
            throw new CertPathValidatorException("Subject public key cannot be decoded.", e);
        }
    }

    protected static final Set getQualifierSet(ASN1Sequence qualifiers) throws CertPathValidatorException {
        HashSet<PolicyQualifierInfo> pq = new HashSet<PolicyQualifierInfo>();
        if (qualifiers == null) {
            return pq;
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        Enumeration e = qualifiers.getObjects();
        while (e.hasMoreElements()) {
            try {
                aOut.writeObject((ASN1Encodable)e.nextElement());
                pq.add(new PolicyQualifierInfo(bOut.toByteArray()));
            }
            catch (IOException ex) {
                throw new CertPathValidatorException("Policy qualifier info cannot be decoded.", ex);
            }
            bOut.reset();
        }
        return pq;
    }

    protected static PKIXPolicyNode removePolicyNode(PKIXPolicyNode validPolicyTree, List[] policyNodes, PKIXPolicyNode _node) {
        PKIXPolicyNode _parent = (PKIXPolicyNode)_node.getParent();
        if (validPolicyTree == null) {
            return null;
        }
        if (_parent == null) {
            for (int j = 0; j < policyNodes.length; ++j) {
                policyNodes[j] = new ArrayList();
            }
            return null;
        }
        _parent.removeChild(_node);
        CertPathValidatorUtilities.removePolicyNodeRecurse(policyNodes, _node);
        return validPolicyTree;
    }

    private static void removePolicyNodeRecurse(List[] policyNodes, PKIXPolicyNode _node) {
        policyNodes[_node.getDepth()].remove(_node);
        if (_node.hasChildren()) {
            Iterator _iter = _node.getChildren();
            while (_iter.hasNext()) {
                PKIXPolicyNode _child = (PKIXPolicyNode)_iter.next();
                CertPathValidatorUtilities.removePolicyNodeRecurse(policyNodes, _child);
            }
        }
    }

    protected static boolean processCertD1i(int index, List[] policyNodes, ASN1ObjectIdentifier pOid, Set pq) {
        List policyNodeVec = policyNodes[index - 1];
        for (int j = 0; j < policyNodeVec.size(); ++j) {
            PKIXPolicyNode node = (PKIXPolicyNode)policyNodeVec.get(j);
            Set expectedPolicies = node.getExpectedPolicies();
            if (!expectedPolicies.contains(pOid.getId())) continue;
            HashSet<String> childExpectedPolicies = new HashSet<String>();
            childExpectedPolicies.add(pOid.getId());
            PKIXPolicyNode child = new PKIXPolicyNode(new ArrayList(), index, childExpectedPolicies, node, pq, pOid.getId(), false);
            node.addChild(child);
            policyNodes[index].add(child);
            policyNodeVec.set(j, node);
            return true;
        }
        return false;
    }

    protected static void processCertD1ii(int index, List[] policyNodes, ASN1ObjectIdentifier _poid, Set _pq) {
        List policyNodeVec = policyNodes[index - 1];
        for (int j = 0; j < policyNodeVec.size(); ++j) {
            PKIXPolicyNode _node = (PKIXPolicyNode)policyNodeVec.get(j);
            if (!ANY_POLICY.equals(_node.getValidPolicy())) continue;
            HashSet<String> _childExpectedPolicies = new HashSet<String>();
            _childExpectedPolicies.add(_poid.getId());
            PKIXPolicyNode _child = new PKIXPolicyNode(new ArrayList(), index, _childExpectedPolicies, _node, _pq, _poid.getId(), false);
            _node.addChild(_child);
            policyNodes[index].add(_child);
            return;
        }
    }

    protected static boolean isAnyPolicy(Set policySet) {
        return policySet == null || policySet.contains(ANY_POLICY) || policySet.isEmpty();
    }

    protected static Collection findCertificates(PKIXCertStoreSelector certSelect, List certStores) throws AnnotatedException {
        LinkedHashSet<Object> certs = new LinkedHashSet<Object>();
        for (Object obj : certStores) {
            Object certStore;
            if (obj instanceof Store) {
                certStore = (Store)obj;
                try {
                    certs.addAll(certStore.getMatches(certSelect));
                    continue;
                }
                catch (StoreException e) {
                    throw new AnnotatedException("Problem while picking certificates from X.509 store.", e);
                }
            }
            certStore = (CertStore)obj;
            try {
                certs.addAll(PKIXCertStoreSelector.getCertificates(certSelect, (CertStore)certStore));
            }
            catch (CertStoreException e) {
                throw new AnnotatedException("Problem while picking certificates from certificate store.", e);
            }
        }
        return certs;
    }

    static List<PKIXCRLStore> getAdditionalStoresFromCRLDistributionPoint(CRLDistPoint crldp, Map<GeneralName, PKIXCRLStore> namedCRLStoreMap) throws AnnotatedException {
        if (crldp != null) {
            DistributionPoint[] dps = null;
            try {
                dps = crldp.getDistributionPoints();
            }
            catch (Exception e) {
                throw new AnnotatedException("Distribution points could not be read.", e);
            }
            ArrayList<PKIXCRLStore> stores = new ArrayList<PKIXCRLStore>();
            for (int i = 0; i < dps.length; ++i) {
                DistributionPointName dpn = dps[i].getDistributionPoint();
                if (dpn == null || dpn.getType() != 0) continue;
                GeneralName[] genNames = GeneralNames.getInstance(dpn.getName()).getNames();
                for (int j = 0; j < genNames.length; ++j) {
                    PKIXCRLStore store = namedCRLStoreMap.get(genNames[j]);
                    if (store == null) continue;
                    stores.add(store);
                }
            }
            return stores;
        }
        return Collections.EMPTY_LIST;
    }

    protected static void getCRLIssuersFromDistributionPoint(DistributionPoint dp, Collection issuerPrincipals, X509CRLSelector selector) throws AnnotatedException {
        Iterator it;
        ArrayList<X500Principal> issuers = new ArrayList<X500Principal>();
        if (dp.getCRLIssuer() != null) {
            GeneralName[] genNames = dp.getCRLIssuer().getNames();
            for (int j = 0; j < genNames.length; ++j) {
                if (genNames[j].getTagNo() != 4) continue;
                try {
                    issuers.add(new X500Principal(genNames[j].getName().toASN1Primitive().getEncoded()));
                    continue;
                }
                catch (IOException e) {
                    throw new AnnotatedException("CRL issuer information from distribution point cannot be decoded.", e);
                }
            }
        } else {
            if (dp.getDistributionPoint() == null) {
                throw new AnnotatedException("CRL issuer is omitted from distribution point but no distributionPoint field present.");
            }
            it = issuerPrincipals.iterator();
            while (it.hasNext()) {
                issuers.add((X500Principal)it.next());
            }
        }
        it = issuers.iterator();
        while (it.hasNext()) {
            try {
                selector.addIssuerName(((X500Principal)it.next()).getEncoded());
            }
            catch (IOException ex) {
                throw new AnnotatedException("Cannot decode CRL issuer information.", ex);
            }
        }
    }

    private static BigInteger getSerialNumber(Object cert) {
        return ((X509Certificate)cert).getSerialNumber();
    }

    protected static void getCertStatus(Date validDate, X509CRL crl, Object cert, CertStatus certStatus) throws AnnotatedException {
        boolean isIndirect;
        X509CRLEntry crl_entry = null;
        try {
            isIndirect = X509CRLObject.isIndirectCRL(crl);
        }
        catch (CRLException exception) {
            throw new AnnotatedException("Failed check for indirect CRL.", exception);
        }
        if (isIndirect) {
            crl_entry = crl.getRevokedCertificate(CertPathValidatorUtilities.getSerialNumber(cert));
            if (crl_entry == null) {
                return;
            }
            X500Principal certIssuer = crl_entry.getCertificateIssuer();
            if (certIssuer == null) {
                certIssuer = CertPathValidatorUtilities.getIssuerPrincipal(crl);
            }
            if (!CertPathValidatorUtilities.getEncodedIssuerPrincipal(cert).equals(certIssuer)) {
                return;
            }
        } else {
            if (!CertPathValidatorUtilities.getEncodedIssuerPrincipal(cert).equals(CertPathValidatorUtilities.getIssuerPrincipal(crl))) {
                return;
            }
            crl_entry = crl.getRevokedCertificate(CertPathValidatorUtilities.getSerialNumber(cert));
            if (crl_entry == null) {
                return;
            }
        }
        ASN1Enumerated reasonCode = null;
        if (crl_entry.hasExtensions()) {
            try {
                reasonCode = ASN1Enumerated.getInstance(CertPathValidatorUtilities.getExtensionValue(crl_entry, Extension.reasonCode.getId()));
            }
            catch (Exception e) {
                throw new AnnotatedException("Reason code CRL entry extension could not be decoded.", e);
            }
        }
        if (validDate.getTime() >= crl_entry.getRevocationDate().getTime() || reasonCode == null || reasonCode.getValue().intValue() == 0 || reasonCode.getValue().intValue() == 1 || reasonCode.getValue().intValue() == 2 || reasonCode.getValue().intValue() == 8) {
            if (reasonCode != null) {
                certStatus.setCertStatus(reasonCode.getValue().intValue());
            } else {
                certStatus.setCertStatus(0);
            }
            certStatus.setRevocationDate(crl_entry.getRevocationDate());
        }
    }

    protected static Set getDeltaCRLs(Date validityDate, X509CRL completeCRL, List<CertStore> certStores, List<PKIXCRLStore> pkixCrlStores) throws AnnotatedException {
        X509CRLSelector baseDeltaSelect = new X509CRLSelector();
        try {
            baseDeltaSelect.addIssuerName(CertPathValidatorUtilities.getIssuerPrincipal(completeCRL).getEncoded());
        }
        catch (IOException e) {
            throw new AnnotatedException("Cannot extract issuer from CRL.", e);
        }
        BigInteger completeCRLNumber = null;
        try {
            ASN1Primitive derObject = CertPathValidatorUtilities.getExtensionValue(completeCRL, CRL_NUMBER);
            if (derObject != null) {
                completeCRLNumber = ASN1Integer.getInstance(derObject).getPositiveValue();
            }
        }
        catch (Exception e) {
            throw new AnnotatedException("CRL number extension could not be extracted from CRL.", e);
        }
        byte[] idp = null;
        try {
            idp = completeCRL.getExtensionValue(RFC3280CertPathUtilities.ISSUING_DISTRIBUTION_POINT);
        }
        catch (Exception e) {
            throw new AnnotatedException("Issuing distribution point extension value could not be read.", e);
        }
        baseDeltaSelect.setMinCRLNumber(completeCRLNumber == null ? null : completeCRLNumber.add(BigInteger.valueOf(1L)));
        PKIXCRLStoreSelector.Builder selBuilder = new PKIXCRLStoreSelector.Builder(baseDeltaSelect);
        selBuilder.setIssuingDistributionPoint(idp);
        selBuilder.setIssuingDistributionPointEnabled(true);
        selBuilder.setMaxBaseCRLNumber(completeCRLNumber);
        PKIXCRLStoreSelector<? extends CRL> deltaSelect = selBuilder.build();
        Set temp = CRL_UTIL.findCRLs(deltaSelect, validityDate, certStores, pkixCrlStores);
        HashSet<X509CRL> result = new HashSet<X509CRL>();
        for (X509CRL crl : temp) {
            if (!CertPathValidatorUtilities.isDeltaCRL(crl)) continue;
            result.add(crl);
        }
        return result;
    }

    private static boolean isDeltaCRL(X509CRL crl) {
        Set<String> critical = crl.getCriticalExtensionOIDs();
        if (critical == null) {
            return false;
        }
        return critical.contains(RFC3280CertPathUtilities.DELTA_CRL_INDICATOR);
    }

    protected static Set getCompleteCRLs(DistributionPoint dp, Object cert, Date currentDate, PKIXExtendedParameters paramsPKIX) throws AnnotatedException {
        Set crls;
        X509CRLSelector baseCrlSelect = new X509CRLSelector();
        try {
            HashSet<X500Principal> issuers = new HashSet<X500Principal>();
            issuers.add(CertPathValidatorUtilities.getEncodedIssuerPrincipal(cert));
            CertPathValidatorUtilities.getCRLIssuersFromDistributionPoint(dp, issuers, baseCrlSelect);
        }
        catch (AnnotatedException e) {
            throw new AnnotatedException("Could not get issuer information from distribution point.", e);
        }
        if (cert instanceof X509Certificate) {
            baseCrlSelect.setCertificateChecking((X509Certificate)cert);
        }
        PKIXCRLStoreSelector<? extends CRL> crlSelect = new PKIXCRLStoreSelector.Builder(baseCrlSelect).setCompleteCRLEnabled(true).build();
        Date validityDate = currentDate;
        if (paramsPKIX.getDate() != null) {
            validityDate = paramsPKIX.getDate();
        }
        if ((crls = CRL_UTIL.findCRLs(crlSelect, validityDate, paramsPKIX.getCertStores(), paramsPKIX.getCRLStores())).isEmpty()) {
            X509Certificate xCert = (X509Certificate)cert;
            throw new AnnotatedException("No CRLs found for issuer \"" + xCert.getIssuerX500Principal() + "\"");
        }
        return crls;
    }

    protected static Date getValidCertDateFromValidityModel(PKIXExtendedParameters paramsPKIX, CertPath certPath, int index) throws AnnotatedException {
        if (paramsPKIX.getValidityModel() == 1) {
            if (index <= 0) {
                return CertPathValidatorUtilities.getValidDate(paramsPKIX);
            }
            if (index - 1 == 0) {
                ASN1GeneralizedTime dateOfCertgen = null;
                try {
                    byte[] extBytes = ((X509Certificate)certPath.getCertificates().get(index - 1)).getExtensionValue(ISISMTTObjectIdentifiers.id_isismtt_at_dateOfCertGen.getId());
                    if (extBytes != null) {
                        dateOfCertgen = ASN1GeneralizedTime.getInstance(ASN1Primitive.fromByteArray(extBytes));
                    }
                }
                catch (IOException e) {
                    throw new AnnotatedException("Date of cert gen extension could not be read.");
                }
                catch (IllegalArgumentException e) {
                    throw new AnnotatedException("Date of cert gen extension could not be read.");
                }
                if (dateOfCertgen != null) {
                    try {
                        return dateOfCertgen.getDate();
                    }
                    catch (ParseException e) {
                        throw new AnnotatedException("Date from date of cert gen extension could not be parsed.", e);
                    }
                }
                return ((X509Certificate)certPath.getCertificates().get(index - 1)).getNotBefore();
            }
            return ((X509Certificate)certPath.getCertificates().get(index - 1)).getNotBefore();
        }
        return CertPathValidatorUtilities.getValidDate(paramsPKIX);
    }

    protected static PublicKey getNextWorkingKey(List certs, int index, Provider fipsProvider) throws CertPathValidatorException {
        Certificate cert = (Certificate)certs.get(index);
        PublicKey pubKey = cert.getPublicKey();
        if (!(pubKey instanceof DSAPublicKey)) {
            return pubKey;
        }
        DSAPublicKey dsaPubKey = (DSAPublicKey)pubKey;
        if (dsaPubKey.getParams() != null) {
            return dsaPubKey;
        }
        for (int i = index + 1; i < certs.size(); ++i) {
            X509Certificate parentCert = (X509Certificate)certs.get(i);
            pubKey = parentCert.getPublicKey();
            if (!(pubKey instanceof DSAPublicKey)) {
                throw new CertPathValidatorException("DSA parameters cannot be inherited from previous certificate.");
            }
            DSAPublicKey prevDSAPubKey = (DSAPublicKey)pubKey;
            if (prevDSAPubKey.getParams() == null) continue;
            DSAParams dsaParams = prevDSAPubKey.getParams();
            DSAPublicKeySpec dsaPubKeySpec = new DSAPublicKeySpec(dsaPubKey.getY(), dsaParams.getP(), dsaParams.getQ(), dsaParams.getG());
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("DSA", fipsProvider);
                return keyFactory.generatePublic(dsaPubKeySpec);
            }
            catch (Exception exception) {
                throw new CertPathValidatorException(exception.getMessage(), exception);
            }
        }
        throw new CertPathValidatorException("DSA parameters cannot be inherited from previous certificate.");
    }

    static Collection findIssuerCerts(X509Certificate cert, List<CertStore> certStores, List<PKIXCertStore> pkixCertStores) throws AnnotatedException {
        Iterator iter;
        X509CertSelector selector = new X509CertSelector();
        try {
            selector.setSubject(cert.getIssuerX500Principal().getEncoded());
        }
        catch (IOException e) {
            throw new AnnotatedException("Subject criteria for certificate selector to find issuer certificate could not be set.", e);
        }
        PKIXCertStoreSelector<? extends Certificate> certSelect = new PKIXCertStoreSelector.Builder(selector).build();
        LinkedHashSet<X509Certificate> certs = new LinkedHashSet<X509Certificate>();
        try {
            ArrayList matches = new ArrayList();
            matches.addAll(CertPathValidatorUtilities.findCertificates(certSelect, certStores));
            matches.addAll(CertPathValidatorUtilities.findCertificates(certSelect, pkixCertStores));
            iter = matches.iterator();
        }
        catch (AnnotatedException e) {
            throw new AnnotatedException("Issuer certificate cannot be searched.", e);
        }
        X509Certificate issuer = null;
        while (iter.hasNext()) {
            issuer = (X509Certificate)iter.next();
            certs.add(issuer);
        }
        return certs;
    }

    protected static void verifyX509Certificate(X509Certificate cert, PublicKey publicKey, String sigProvider) throws GeneralSecurityException {
        if (sigProvider == null) {
            cert.verify(publicKey);
        } else {
            cert.verify(publicKey, sigProvider);
        }
    }
}

