/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.crypto.AsymmetricKey;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.OutputSigner;
import org.bouncycastle.crypto.OutputVerifier;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SignatureOperatorFactory;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsDigestAlgorithm;
import org.bouncycastle.crypto.fips.FipsRSA;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.DigestUtil;
import org.bouncycastle.jcajce.provider.PrivateKeyConverter;
import org.bouncycastle.jcajce.provider.PublicKeyConverter;
import org.bouncycastle.jcajce.provider.Utils;

class BaseSignature
extends SignatureSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private static final byte TRAILER_IMPLICIT = -68;
    private final SignatureOperatorFactory operatorFactory;
    private final PublicKeyConverter publicKeyConverter;
    private final PrivateKeyConverter privateKeyConverter;
    private final BouncyCastleFipsProvider fipsProvider;
    private final AlgorithmParameterSpec originalSpec;
    protected Parameters parameters;
    protected OutputVerifier verifier;
    protected OutputSigner signer;
    protected UpdateOutputStream dataStream;
    protected AlgorithmParameters engineParams;
    protected AlgorithmParameterSpec paramSpec;
    protected AsymmetricKey key;

    protected BaseSignature(BouncyCastleFipsProvider fipsProvider, SignatureOperatorFactory operatorFactory, PublicKeyConverter publicKeyConverter, PrivateKeyConverter privateKeyConverter, Parameters parameters) {
        this.fipsProvider = fipsProvider;
        this.operatorFactory = operatorFactory;
        this.publicKeyConverter = publicKeyConverter;
        this.privateKeyConverter = privateKeyConverter;
        this.parameters = parameters;
        this.originalSpec = null;
    }

    protected BaseSignature(BouncyCastleFipsProvider fipsProvider, SignatureOperatorFactory operatorFactory, PublicKeyConverter publicKeyConverter, PrivateKeyConverter privateKeyConverter, Parameters parameters, AlgorithmParameterSpec paramSpec) {
        this.fipsProvider = fipsProvider;
        this.operatorFactory = operatorFactory;
        this.publicKeyConverter = publicKeyConverter;
        this.privateKeyConverter = privateKeyConverter;
        this.parameters = parameters;
        this.paramSpec = paramSpec;
        this.originalSpec = paramSpec;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.key = this.publicKeyConverter.convertKey(this.parameters.getAlgorithm(), publicKey);
        this.verifier = this.operatorFactory.createVerifier((AsymmetricPublicKey)this.key, this.parameters);
        this.dataStream = this.verifier.getVerifyingStream();
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.key = this.privateKeyConverter.convertKey(this.parameters.getAlgorithm(), privateKey);
        try {
            this.signer = Utils.addRandomIfNeeded(this.operatorFactory.createSigner((AsymmetricPrivateKey)this.key, this.parameters), this.fipsProvider.getDefaultSecureRandom());
            this.dataStream = this.signer.getSigningStream();
        }
        catch (Exception e) {
            throw new InvalidKeyException("Cannot initialize for signing: " + e.getMessage(), e);
        }
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.key = this.privateKeyConverter.convertKey(this.parameters.getAlgorithm(), privateKey);
        this.signer = Utils.addRandomIfNeeded(this.operatorFactory.createSigner((AsymmetricPrivateKey)this.key, this.parameters), random != null ? random : this.fipsProvider.getDefaultSecureRandom());
        this.dataStream = this.signer.getSigningStream();
    }

    protected void engineUpdate(byte b) throws SignatureException {
        this.dataStream.update(b);
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.dataStream.update(b, off, len);
    }

    protected byte[] engineSign() throws SignatureException {
        try {
            return this.signer.getSignature();
        }
        catch (Exception e) {
            throw new SignatureException(e.toString(), e);
        }
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        try {
            return this.verifier.isVerified(sigBytes);
        }
        catch (Exception e) {
            throw new SignatureException(e.toString(), e);
        }
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params == null) {
            if (this.originalSpec != null) {
                params = this.originalSpec;
            } else {
                return;
            }
        }
        if (params instanceof PSSParameterSpec) {
            PSSParameterSpec newParamSpec = (PSSParameterSpec)params;
            if (this.originalSpec instanceof PSSParameterSpec) {
                PSSParameterSpec origPssSpec = (PSSParameterSpec)this.originalSpec;
                if (this.originalSpec != PSSParameterSpec.DEFAULT && !DigestUtil.isSameDigest(origPssSpec.getDigestAlgorithm(), newParamSpec.getDigestAlgorithm())) {
                    throw new InvalidAlgorithmParameterException("Parameter must be using " + origPssSpec.getDigestAlgorithm());
                }
            }
            if (!newParamSpec.getMGFAlgorithm().equalsIgnoreCase("MGF1") && !newParamSpec.getMGFAlgorithm().equals(PKCSObjectIdentifiers.id_mgf1.getId())) {
                throw new InvalidAlgorithmParameterException("Unknown mask generation function specified");
            }
            if (!(newParamSpec.getMGFParameters() instanceof MGF1ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Unknown MGF parameters");
            }
            MGF1ParameterSpec mgfParams = (MGF1ParameterSpec)newParamSpec.getMGFParameters();
            if (!DigestUtil.isSameDigest(mgfParams.getDigestAlgorithm(), newParamSpec.getDigestAlgorithm())) {
                throw new InvalidAlgorithmParameterException("Digest algorithm for MGF should be the same as for PSS parameters.");
            }
            DigestAlgorithm newDigest = DigestUtil.getDigestID(mgfParams.getDigestAlgorithm());
            if (newDigest == null) {
                throw new InvalidAlgorithmParameterException("No match on MGF digest algorithm: " + mgfParams.getDigestAlgorithm());
            }
            if (!(newDigest instanceof FipsAlgorithm)) {
                throw new InvalidAlgorithmParameterException("Digest algorithm not supported: " + mgfParams.getDigestAlgorithm());
            }
            this.parameters = FipsRSA.PSS.withDigestAlgorithm((FipsDigestAlgorithm)newDigest).withMGFDigest((FipsDigestAlgorithm)newDigest).withSaltLength(newParamSpec.getSaltLength()).withTrailer(this.getPssTrailer(newParamSpec.getTrailerField()));
            this.paramSpec = newParamSpec;
            if (this.dataStream != null) {
                if (this.key instanceof AsymmetricPrivateKey) {
                    this.signer = Utils.addRandomIfNeeded(this.operatorFactory.createSigner((AsymmetricPrivateKey)this.key, this.parameters), this.fipsProvider.getDefaultSecureRandom());
                    this.dataStream = this.signer.getSigningStream();
                } else {
                    this.verifier = this.operatorFactory.createVerifier((AsymmetricPublicKey)this.key, this.parameters);
                    this.dataStream = this.verifier.getVerifyingStream();
                }
            }
        } else {
            throw new InvalidAlgorithmParameterException("Only PSSParameterSpec supported");
        }
    }

    private byte getPssTrailer(int trailerField) {
        if (trailerField == 1) {
            return -68;
        }
        throw new IllegalArgumentException("Unknown trailer field");
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.paramSpec != null) {
            try {
                this.engineParams = AlgorithmParameters.getInstance("PSS", this.fipsProvider);
                this.engineParams.init(this.paramSpec);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.toString(), e);
            }
        }
        return this.engineParams;
    }

    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("SetParameter unsupported");
    }

    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("GetParameter unsupported");
    }
}

