/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import org.bouncycastle.crypto.SymmetricKeyGenerator;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.KeyGeneratorCreator;
import org.bouncycastle.jcajce.provider.ProvSecretKeySpec;

final class BaseKeyGenerator
extends KeyGeneratorSpi {
    private final BouncyCastleFipsProvider fipsProvider;
    private final String algorithmName;
    private final KeyGeneratorCreator keyGeneratorCreator;
    private final int defaultKeySize;
    private final boolean fixedKeySize;
    private SymmetricKeyGenerator engine;

    BaseKeyGenerator(BouncyCastleFipsProvider fipsProvider, String algorithmName, int defaultKeySize, KeyGeneratorCreator keyGeneratorCreator) {
        this(fipsProvider, algorithmName, defaultKeySize, false, keyGeneratorCreator);
    }

    BaseKeyGenerator(BouncyCastleFipsProvider fipsProvider, String algorithmName, int defaultKeySize, boolean fixedKeySize, KeyGeneratorCreator keyGeneratorCreator) {
        this.fipsProvider = fipsProvider;
        this.algorithmName = algorithmName;
        this.defaultKeySize = defaultKeySize;
        this.keyGeneratorCreator = keyGeneratorCreator;
        this.fixedKeySize = fixedKeySize;
    }

    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("No AlgorithmParameterSpec are supported");
    }

    protected void engineInit(SecureRandom random) {
        if (random != null) {
            this.engine = this.keyGeneratorCreator.createInstance(this.defaultKeySize, random);
        }
    }

    protected void engineInit(int keySize, SecureRandom random) {
        if (this.fixedKeySize && keySize != this.defaultKeySize) {
            throw new InvalidParameterException("Attempt to change keysize for fixed size key generator");
        }
        try {
            if (random == null) {
                random = this.fipsProvider.getDefaultSecureRandom();
            }
            this.engine = this.keyGeneratorCreator.createInstance(keySize, random);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidParameterException(e.getMessage());
        }
    }

    protected SecretKey engineGenerateKey() {
        if (this.engine == null) {
            this.engine = this.keyGeneratorCreator.createInstance(this.defaultKeySize, this.fipsProvider.getDefaultSecureRandom());
        }
        final Object symmetricKey = this.engine.generateKey();
        return AccessController.doPrivileged(new PrivilegedAction<SecretKey>(){

            @Override
            public SecretKey run() {
                return new ProvSecretKeySpec(new ValidatedSymmetricKey(symmetricKey.getAlgorithm(), symmetricKey.getKeyBytes()), BaseKeyGenerator.this.algorithmName);
            }
        });
    }
}

