/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.general.MD5Digest;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.PBEParametersGenerator;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OpenSSLPBEParametersGenerator<T extends Parameters>
extends PBEParametersGenerator<T> {
    private Digest digest = new MD5Digest();

    public OpenSSLPBEParametersGenerator(T parameters) {
        super(parameters);
    }

    public void init(byte[] password, byte[] salt) {
        super.init(password, salt, 1);
    }

    private byte[] generateDerivedKey(int bytesNeeded) {
        byte[] buf = new byte[this.digest.getDigestSize()];
        byte[] key = new byte[bytesNeeded];
        int offset = 0;
        while (true) {
            this.digest.update(this.password, 0, this.password.length);
            this.digest.update(this.salt, 0, this.salt.length);
            this.digest.doFinal(buf, 0);
            int len = bytesNeeded > buf.length ? buf.length : bytesNeeded;
            System.arraycopy(buf, 0, key, offset, len);
            offset += len;
            if ((bytesNeeded -= len) == 0) break;
            this.digest.reset();
            this.digest.update(buf, 0, buf.length);
        }
        return key;
    }

    @Override
    public CipherParameters generateDerivedParameters(int keySize) {
        byte[] dKey = this.generateDerivedKey(keySize /= 8);
        return new KeyParameterImpl(dKey);
    }

    @Override
    public CipherParameters generateDerivedParameters(int keySize, int ivSize) {
        byte[] dKey = this.generateDerivedKey((keySize /= 8) + (ivSize /= 8));
        return new ParametersWithIV(new KeyParameterImpl(Arrays.copyOfRange(dKey, 0, keySize)), dKey, keySize, ivSize);
    }

    @Override
    public CipherParameters generateDerivedMacParameters(int keySize) {
        return this.generateDerivedParameters(keySize);
    }

    @Override
    public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int keySizeInBytes) {
        return this.generateDerivedKey(keySizeInBytes);
    }

    @Override
    public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int keySizeInBytes, int ivSizeInBytes) {
        byte[] dKey = this.generateDerivedKey(keySizeInBytes + ivSizeInBytes);
        return new byte[][]{Arrays.copyOfRange(dKey, 0, keySizeInBytes), Arrays.copyOfRange(dKey, keySizeInBytes, keySizeInBytes + ivSizeInBytes)};
    }
}

