/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.general.DRBG;
import org.bouncycastle.crypto.util.EntropyUtil;

public final class GeneralSecureRandom
extends SecureRandom {
    private final SecureRandom randomSource;
    private final DRBG drbg;
    private final EntropySource entropySource;
    private final boolean predictionResistant;

    GeneralSecureRandom(SecureRandom randomSource, DRBG drbg, EntropySource entropySource, boolean predictionResistant) {
        this.randomSource = randomSource;
        this.drbg = drbg;
        this.entropySource = entropySource;
        this.predictionResistant = predictionResistant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSeed(byte[] seed) {
        GeneralSecureRandom generalSecureRandom = this;
        synchronized (generalSecureRandom) {
            if (this.randomSource != null) {
                this.randomSource.setSeed(seed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSeed(long seed) {
        GeneralSecureRandom generalSecureRandom = this;
        synchronized (generalSecureRandom) {
            if (this.randomSource != null) {
                this.randomSource.setSeed(seed);
            }
        }
    }

    public void nextBytes(byte[] bytes) {
        this.nextBytes(bytes, (byte[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextBytes(byte[] bytes, byte[] additionalInput) {
        GeneralSecureRandom generalSecureRandom = this;
        synchronized (generalSecureRandom) {
            if (bytes == null) {
                throw new NullPointerException("bytes cannot be null");
            }
            if (bytes.length != 0 && this.drbg.generate(bytes, additionalInput, this.predictionResistant) < 0) {
                this.drbg.reseed(null);
                this.drbg.generate(bytes, additionalInput, this.predictionResistant);
            }
        }
    }

    public byte[] generateSeed(int numBytes) {
        return EntropyUtil.generateSeed(this.entropySource, numBytes);
    }

    public int getBlockSize() {
        return this.drbg.getBlockSize();
    }

    public void reseed() {
        this.drbg.reseed(null);
    }

    public void reseed(byte[] additionalInput) {
        this.drbg.reseed(additionalInput);
    }
}

